/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.configdelivery.v1.AbortRolloutRequest;
import com.google.cloud.configdelivery.v1.ConfigDeliverySettings;
import com.google.cloud.configdelivery.v1.CreateFleetPackageRequest;
import com.google.cloud.configdelivery.v1.CreateReleaseRequest;
import com.google.cloud.configdelivery.v1.CreateResourceBundleRequest;
import com.google.cloud.configdelivery.v1.CreateVariantRequest;
import com.google.cloud.configdelivery.v1.DeleteFleetPackageRequest;
import com.google.cloud.configdelivery.v1.DeleteReleaseRequest;
import com.google.cloud.configdelivery.v1.DeleteResourceBundleRequest;
import com.google.cloud.configdelivery.v1.DeleteVariantRequest;
import com.google.cloud.configdelivery.v1.FleetPackage;
import com.google.cloud.configdelivery.v1.FleetPackageName;
import com.google.cloud.configdelivery.v1.GetFleetPackageRequest;
import com.google.cloud.configdelivery.v1.GetReleaseRequest;
import com.google.cloud.configdelivery.v1.GetResourceBundleRequest;
import com.google.cloud.configdelivery.v1.GetRolloutRequest;
import com.google.cloud.configdelivery.v1.GetVariantRequest;
import com.google.cloud.configdelivery.v1.ListFleetPackagesRequest;
import com.google.cloud.configdelivery.v1.ListFleetPackagesResponse;
import com.google.cloud.configdelivery.v1.ListReleasesRequest;
import com.google.cloud.configdelivery.v1.ListReleasesResponse;
import com.google.cloud.configdelivery.v1.ListResourceBundlesRequest;
import com.google.cloud.configdelivery.v1.ListResourceBundlesResponse;
import com.google.cloud.configdelivery.v1.ListRolloutsRequest;
import com.google.cloud.configdelivery.v1.ListRolloutsResponse;
import com.google.cloud.configdelivery.v1.ListVariantsRequest;
import com.google.cloud.configdelivery.v1.ListVariantsResponse;
import com.google.cloud.configdelivery.v1.LocationName;
import com.google.cloud.configdelivery.v1.OperationMetadata;
import com.google.cloud.configdelivery.v1.Release;
import com.google.cloud.configdelivery.v1.ReleaseName;
import com.google.cloud.configdelivery.v1.ResourceBundle;
import com.google.cloud.configdelivery.v1.ResourceBundleName;
import com.google.cloud.configdelivery.v1.ResumeRolloutRequest;
import com.google.cloud.configdelivery.v1.Rollout;
import com.google.cloud.configdelivery.v1.RolloutName;
import com.google.cloud.configdelivery.v1.SuspendRolloutRequest;
import com.google.cloud.configdelivery.v1.UpdateFleetPackageRequest;
import com.google.cloud.configdelivery.v1.UpdateReleaseRequest;
import com.google.cloud.configdelivery.v1.UpdateResourceBundleRequest;
import com.google.cloud.configdelivery.v1.UpdateVariantRequest;
import com.google.cloud.configdelivery.v1.Variant;
import com.google.cloud.configdelivery.v1.VariantName;
import com.google.cloud.configdelivery.v1.stub.ConfigDeliveryStub;
import com.google.cloud.configdelivery.v1.stub.ConfigDeliveryStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConfigDeliveryClient
implements BackgroundResource {
    private final ConfigDeliverySettings settings;
    private final ConfigDeliveryStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConfigDeliveryClient create() throws IOException {
        return ConfigDeliveryClient.create(ConfigDeliverySettings.newBuilder().build());
    }

    public static final ConfigDeliveryClient create(ConfigDeliverySettings settings) throws IOException {
        return new ConfigDeliveryClient(settings);
    }

    public static final ConfigDeliveryClient create(ConfigDeliveryStub stub) {
        return new ConfigDeliveryClient(stub);
    }

    protected ConfigDeliveryClient(ConfigDeliverySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConfigDeliveryStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConfigDeliveryClient(ConfigDeliveryStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConfigDeliverySettings getSettings() {
        return this.settings;
    }

    public ConfigDeliveryStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListResourceBundlesPagedResponse listResourceBundles(LocationName parent) {
        ListResourceBundlesRequest request = ListResourceBundlesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceBundles(request);
    }

    public final ListResourceBundlesPagedResponse listResourceBundles(String parent) {
        ListResourceBundlesRequest request = ListResourceBundlesRequest.newBuilder().setParent(parent).build();
        return this.listResourceBundles(request);
    }

    public final ListResourceBundlesPagedResponse listResourceBundles(ListResourceBundlesRequest request) {
        return (ListResourceBundlesPagedResponse)((Object)this.listResourceBundlesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceBundlesRequest, ListResourceBundlesPagedResponse> listResourceBundlesPagedCallable() {
        return this.stub.listResourceBundlesPagedCallable();
    }

    public final UnaryCallable<ListResourceBundlesRequest, ListResourceBundlesResponse> listResourceBundlesCallable() {
        return this.stub.listResourceBundlesCallable();
    }

    public final ResourceBundle getResourceBundle(ResourceBundleName name) {
        GetResourceBundleRequest request = GetResourceBundleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceBundle(request);
    }

    public final ResourceBundle getResourceBundle(String name) {
        GetResourceBundleRequest request = GetResourceBundleRequest.newBuilder().setName(name).build();
        return this.getResourceBundle(request);
    }

    public final ResourceBundle getResourceBundle(GetResourceBundleRequest request) {
        return (ResourceBundle)this.getResourceBundleCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceBundleRequest, ResourceBundle> getResourceBundleCallable() {
        return this.stub.getResourceBundleCallable();
    }

    public final OperationFuture<ResourceBundle, OperationMetadata> createResourceBundleAsync(LocationName parent, ResourceBundle resourceBundle, String resourceBundleId) {
        CreateResourceBundleRequest request = CreateResourceBundleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResourceBundle(resourceBundle).setResourceBundleId(resourceBundleId).build();
        return this.createResourceBundleAsync(request);
    }

    public final OperationFuture<ResourceBundle, OperationMetadata> createResourceBundleAsync(String parent, ResourceBundle resourceBundle, String resourceBundleId) {
        CreateResourceBundleRequest request = CreateResourceBundleRequest.newBuilder().setParent(parent).setResourceBundle(resourceBundle).setResourceBundleId(resourceBundleId).build();
        return this.createResourceBundleAsync(request);
    }

    public final OperationFuture<ResourceBundle, OperationMetadata> createResourceBundleAsync(CreateResourceBundleRequest request) {
        return this.createResourceBundleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateResourceBundleRequest, ResourceBundle, OperationMetadata> createResourceBundleOperationCallable() {
        return this.stub.createResourceBundleOperationCallable();
    }

    public final UnaryCallable<CreateResourceBundleRequest, Operation> createResourceBundleCallable() {
        return this.stub.createResourceBundleCallable();
    }

    public final OperationFuture<ResourceBundle, OperationMetadata> updateResourceBundleAsync(ResourceBundle resourceBundle, FieldMask updateMask) {
        UpdateResourceBundleRequest request = UpdateResourceBundleRequest.newBuilder().setResourceBundle(resourceBundle).setUpdateMask(updateMask).build();
        return this.updateResourceBundleAsync(request);
    }

    public final OperationFuture<ResourceBundle, OperationMetadata> updateResourceBundleAsync(UpdateResourceBundleRequest request) {
        return this.updateResourceBundleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateResourceBundleRequest, ResourceBundle, OperationMetadata> updateResourceBundleOperationCallable() {
        return this.stub.updateResourceBundleOperationCallable();
    }

    public final UnaryCallable<UpdateResourceBundleRequest, Operation> updateResourceBundleCallable() {
        return this.stub.updateResourceBundleCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceBundleAsync(ResourceBundleName name) {
        DeleteResourceBundleRequest request = DeleteResourceBundleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteResourceBundleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceBundleAsync(String name) {
        DeleteResourceBundleRequest request = DeleteResourceBundleRequest.newBuilder().setName(name).build();
        return this.deleteResourceBundleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteResourceBundleAsync(DeleteResourceBundleRequest request) {
        return this.deleteResourceBundleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteResourceBundleRequest, Empty, OperationMetadata> deleteResourceBundleOperationCallable() {
        return this.stub.deleteResourceBundleOperationCallable();
    }

    public final UnaryCallable<DeleteResourceBundleRequest, Operation> deleteResourceBundleCallable() {
        return this.stub.deleteResourceBundleCallable();
    }

    public final ListFleetPackagesPagedResponse listFleetPackages(LocationName parent) {
        ListFleetPackagesRequest request = ListFleetPackagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFleetPackages(request);
    }

    public final ListFleetPackagesPagedResponse listFleetPackages(String parent) {
        ListFleetPackagesRequest request = ListFleetPackagesRequest.newBuilder().setParent(parent).build();
        return this.listFleetPackages(request);
    }

    public final ListFleetPackagesPagedResponse listFleetPackages(ListFleetPackagesRequest request) {
        return (ListFleetPackagesPagedResponse)((Object)this.listFleetPackagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFleetPackagesRequest, ListFleetPackagesPagedResponse> listFleetPackagesPagedCallable() {
        return this.stub.listFleetPackagesPagedCallable();
    }

    public final UnaryCallable<ListFleetPackagesRequest, ListFleetPackagesResponse> listFleetPackagesCallable() {
        return this.stub.listFleetPackagesCallable();
    }

    public final FleetPackage getFleetPackage(FleetPackageName name) {
        GetFleetPackageRequest request = GetFleetPackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFleetPackage(request);
    }

    public final FleetPackage getFleetPackage(String name) {
        GetFleetPackageRequest request = GetFleetPackageRequest.newBuilder().setName(name).build();
        return this.getFleetPackage(request);
    }

    public final FleetPackage getFleetPackage(GetFleetPackageRequest request) {
        return (FleetPackage)this.getFleetPackageCallable().call((Object)request);
    }

    public final UnaryCallable<GetFleetPackageRequest, FleetPackage> getFleetPackageCallable() {
        return this.stub.getFleetPackageCallable();
    }

    public final OperationFuture<FleetPackage, OperationMetadata> createFleetPackageAsync(LocationName parent, FleetPackage fleetPackage, String fleetPackageId) {
        CreateFleetPackageRequest request = CreateFleetPackageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFleetPackage(fleetPackage).setFleetPackageId(fleetPackageId).build();
        return this.createFleetPackageAsync(request);
    }

    public final OperationFuture<FleetPackage, OperationMetadata> createFleetPackageAsync(String parent, FleetPackage fleetPackage, String fleetPackageId) {
        CreateFleetPackageRequest request = CreateFleetPackageRequest.newBuilder().setParent(parent).setFleetPackage(fleetPackage).setFleetPackageId(fleetPackageId).build();
        return this.createFleetPackageAsync(request);
    }

    public final OperationFuture<FleetPackage, OperationMetadata> createFleetPackageAsync(CreateFleetPackageRequest request) {
        return this.createFleetPackageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFleetPackageRequest, FleetPackage, OperationMetadata> createFleetPackageOperationCallable() {
        return this.stub.createFleetPackageOperationCallable();
    }

    public final UnaryCallable<CreateFleetPackageRequest, Operation> createFleetPackageCallable() {
        return this.stub.createFleetPackageCallable();
    }

    public final OperationFuture<FleetPackage, OperationMetadata> updateFleetPackageAsync(FleetPackage fleetPackage, FieldMask updateMask) {
        UpdateFleetPackageRequest request = UpdateFleetPackageRequest.newBuilder().setFleetPackage(fleetPackage).setUpdateMask(updateMask).build();
        return this.updateFleetPackageAsync(request);
    }

    public final OperationFuture<FleetPackage, OperationMetadata> updateFleetPackageAsync(UpdateFleetPackageRequest request) {
        return this.updateFleetPackageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFleetPackageRequest, FleetPackage, OperationMetadata> updateFleetPackageOperationCallable() {
        return this.stub.updateFleetPackageOperationCallable();
    }

    public final UnaryCallable<UpdateFleetPackageRequest, Operation> updateFleetPackageCallable() {
        return this.stub.updateFleetPackageCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFleetPackageAsync(FleetPackageName name) {
        DeleteFleetPackageRequest request = DeleteFleetPackageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFleetPackageAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFleetPackageAsync(String name) {
        DeleteFleetPackageRequest request = DeleteFleetPackageRequest.newBuilder().setName(name).build();
        return this.deleteFleetPackageAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFleetPackageAsync(DeleteFleetPackageRequest request) {
        return this.deleteFleetPackageOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFleetPackageRequest, Empty, OperationMetadata> deleteFleetPackageOperationCallable() {
        return this.stub.deleteFleetPackageOperationCallable();
    }

    public final UnaryCallable<DeleteFleetPackageRequest, Operation> deleteFleetPackageCallable() {
        return this.stub.deleteFleetPackageCallable();
    }

    public final ListReleasesPagedResponse listReleases(ResourceBundleName parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(String parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(ListReleasesRequest request) {
        return (ListReleasesPagedResponse)((Object)this.listReleasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesPagedResponse> listReleasesPagedCallable() {
        return this.stub.listReleasesPagedCallable();
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesResponse> listReleasesCallable() {
        return this.stub.listReleasesCallable();
    }

    public final Release getRelease(ReleaseName name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRelease(request);
    }

    public final Release getRelease(String name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name).build();
        return this.getRelease(request);
    }

    public final Release getRelease(GetReleaseRequest request) {
        return (Release)this.getReleaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetReleaseRequest, Release> getReleaseCallable() {
        return this.stub.getReleaseCallable();
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(ResourceBundleName parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(String parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(CreateReleaseRequest request) {
        return this.createReleaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationCallable() {
        return this.stub.createReleaseOperationCallable();
    }

    public final UnaryCallable<CreateReleaseRequest, Operation> createReleaseCallable() {
        return this.stub.createReleaseCallable();
    }

    public final OperationFuture<Release, OperationMetadata> updateReleaseAsync(Release release, FieldMask updateMask) {
        UpdateReleaseRequest request = UpdateReleaseRequest.newBuilder().setRelease(release).setUpdateMask(updateMask).build();
        return this.updateReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> updateReleaseAsync(UpdateReleaseRequest request) {
        return this.updateReleaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateReleaseRequest, Release, OperationMetadata> updateReleaseOperationCallable() {
        return this.stub.updateReleaseOperationCallable();
    }

    public final UnaryCallable<UpdateReleaseRequest, Operation> updateReleaseCallable() {
        return this.stub.updateReleaseCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReleaseAsync(ReleaseName name) {
        DeleteReleaseRequest request = DeleteReleaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReleaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReleaseAsync(String name) {
        DeleteReleaseRequest request = DeleteReleaseRequest.newBuilder().setName(name).build();
        return this.deleteReleaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReleaseAsync(DeleteReleaseRequest request) {
        return this.deleteReleaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteReleaseRequest, Empty, OperationMetadata> deleteReleaseOperationCallable() {
        return this.stub.deleteReleaseOperationCallable();
    }

    public final UnaryCallable<DeleteReleaseRequest, Operation> deleteReleaseCallable() {
        return this.stub.deleteReleaseCallable();
    }

    public final ListVariantsPagedResponse listVariants(ReleaseName parent) {
        ListVariantsRequest request = ListVariantsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVariants(request);
    }

    public final ListVariantsPagedResponse listVariants(String parent) {
        ListVariantsRequest request = ListVariantsRequest.newBuilder().setParent(parent).build();
        return this.listVariants(request);
    }

    public final ListVariantsPagedResponse listVariants(ListVariantsRequest request) {
        return (ListVariantsPagedResponse)((Object)this.listVariantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVariantsRequest, ListVariantsPagedResponse> listVariantsPagedCallable() {
        return this.stub.listVariantsPagedCallable();
    }

    public final UnaryCallable<ListVariantsRequest, ListVariantsResponse> listVariantsCallable() {
        return this.stub.listVariantsCallable();
    }

    public final Variant getVariant(VariantName name) {
        GetVariantRequest request = GetVariantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVariant(request);
    }

    public final Variant getVariant(String name) {
        GetVariantRequest request = GetVariantRequest.newBuilder().setName(name).build();
        return this.getVariant(request);
    }

    public final Variant getVariant(GetVariantRequest request) {
        return (Variant)this.getVariantCallable().call((Object)request);
    }

    public final UnaryCallable<GetVariantRequest, Variant> getVariantCallable() {
        return this.stub.getVariantCallable();
    }

    public final OperationFuture<Variant, OperationMetadata> createVariantAsync(ReleaseName parent, Variant variant, String variantId) {
        CreateVariantRequest request = CreateVariantRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVariant(variant).setVariantId(variantId).build();
        return this.createVariantAsync(request);
    }

    public final OperationFuture<Variant, OperationMetadata> createVariantAsync(String parent, Variant variant, String variantId) {
        CreateVariantRequest request = CreateVariantRequest.newBuilder().setParent(parent).setVariant(variant).setVariantId(variantId).build();
        return this.createVariantAsync(request);
    }

    public final OperationFuture<Variant, OperationMetadata> createVariantAsync(CreateVariantRequest request) {
        return this.createVariantOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVariantRequest, Variant, OperationMetadata> createVariantOperationCallable() {
        return this.stub.createVariantOperationCallable();
    }

    public final UnaryCallable<CreateVariantRequest, Operation> createVariantCallable() {
        return this.stub.createVariantCallable();
    }

    public final OperationFuture<Variant, OperationMetadata> updateVariantAsync(Variant variant, FieldMask updateMask) {
        UpdateVariantRequest request = UpdateVariantRequest.newBuilder().setVariant(variant).setUpdateMask(updateMask).build();
        return this.updateVariantAsync(request);
    }

    public final OperationFuture<Variant, OperationMetadata> updateVariantAsync(UpdateVariantRequest request) {
        return this.updateVariantOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVariantRequest, Variant, OperationMetadata> updateVariantOperationCallable() {
        return this.stub.updateVariantOperationCallable();
    }

    public final UnaryCallable<UpdateVariantRequest, Operation> updateVariantCallable() {
        return this.stub.updateVariantCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVariantAsync(VariantName name) {
        DeleteVariantRequest request = DeleteVariantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVariantAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVariantAsync(String name) {
        DeleteVariantRequest request = DeleteVariantRequest.newBuilder().setName(name).build();
        return this.deleteVariantAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVariantAsync(DeleteVariantRequest request) {
        return this.deleteVariantOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVariantRequest, Empty, OperationMetadata> deleteVariantOperationCallable() {
        return this.stub.deleteVariantOperationCallable();
    }

    public final UnaryCallable<DeleteVariantRequest, Operation> deleteVariantCallable() {
        return this.stub.deleteVariantCallable();
    }

    public final ListRolloutsPagedResponse listRollouts(FleetPackageName parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(String parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(ListRolloutsRequest request) {
        return (ListRolloutsPagedResponse)((Object)this.listRolloutsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsPagedResponse> listRolloutsPagedCallable() {
        return this.stub.listRolloutsPagedCallable();
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsResponse> listRolloutsCallable() {
        return this.stub.listRolloutsCallable();
    }

    public final Rollout getRollout(RolloutName name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(String name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(GetRolloutRequest request) {
        return (Rollout)this.getRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<GetRolloutRequest, Rollout> getRolloutCallable() {
        return this.stub.getRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> suspendRolloutAsync(RolloutName name) {
        SuspendRolloutRequest request = SuspendRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.suspendRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> suspendRolloutAsync(String name) {
        SuspendRolloutRequest request = SuspendRolloutRequest.newBuilder().setName(name).build();
        return this.suspendRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> suspendRolloutAsync(SuspendRolloutRequest request) {
        return this.suspendRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SuspendRolloutRequest, Rollout, OperationMetadata> suspendRolloutOperationCallable() {
        return this.stub.suspendRolloutOperationCallable();
    }

    public final UnaryCallable<SuspendRolloutRequest, Operation> suspendRolloutCallable() {
        return this.stub.suspendRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> resumeRolloutAsync(RolloutName name) {
        ResumeRolloutRequest request = ResumeRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> resumeRolloutAsync(String name) {
        ResumeRolloutRequest request = ResumeRolloutRequest.newBuilder().setName(name).build();
        return this.resumeRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> resumeRolloutAsync(ResumeRolloutRequest request) {
        return this.resumeRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeRolloutRequest, Rollout, OperationMetadata> resumeRolloutOperationCallable() {
        return this.stub.resumeRolloutOperationCallable();
    }

    public final UnaryCallable<ResumeRolloutRequest, Operation> resumeRolloutCallable() {
        return this.stub.resumeRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> abortRolloutAsync(RolloutName name) {
        AbortRolloutRequest request = AbortRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.abortRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> abortRolloutAsync(String name) {
        AbortRolloutRequest request = AbortRolloutRequest.newBuilder().setName(name).build();
        return this.abortRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> abortRolloutAsync(AbortRolloutRequest request) {
        return this.abortRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AbortRolloutRequest, Rollout, OperationMetadata> abortRolloutOperationCallable() {
        return this.stub.abortRolloutOperationCallable();
    }

    public final UnaryCallable<AbortRolloutRequest, Operation> abortRolloutCallable() {
        return this.stub.abortRolloutCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRolloutsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        private ListRolloutsFixedSizeCollection(List<ListRolloutsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRolloutsFixedSizeCollection createEmptyCollection() {
            return new ListRolloutsFixedSizeCollection(null, 0);
        }

        protected ListRolloutsFixedSizeCollection createCollection(List<ListRolloutsPage> pages, int collectionSize) {
            return new ListRolloutsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRolloutsPage
    extends AbstractPage<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage> {
        private ListRolloutsPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            super(context, (Object)response);
        }

        private static ListRolloutsPage createEmptyPage() {
            return new ListRolloutsPage(null, null);
        }

        protected ListRolloutsPage createPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            return new ListRolloutsPage(context, response);
        }

        public ApiFuture<ListRolloutsPage> createPageAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRolloutsPagedResponse
    extends AbstractPagedListResponse<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        public static ApiFuture<ListRolloutsPagedResponse> createAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            ApiFuture<ListRolloutsPage> futurePage = ListRolloutsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRolloutsPagedResponse((ListRolloutsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRolloutsPagedResponse(ListRolloutsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRolloutsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVariantsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVariantsRequest, ListVariantsResponse, Variant, ListVariantsPage, ListVariantsFixedSizeCollection> {
        private ListVariantsFixedSizeCollection(List<ListVariantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVariantsFixedSizeCollection createEmptyCollection() {
            return new ListVariantsFixedSizeCollection(null, 0);
        }

        protected ListVariantsFixedSizeCollection createCollection(List<ListVariantsPage> pages, int collectionSize) {
            return new ListVariantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVariantsPage
    extends AbstractPage<ListVariantsRequest, ListVariantsResponse, Variant, ListVariantsPage> {
        private ListVariantsPage(PageContext<ListVariantsRequest, ListVariantsResponse, Variant> context, ListVariantsResponse response) {
            super(context, (Object)response);
        }

        private static ListVariantsPage createEmptyPage() {
            return new ListVariantsPage(null, null);
        }

        protected ListVariantsPage createPage(PageContext<ListVariantsRequest, ListVariantsResponse, Variant> context, ListVariantsResponse response) {
            return new ListVariantsPage(context, response);
        }

        public ApiFuture<ListVariantsPage> createPageAsync(PageContext<ListVariantsRequest, ListVariantsResponse, Variant> context, ApiFuture<ListVariantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVariantsPagedResponse
    extends AbstractPagedListResponse<ListVariantsRequest, ListVariantsResponse, Variant, ListVariantsPage, ListVariantsFixedSizeCollection> {
        public static ApiFuture<ListVariantsPagedResponse> createAsync(PageContext<ListVariantsRequest, ListVariantsResponse, Variant> context, ApiFuture<ListVariantsResponse> futureResponse) {
            ApiFuture<ListVariantsPage> futurePage = ListVariantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVariantsPagedResponse((ListVariantsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVariantsPagedResponse(ListVariantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVariantsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReleasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        private ListReleasesFixedSizeCollection(List<ListReleasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReleasesFixedSizeCollection createEmptyCollection() {
            return new ListReleasesFixedSizeCollection(null, 0);
        }

        protected ListReleasesFixedSizeCollection createCollection(List<ListReleasesPage> pages, int collectionSize) {
            return new ListReleasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReleasesPage
    extends AbstractPage<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage> {
        private ListReleasesPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            super(context, (Object)response);
        }

        private static ListReleasesPage createEmptyPage() {
            return new ListReleasesPage(null, null);
        }

        protected ListReleasesPage createPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            return new ListReleasesPage(context, response);
        }

        public ApiFuture<ListReleasesPage> createPageAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReleasesPagedResponse
    extends AbstractPagedListResponse<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        public static ApiFuture<ListReleasesPagedResponse> createAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            ApiFuture<ListReleasesPage> futurePage = ListReleasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReleasesPagedResponse((ListReleasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReleasesPagedResponse(ListReleasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReleasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFleetPackagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage, ListFleetPackagesPage, ListFleetPackagesFixedSizeCollection> {
        private ListFleetPackagesFixedSizeCollection(List<ListFleetPackagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFleetPackagesFixedSizeCollection createEmptyCollection() {
            return new ListFleetPackagesFixedSizeCollection(null, 0);
        }

        protected ListFleetPackagesFixedSizeCollection createCollection(List<ListFleetPackagesPage> pages, int collectionSize) {
            return new ListFleetPackagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFleetPackagesPage
    extends AbstractPage<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage, ListFleetPackagesPage> {
        private ListFleetPackagesPage(PageContext<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage> context, ListFleetPackagesResponse response) {
            super(context, (Object)response);
        }

        private static ListFleetPackagesPage createEmptyPage() {
            return new ListFleetPackagesPage(null, null);
        }

        protected ListFleetPackagesPage createPage(PageContext<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage> context, ListFleetPackagesResponse response) {
            return new ListFleetPackagesPage(context, response);
        }

        public ApiFuture<ListFleetPackagesPage> createPageAsync(PageContext<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage> context, ApiFuture<ListFleetPackagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFleetPackagesPagedResponse
    extends AbstractPagedListResponse<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage, ListFleetPackagesPage, ListFleetPackagesFixedSizeCollection> {
        public static ApiFuture<ListFleetPackagesPagedResponse> createAsync(PageContext<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage> context, ApiFuture<ListFleetPackagesResponse> futureResponse) {
            ApiFuture<ListFleetPackagesPage> futurePage = ListFleetPackagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFleetPackagesPagedResponse((ListFleetPackagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFleetPackagesPagedResponse(ListFleetPackagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFleetPackagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceBundlesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle, ListResourceBundlesPage, ListResourceBundlesFixedSizeCollection> {
        private ListResourceBundlesFixedSizeCollection(List<ListResourceBundlesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceBundlesFixedSizeCollection createEmptyCollection() {
            return new ListResourceBundlesFixedSizeCollection(null, 0);
        }

        protected ListResourceBundlesFixedSizeCollection createCollection(List<ListResourceBundlesPage> pages, int collectionSize) {
            return new ListResourceBundlesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceBundlesPage
    extends AbstractPage<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle, ListResourceBundlesPage> {
        private ListResourceBundlesPage(PageContext<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle> context, ListResourceBundlesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceBundlesPage createEmptyPage() {
            return new ListResourceBundlesPage(null, null);
        }

        protected ListResourceBundlesPage createPage(PageContext<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle> context, ListResourceBundlesResponse response) {
            return new ListResourceBundlesPage(context, response);
        }

        public ApiFuture<ListResourceBundlesPage> createPageAsync(PageContext<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle> context, ApiFuture<ListResourceBundlesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceBundlesPagedResponse
    extends AbstractPagedListResponse<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle, ListResourceBundlesPage, ListResourceBundlesFixedSizeCollection> {
        public static ApiFuture<ListResourceBundlesPagedResponse> createAsync(PageContext<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle> context, ApiFuture<ListResourceBundlesResponse> futureResponse) {
            ApiFuture<ListResourceBundlesPage> futurePage = ListResourceBundlesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceBundlesPagedResponse((ListResourceBundlesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceBundlesPagedResponse(ListResourceBundlesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceBundlesFixedSizeCollection.createEmptyCollection());
        }
    }
}

