/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.GetIamPolicyRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.GetRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.InsertRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.InstantSnapshot;
import com.google.cloud.compute.v1.InstantSnapshotList;
import com.google.cloud.compute.v1.ListRegionInstantSnapshotsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionInstantSnapshotsSettings;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.SetLabelsRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionInstantSnapshotRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.RegionInstantSnapshotsStub;
import com.google.cloud.compute.v1.stub.RegionInstantSnapshotsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionInstantSnapshotsClient
implements BackgroundResource {
    private final RegionInstantSnapshotsSettings settings;
    private final RegionInstantSnapshotsStub stub;

    public static final RegionInstantSnapshotsClient create() throws IOException {
        return RegionInstantSnapshotsClient.create(RegionInstantSnapshotsSettings.newBuilder().build());
    }

    public static final RegionInstantSnapshotsClient create(RegionInstantSnapshotsSettings settings) throws IOException {
        return new RegionInstantSnapshotsClient(settings);
    }

    public static final RegionInstantSnapshotsClient create(RegionInstantSnapshotsStub stub) {
        return new RegionInstantSnapshotsClient(stub);
    }

    protected RegionInstantSnapshotsClient(RegionInstantSnapshotsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstantSnapshotsStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionInstantSnapshotsClient(RegionInstantSnapshotsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstantSnapshotsSettings getSettings() {
        return this.settings;
    }

    public RegionInstantSnapshotsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String instantSnapshot) {
        DeleteRegionInstantSnapshotRequest request = DeleteRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setInstantSnapshot(instantSnapshot).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionInstantSnapshotRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionInstantSnapshotRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionInstantSnapshotRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstantSnapshot get(String project, String region, String instantSnapshot) {
        GetRegionInstantSnapshotRequest request = GetRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setInstantSnapshot(instantSnapshot).build();
        return this.get(request);
    }

    public final InstantSnapshot get(GetRegionInstantSnapshotRequest request) {
        return (InstantSnapshot)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionInstantSnapshotRequest, InstantSnapshot> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyRegionInstantSnapshotRequest request = GetIamPolicyRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRegionInstantSnapshotRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRegionInstantSnapshotRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, InstantSnapshot instantSnapshotResource) {
        InsertRegionInstantSnapshotRequest request = InsertRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setInstantSnapshotResource(instantSnapshotResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionInstantSnapshotRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionInstantSnapshotRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionInstantSnapshotRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionInstantSnapshotsRequest request = ListRegionInstantSnapshotsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionInstantSnapshotsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionInstantSnapshotsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionInstantSnapshotsRequest, InstantSnapshotList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyRegionInstantSnapshotRequest request = SetIamPolicyRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRegionInstantSnapshotRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRegionInstantSnapshotRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String region, String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsRegionInstantSnapshotRequest request = SetLabelsRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsRegionInstantSnapshotRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsRegionInstantSnapshotRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsRegionInstantSnapshotRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionInstantSnapshotRequest request = TestIamPermissionsRegionInstantSnapshotRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsRegionInstantSnapshotRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRegionInstantSnapshotRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage> {
        private ListPage(PageContext<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, InstantSnapshotList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, InstantSnapshotList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, ApiFuture<InstantSnapshotList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionInstantSnapshotsRequest, InstantSnapshotList, InstantSnapshot> context, ApiFuture<InstantSnapshotList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

