/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CreateMembersInterconnectGroupRequest;
import com.google.cloud.compute.v1.DeleteInterconnectGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyInterconnectGroupRequest;
import com.google.cloud.compute.v1.GetInterconnectGroupRequest;
import com.google.cloud.compute.v1.GetOperationalStatusInterconnectGroupRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertInterconnectGroupRequest;
import com.google.cloud.compute.v1.InterconnectGroup;
import com.google.cloud.compute.v1.InterconnectGroupsCreateMembersRequest;
import com.google.cloud.compute.v1.InterconnectGroupsGetOperationalStatusResponse;
import com.google.cloud.compute.v1.InterconnectGroupsListResponse;
import com.google.cloud.compute.v1.InterconnectGroupsSettings;
import com.google.cloud.compute.v1.ListInterconnectGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInterconnectGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInterconnectGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.InterconnectGroupsStub;
import com.google.cloud.compute.v1.stub.InterconnectGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectGroupsClient
implements BackgroundResource {
    private final InterconnectGroupsSettings settings;
    private final InterconnectGroupsStub stub;

    public static final InterconnectGroupsClient create() throws IOException {
        return InterconnectGroupsClient.create(InterconnectGroupsSettings.newBuilder().build());
    }

    public static final InterconnectGroupsClient create(InterconnectGroupsSettings settings) throws IOException {
        return new InterconnectGroupsClient(settings);
    }

    public static final InterconnectGroupsClient create(InterconnectGroupsStub stub) {
        return new InterconnectGroupsClient(stub);
    }

    protected InterconnectGroupsClient(InterconnectGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InterconnectGroupsClient(InterconnectGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectGroupsSettings getSettings() {
        return this.settings;
    }

    public InterconnectGroupsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> createMembersAsync(String project, String interconnectGroup, InterconnectGroupsCreateMembersRequest interconnectGroupsCreateMembersRequestResource) {
        CreateMembersInterconnectGroupRequest request = CreateMembersInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroup(interconnectGroup).setInterconnectGroupsCreateMembersRequestResource(interconnectGroupsCreateMembersRequestResource).build();
        return this.createMembersAsync(request);
    }

    public final OperationFuture<Operation, Operation> createMembersAsync(CreateMembersInterconnectGroupRequest request) {
        return this.createMembersOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMembersInterconnectGroupRequest, Operation, Operation> createMembersOperationCallable() {
        return this.stub.createMembersOperationCallable();
    }

    public final UnaryCallable<CreateMembersInterconnectGroupRequest, Operation> createMembersCallable() {
        return this.stub.createMembersCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String interconnectGroup) {
        DeleteInterconnectGroupRequest request = DeleteInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroup(interconnectGroup).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInterconnectGroupRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInterconnectGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInterconnectGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InterconnectGroup get(String project, String interconnectGroup) {
        GetInterconnectGroupRequest request = GetInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroup(interconnectGroup).build();
        return this.get(request);
    }

    public final InterconnectGroup get(GetInterconnectGroupRequest request) {
        return (InterconnectGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectGroupRequest, InterconnectGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyInterconnectGroupRequest request = GetIamPolicyInterconnectGroupRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyInterconnectGroupRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyInterconnectGroupRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final InterconnectGroupsGetOperationalStatusResponse getOperationalStatus(String project, String interconnectGroup) {
        GetOperationalStatusInterconnectGroupRequest request = GetOperationalStatusInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroup(interconnectGroup).build();
        return this.getOperationalStatus(request);
    }

    public final InterconnectGroupsGetOperationalStatusResponse getOperationalStatus(GetOperationalStatusInterconnectGroupRequest request) {
        return (InterconnectGroupsGetOperationalStatusResponse)this.getOperationalStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetOperationalStatusInterconnectGroupRequest, InterconnectGroupsGetOperationalStatusResponse> getOperationalStatusCallable() {
        return this.stub.getOperationalStatusCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, InterconnectGroup interconnectGroupResource) {
        InsertInterconnectGroupRequest request = InsertInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroupResource(interconnectGroupResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInterconnectGroupRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInterconnectGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInterconnectGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInterconnectGroupsRequest request = ListInterconnectGroupsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectGroupsRequest, InterconnectGroupsListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String interconnectGroup, InterconnectGroup interconnectGroupResource) {
        PatchInterconnectGroupRequest request = PatchInterconnectGroupRequest.newBuilder().setProject(project).setInterconnectGroup(interconnectGroup).setInterconnectGroupResource(interconnectGroupResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchInterconnectGroupRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInterconnectGroupRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInterconnectGroupRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyInterconnectGroupRequest request = SetIamPolicyInterconnectGroupRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyInterconnectGroupRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyInterconnectGroupRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInterconnectGroupRequest request = TestIamPermissionsInterconnectGroupRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsInterconnectGroupRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsInterconnectGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup, ListPage> {
        private ListPage(PageContext<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup> context, InterconnectGroupsListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup> context, InterconnectGroupsListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup> context, ApiFuture<InterconnectGroupsListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectGroupsRequest, InterconnectGroupsListResponse, InterconnectGroup> context, ApiFuture<InterconnectGroupsListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

