/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.DeleteTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetTcpProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetTcpProxyRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesScopedList;
import com.google.cloud.compute.v1.TargetTcpProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesSettings;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyAggregatedList;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.TestIamPermissionsTargetTcpProxyRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.TargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.TargetTcpProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetTcpProxiesClient
implements BackgroundResource {
    private final TargetTcpProxiesSettings settings;
    private final TargetTcpProxiesStub stub;

    public static final TargetTcpProxiesClient create() throws IOException {
        return TargetTcpProxiesClient.create(TargetTcpProxiesSettings.newBuilder().build());
    }

    public static final TargetTcpProxiesClient create(TargetTcpProxiesSettings settings) throws IOException {
        return new TargetTcpProxiesClient(settings);
    }

    public static final TargetTcpProxiesClient create(TargetTcpProxiesStub stub) {
        return new TargetTcpProxiesClient(stub);
    }

    protected TargetTcpProxiesClient(TargetTcpProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetTcpProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    protected TargetTcpProxiesClient(TargetTcpProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetTcpProxiesSettings getSettings() {
        return this.settings;
    }

    public TargetTcpProxiesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetTcpProxiesRequest request = AggregatedListTargetTcpProxiesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetTcpProxiesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetTcpProxiesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String targetTcpProxy) {
        DeleteTargetTcpProxyRequest request = DeleteTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteTargetTcpProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetTcpProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetTcpProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetTcpProxy get(String project, String targetTcpProxy) {
        GetTargetTcpProxyRequest request = GetTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).build();
        return this.get(request);
    }

    public final TargetTcpProxy get(GetTargetTcpProxyRequest request) {
        return (TargetTcpProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetTcpProxyRequest, TargetTcpProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, TargetTcpProxy targetTcpProxyResource) {
        InsertTargetTcpProxyRequest request = InsertTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxyResource(targetTcpProxyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertTargetTcpProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertTargetTcpProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertTargetTcpProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetTcpProxiesRequest request = ListTargetTcpProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetTcpProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetTcpProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetTcpProxiesRequest, TargetTcpProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> setBackendServiceAsync(String project, String targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest targetTcpProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetTcpProxyRequest request = SetBackendServiceTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetBackendServiceRequestResource(targetTcpProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceAsync(request);
    }

    public final OperationFuture<Operation, Operation> setBackendServiceAsync(SetBackendServiceTargetTcpProxyRequest request) {
        return this.setBackendServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetBackendServiceTargetTcpProxyRequest, Operation, Operation> setBackendServiceOperationCallable() {
        return this.stub.setBackendServiceOperationCallable();
    }

    public final UnaryCallable<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceCallable() {
        return this.stub.setBackendServiceCallable();
    }

    public final OperationFuture<Operation, Operation> setProxyHeaderAsync(String project, String targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest targetTcpProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetTcpProxyRequest request = SetProxyHeaderTargetTcpProxyRequest.newBuilder().setProject(project).setTargetTcpProxy(targetTcpProxy).setTargetTcpProxiesSetProxyHeaderRequestResource(targetTcpProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderAsync(request);
    }

    public final OperationFuture<Operation, Operation> setProxyHeaderAsync(SetProxyHeaderTargetTcpProxyRequest request) {
        return this.setProxyHeaderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetProxyHeaderTargetTcpProxyRequest, Operation, Operation> setProxyHeaderOperationCallable() {
        return this.stub.setProxyHeaderOperationCallable();
    }

    public final UnaryCallable<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderCallable() {
        return this.stub.setProxyHeaderCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsTargetTcpProxyRequest request = TestIamPermissionsTargetTcpProxyRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsTargetTcpProxyRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsTargetTcpProxyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage> {
        private ListPage(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, TargetTcpProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> context, ApiFuture<TargetTcpProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>> context, TargetTcpProxyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>> context, TargetTcpProxyAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>> context, ApiFuture<TargetTcpProxyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetTcpProxiesRequest, TargetTcpProxyAggregatedList, Map.Entry<String, TargetTcpProxiesScopedList>> context, ApiFuture<TargetTcpProxyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

