/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSubnetworksRequest;
import com.google.cloud.compute.v1.DeleteSubnetworkRequest;
import com.google.cloud.compute.v1.ExpandIpCidrRangeSubnetworkRequest;
import com.google.cloud.compute.v1.GetIamPolicySubnetworkRequest;
import com.google.cloud.compute.v1.GetSubnetworkRequest;
import com.google.cloud.compute.v1.InsertSubnetworkRequest;
import com.google.cloud.compute.v1.ListSubnetworksRequest;
import com.google.cloud.compute.v1.ListUsableSubnetworksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSubnetworkRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicySubnetworkRequest;
import com.google.cloud.compute.v1.SetPrivateIpGoogleAccessSubnetworkRequest;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.SubnetworkAggregatedList;
import com.google.cloud.compute.v1.SubnetworkList;
import com.google.cloud.compute.v1.SubnetworksExpandIpCidrRangeRequest;
import com.google.cloud.compute.v1.SubnetworksScopedList;
import com.google.cloud.compute.v1.SubnetworksSetPrivateIpGoogleAccessRequest;
import com.google.cloud.compute.v1.SubnetworksSettings;
import com.google.cloud.compute.v1.TestIamPermissionsSubnetworkRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UsableSubnetwork;
import com.google.cloud.compute.v1.UsableSubnetworksAggregatedList;
import com.google.cloud.compute.v1.stub.SubnetworksStub;
import com.google.cloud.compute.v1.stub.SubnetworksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SubnetworksClient
implements BackgroundResource {
    private final SubnetworksSettings settings;
    private final SubnetworksStub stub;

    public static final SubnetworksClient create() throws IOException {
        return SubnetworksClient.create(SubnetworksSettings.newBuilder().build());
    }

    public static final SubnetworksClient create(SubnetworksSettings settings) throws IOException {
        return new SubnetworksClient(settings);
    }

    public static final SubnetworksClient create(SubnetworksStub stub) {
        return new SubnetworksClient(stub);
    }

    protected SubnetworksClient(SubnetworksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SubnetworksStubSettings)settings.getStubSettings()).createStub();
    }

    protected SubnetworksClient(SubnetworksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SubnetworksSettings getSettings() {
        return this.settings;
    }

    public SubnetworksStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListSubnetworksRequest request = AggregatedListSubnetworksRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListSubnetworksRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListSubnetworksRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListSubnetworksRequest, SubnetworkAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String subnetwork) {
        DeleteSubnetworkRequest request = DeleteSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteSubnetworkRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSubnetworkRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteSubnetworkRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> expandIpCidrRangeAsync(String project, String region, String subnetwork, SubnetworksExpandIpCidrRangeRequest subnetworksExpandIpCidrRangeRequestResource) {
        ExpandIpCidrRangeSubnetworkRequest request = ExpandIpCidrRangeSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).setSubnetworksExpandIpCidrRangeRequestResource(subnetworksExpandIpCidrRangeRequestResource).build();
        return this.expandIpCidrRangeAsync(request);
    }

    public final OperationFuture<Operation, Operation> expandIpCidrRangeAsync(ExpandIpCidrRangeSubnetworkRequest request) {
        return this.expandIpCidrRangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExpandIpCidrRangeSubnetworkRequest, Operation, Operation> expandIpCidrRangeOperationCallable() {
        return this.stub.expandIpCidrRangeOperationCallable();
    }

    public final UnaryCallable<ExpandIpCidrRangeSubnetworkRequest, Operation> expandIpCidrRangeCallable() {
        return this.stub.expandIpCidrRangeCallable();
    }

    public final Subnetwork get(String project, String region, String subnetwork) {
        GetSubnetworkRequest request = GetSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).build();
        return this.get(request);
    }

    public final Subnetwork get(GetSubnetworkRequest request) {
        return (Subnetwork)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubnetworkRequest, Subnetwork> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicySubnetworkRequest request = GetIamPolicySubnetworkRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicySubnetworkRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicySubnetworkRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, Subnetwork subnetworkResource) {
        InsertSubnetworkRequest request = InsertSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetworkResource(subnetworkResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertSubnetworkRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertSubnetworkRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertSubnetworkRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListSubnetworksRequest request = ListSubnetworksRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSubnetworksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubnetworksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSubnetworksRequest, SubnetworkList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListUsablePagedResponse listUsable(String project) {
        ListUsableSubnetworksRequest request = ListUsableSubnetworksRequest.newBuilder().setProject(project).build();
        return this.listUsable(request);
    }

    public final ListUsablePagedResponse listUsable(ListUsableSubnetworksRequest request) {
        return (ListUsablePagedResponse)((Object)this.listUsablePagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableSubnetworksRequest, ListUsablePagedResponse> listUsablePagedCallable() {
        return this.stub.listUsablePagedCallable();
    }

    public final UnaryCallable<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList> listUsableCallable() {
        return this.stub.listUsableCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String subnetwork, Subnetwork subnetworkResource) {
        PatchSubnetworkRequest request = PatchSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).setSubnetworkResource(subnetworkResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchSubnetworkRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchSubnetworkRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchSubnetworkRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicySubnetworkRequest request = SetIamPolicySubnetworkRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicySubnetworkRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicySubnetworkRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setPrivateIpGoogleAccessAsync(String project, String region, String subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest subnetworksSetPrivateIpGoogleAccessRequestResource) {
        SetPrivateIpGoogleAccessSubnetworkRequest request = SetPrivateIpGoogleAccessSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setSubnetwork(subnetwork).setSubnetworksSetPrivateIpGoogleAccessRequestResource(subnetworksSetPrivateIpGoogleAccessRequestResource).build();
        return this.setPrivateIpGoogleAccessAsync(request);
    }

    public final OperationFuture<Operation, Operation> setPrivateIpGoogleAccessAsync(SetPrivateIpGoogleAccessSubnetworkRequest request) {
        return this.setPrivateIpGoogleAccessOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetPrivateIpGoogleAccessSubnetworkRequest, Operation, Operation> setPrivateIpGoogleAccessOperationCallable() {
        return this.stub.setPrivateIpGoogleAccessOperationCallable();
    }

    public final UnaryCallable<SetPrivateIpGoogleAccessSubnetworkRequest, Operation> setPrivateIpGoogleAccessCallable() {
        return this.stub.setPrivateIpGoogleAccessCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsSubnetworkRequest request = TestIamPermissionsSubnetworkRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsSubnetworkRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsSubnetworkRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsablePage, ListUsableFixedSizeCollection> {
        private ListUsableFixedSizeCollection(List<ListUsablePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableFixedSizeCollection createEmptyCollection() {
            return new ListUsableFixedSizeCollection(null, 0);
        }

        protected ListUsableFixedSizeCollection createCollection(List<ListUsablePage> pages, int collectionSize) {
            return new ListUsableFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsablePage
    extends AbstractPage<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsablePage> {
        private ListUsablePage(PageContext<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, UsableSubnetworksAggregatedList response) {
            super(context, (Object)response);
        }

        private static ListUsablePage createEmptyPage() {
            return new ListUsablePage(null, null);
        }

        protected ListUsablePage createPage(PageContext<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, UsableSubnetworksAggregatedList response) {
            return new ListUsablePage(context, response);
        }

        public ApiFuture<ListUsablePage> createPageAsync(PageContext<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsablePagedResponse
    extends AbstractPagedListResponse<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork, ListUsablePage, ListUsableFixedSizeCollection> {
        public static ApiFuture<ListUsablePagedResponse> createAsync(PageContext<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            ApiFuture<ListUsablePage> futurePage = ListUsablePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsablePagedResponse((ListUsablePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsablePagedResponse(ListUsablePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetworksRequest, SubnetworkList, Subnetwork, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSubnetworksRequest, SubnetworkList, Subnetwork, ListPage> {
        private ListPage(PageContext<ListSubnetworksRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSubnetworksRequest, SubnetworkList, Subnetwork> context, SubnetworkList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSubnetworksRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSubnetworksRequest, SubnetworkList, Subnetwork, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSubnetworksRequest, SubnetworkList, Subnetwork> context, ApiFuture<SubnetworkList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>> context, SubnetworkAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>> context, SubnetworkAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>> context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

