/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.AddRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.CopyRulesOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListAssociationsOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.MoveOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesClient;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesListAssociationsResponse;
import com.google.cloud.compute.v1.PatchOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyAssociation;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.HttpJsonOrganizationSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.OrganizationSecurityPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OrganizationSecurityPoliciesStubSettings
extends StubSettings<OrganizationSecurityPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationSettings;
    private final OperationCallSettings<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationSettings;
    private final UnaryCallSettings<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleSettings;
    private final OperationCallSettings<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
    private final UnaryCallSettings<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesSettings;
    private final OperationCallSettings<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationSettings;
    private final UnaryCallSettings<DeleteOrganizationSecurityPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getSettings;
    private final UnaryCallSettings<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationSettings;
    private final UnaryCallSettings<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertOrganizationSecurityPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsSettings;
    private final UnaryCallSettings<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings;
    private final UnaryCallSettings<MoveOrganizationSecurityPolicyRequest, Operation> moveSettings;
    private final OperationCallSettings<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationSettings;
    private final UnaryCallSettings<PatchOrganizationSecurityPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleSettings;
    private final OperationCallSettings<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
    private final UnaryCallSettings<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationSettings;
    private final OperationCallSettings<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
    private final UnaryCallSettings<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleSettings;
    private final OperationCallSettings<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
    private static final PagedListDescriptor<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListOrganizationSecurityPoliciesRequest injectToken(ListOrganizationSecurityPoliciesRequest payload, String token) {
            return ListOrganizationSecurityPoliciesRequest.newBuilder((ListOrganizationSecurityPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListOrganizationSecurityPoliciesRequest injectPageSize(ListOrganizationSecurityPoliciesRequest payload, int pageSize) {
            return ListOrganizationSecurityPoliciesRequest.newBuilder((ListOrganizationSecurityPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListOrganizationSecurityPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SecurityPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecurityPolicy> extractResources(SecurityPolicyList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse>(){

        public ApiFuture<OrganizationSecurityPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList> callable, ListOrganizationSecurityPoliciesRequest request, ApiCallContext context, ApiFuture<SecurityPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrganizationSecurityPoliciesClient.ListPagedResponse.createAsync((PageContext<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationSettings() {
        return this.addAssociationSettings;
    }

    public OperationCallSettings<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
        return this.addAssociationOperationSettings;
    }

    public UnaryCallSettings<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public OperationCallSettings<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
        return this.addRuleOperationSettings;
    }

    public UnaryCallSettings<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesSettings() {
        return this.copyRulesSettings;
    }

    public OperationCallSettings<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationSettings() {
        return this.copyRulesOperationSettings;
    }

    public UnaryCallSettings<DeleteOrganizationSecurityPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationSettings() {
        return this.getAssociationSettings;
    }

    public UnaryCallSettings<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertOrganizationSecurityPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsSettings() {
        return this.listAssociationsSettings;
    }

    public UnaryCallSettings<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings() {
        return this.listPreconfiguredExpressionSetsSettings;
    }

    public UnaryCallSettings<MoveOrganizationSecurityPolicyRequest, Operation> moveSettings() {
        return this.moveSettings;
    }

    public OperationCallSettings<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationSettings() {
        return this.moveOperationSettings;
    }

    public UnaryCallSettings<PatchOrganizationSecurityPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public OperationCallSettings<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
        return this.patchRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationSettings() {
        return this.removeAssociationSettings;
    }

    public OperationCallSettings<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
        return this.removeAssociationOperationSettings;
    }

    public UnaryCallSettings<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public OperationCallSettings<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
        return this.removeRuleOperationSettings;
    }

    public OrganizationSecurityPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOrganizationSecurityPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OrganizationSecurityPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OrganizationSecurityPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OrganizationSecurityPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAssociationSettings = settingsBuilder.addAssociationSettings().build();
        this.addAssociationOperationSettings = settingsBuilder.addAssociationOperationSettings().build();
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.addRuleOperationSettings = settingsBuilder.addRuleOperationSettings().build();
        this.copyRulesSettings = settingsBuilder.copyRulesSettings().build();
        this.copyRulesOperationSettings = settingsBuilder.copyRulesOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getAssociationSettings = settingsBuilder.getAssociationSettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listAssociationsSettings = settingsBuilder.listAssociationsSettings().build();
        this.listPreconfiguredExpressionSetsSettings = settingsBuilder.listPreconfiguredExpressionSetsSettings().build();
        this.moveSettings = settingsBuilder.moveSettings().build();
        this.moveOperationSettings = settingsBuilder.moveOperationSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.patchRuleOperationSettings = settingsBuilder.patchRuleOperationSettings().build();
        this.removeAssociationSettings = settingsBuilder.removeAssociationSettings().build();
        this.removeAssociationOperationSettings = settingsBuilder.removeAssociationOperationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.removeRuleOperationSettings = settingsBuilder.removeRuleOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OrganizationSecurityPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationSettings;
        private final OperationCallSettings.Builder<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationSettings;
        private final UnaryCallSettings.Builder<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleSettings;
        private final OperationCallSettings.Builder<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
        private final UnaryCallSettings.Builder<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesSettings;
        private final OperationCallSettings.Builder<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteOrganizationSecurityPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationSettings;
        private final UnaryCallSettings.Builder<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertOrganizationSecurityPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsSettings;
        private final UnaryCallSettings.Builder<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings;
        private final UnaryCallSettings.Builder<MoveOrganizationSecurityPolicyRequest, Operation> moveSettings;
        private final OperationCallSettings.Builder<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationSettings;
        private final UnaryCallSettings.Builder<PatchOrganizationSecurityPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleSettings;
        private final OperationCallSettings.Builder<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationSettings;
        private final OperationCallSettings.Builder<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleSettings;
        private final OperationCallSettings.Builder<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleOperationSettings = OperationCallSettings.newBuilder();
            this.copyRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.copyRulesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listAssociationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPreconfiguredExpressionSetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveOperationSettings = OperationCallSettings.newBuilder();
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.copyRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listAssociationsSettings, this.listPreconfiguredExpressionSetsSettings, this.moveSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings});
            Builder.initDefaults(this);
        }

        protected Builder(OrganizationSecurityPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addAssociationSettings = settings.addAssociationSettings.toBuilder();
            this.addAssociationOperationSettings = settings.addAssociationOperationSettings.toBuilder();
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.addRuleOperationSettings = settings.addRuleOperationSettings.toBuilder();
            this.copyRulesSettings = settings.copyRulesSettings.toBuilder();
            this.copyRulesOperationSettings = settings.copyRulesOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getAssociationSettings = settings.getAssociationSettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listAssociationsSettings = settings.listAssociationsSettings.toBuilder();
            this.listPreconfiguredExpressionSetsSettings = settings.listPreconfiguredExpressionSetsSettings.toBuilder();
            this.moveSettings = settings.moveSettings.toBuilder();
            this.moveOperationSettings = settings.moveOperationSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.patchRuleOperationSettings = settings.patchRuleOperationSettings.toBuilder();
            this.removeAssociationSettings = settings.removeAssociationSettings.toBuilder();
            this.removeAssociationOperationSettings = settings.removeAssociationOperationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.removeRuleOperationSettings = settings.removeRuleOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.copyRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listAssociationsSettings, this.listPreconfiguredExpressionSetsSettings, this.moveSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OrganizationSecurityPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OrganizationSecurityPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OrganizationSecurityPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OrganizationSecurityPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.copyRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAssociationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPreconfiguredExpressionSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.moveSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.addRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.copyRulesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.moveOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.removeAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.removeRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationSettings() {
            return this.addAssociationSettings;
        }

        public OperationCallSettings.Builder<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
            return this.addAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public OperationCallSettings.Builder<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
            return this.addRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesSettings() {
            return this.copyRulesSettings;
        }

        public OperationCallSettings.Builder<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationSettings() {
            return this.copyRulesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteOrganizationSecurityPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationSettings() {
            return this.getAssociationSettings;
        }

        public UnaryCallSettings.Builder<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertOrganizationSecurityPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList, OrganizationSecurityPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsSettings() {
            return this.listAssociationsSettings;
        }

        public UnaryCallSettings.Builder<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings() {
            return this.listPreconfiguredExpressionSetsSettings;
        }

        public UnaryCallSettings.Builder<MoveOrganizationSecurityPolicyRequest, Operation> moveSettings() {
            return this.moveSettings;
        }

        public OperationCallSettings.Builder<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationSettings() {
            return this.moveOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchOrganizationSecurityPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public OperationCallSettings.Builder<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
            return this.patchRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationSettings() {
            return this.removeAssociationSettings;
        }

        public OperationCallSettings.Builder<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
            return this.removeAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public OperationCallSettings.Builder<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
            return this.removeRuleOperationSettings;
        }

        public OrganizationSecurityPoliciesStubSettings build() throws IOException {
            return new OrganizationSecurityPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

