/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkEdgeSecurityServicesRequest;
import com.google.cloud.compute.v1.DeleteNetworkEdgeSecurityServiceRequest;
import com.google.cloud.compute.v1.GetNetworkEdgeSecurityServiceRequest;
import com.google.cloud.compute.v1.InsertNetworkEdgeSecurityServiceRequest;
import com.google.cloud.compute.v1.NetworkEdgeSecurityService;
import com.google.cloud.compute.v1.NetworkEdgeSecurityServiceAggregatedList;
import com.google.cloud.compute.v1.NetworkEdgeSecurityServicesScopedList;
import com.google.cloud.compute.v1.NetworkEdgeSecurityServicesSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkEdgeSecurityServiceRequest;
import com.google.cloud.compute.v1.stub.NetworkEdgeSecurityServicesStub;
import com.google.cloud.compute.v1.stub.NetworkEdgeSecurityServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkEdgeSecurityServicesClient
implements BackgroundResource {
    private final NetworkEdgeSecurityServicesSettings settings;
    private final NetworkEdgeSecurityServicesStub stub;

    public static final NetworkEdgeSecurityServicesClient create() throws IOException {
        return NetworkEdgeSecurityServicesClient.create(NetworkEdgeSecurityServicesSettings.newBuilder().build());
    }

    public static final NetworkEdgeSecurityServicesClient create(NetworkEdgeSecurityServicesSettings settings) throws IOException {
        return new NetworkEdgeSecurityServicesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NetworkEdgeSecurityServicesClient create(NetworkEdgeSecurityServicesStub stub) {
        return new NetworkEdgeSecurityServicesClient(stub);
    }

    protected NetworkEdgeSecurityServicesClient(NetworkEdgeSecurityServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkEdgeSecurityServicesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NetworkEdgeSecurityServicesClient(NetworkEdgeSecurityServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkEdgeSecurityServicesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkEdgeSecurityServicesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNetworkEdgeSecurityServicesRequest request = AggregatedListNetworkEdgeSecurityServicesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNetworkEdgeSecurityServicesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNetworkEdgeSecurityServicesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String networkEdgeSecurityService) {
        DeleteNetworkEdgeSecurityServiceRequest request = DeleteNetworkEdgeSecurityServiceRequest.newBuilder().setProject(project).setRegion(region).setNetworkEdgeSecurityService(networkEdgeSecurityService).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNetworkEdgeSecurityServiceRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkEdgeSecurityServiceRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkEdgeSecurityServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final NetworkEdgeSecurityService get(String project, String region, String networkEdgeSecurityService) {
        GetNetworkEdgeSecurityServiceRequest request = GetNetworkEdgeSecurityServiceRequest.newBuilder().setProject(project).setRegion(region).setNetworkEdgeSecurityService(networkEdgeSecurityService).build();
        return this.get(request);
    }

    public final NetworkEdgeSecurityService get(GetNetworkEdgeSecurityServiceRequest request) {
        return (NetworkEdgeSecurityService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkEdgeSecurityServiceRequest, NetworkEdgeSecurityService> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, NetworkEdgeSecurityService networkEdgeSecurityServiceResource) {
        InsertNetworkEdgeSecurityServiceRequest request = InsertNetworkEdgeSecurityServiceRequest.newBuilder().setProject(project).setRegion(region).setNetworkEdgeSecurityServiceResource(networkEdgeSecurityServiceResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertNetworkEdgeSecurityServiceRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNetworkEdgeSecurityServiceRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNetworkEdgeSecurityServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String networkEdgeSecurityService, NetworkEdgeSecurityService networkEdgeSecurityServiceResource) {
        PatchNetworkEdgeSecurityServiceRequest request = PatchNetworkEdgeSecurityServiceRequest.newBuilder().setProject(project).setRegion(region).setNetworkEdgeSecurityService(networkEdgeSecurityService).setNetworkEdgeSecurityServiceResource(networkEdgeSecurityServiceResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchNetworkEdgeSecurityServiceRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchNetworkEdgeSecurityServiceRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchNetworkEdgeSecurityServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>> context, NetworkEdgeSecurityServiceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>> context, NetworkEdgeSecurityServiceAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>> context, ApiFuture<NetworkEdgeSecurityServiceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNetworkEdgeSecurityServicesRequest, NetworkEdgeSecurityServiceAggregatedList, Map.Entry<String, NetworkEdgeSecurityServicesScopedList>> context, ApiFuture<NetworkEdgeSecurityServiceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

