/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddPacketMirroringRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AggregatedListNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.CloneRulesNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPoliciesScopedList;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetPacketMirroringRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.InsertNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.NetworkFirewallPoliciesClient;
import com.google.cloud.compute.v1.NetworkFirewallPolicyAggregatedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchPacketMirroringRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemovePacketMirroringRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNetworkFirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.NetworkFirewallPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetworkFirewallPoliciesStubSettings
extends StubSettings<NetworkFirewallPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddAssociationNetworkFirewallPolicyRequest, Operation> addAssociationSettings;
    private final OperationCallSettings<AddAssociationNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings;
    private final UnaryCallSettings<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> addPacketMirroringRuleSettings;
    private final OperationCallSettings<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> addPacketMirroringRuleOperationSettings;
    private final UnaryCallSettings<AddRuleNetworkFirewallPolicyRequest, Operation> addRuleSettings;
    private final OperationCallSettings<AddRuleNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings;
    private final PagedCallSettings<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<CloneRulesNetworkFirewallPolicyRequest, Operation> cloneRulesSettings;
    private final OperationCallSettings<CloneRulesNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings;
    private final UnaryCallSettings<DeleteNetworkFirewallPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetNetworkFirewallPolicyRequest, FirewallPolicy> getSettings;
    private final UnaryCallSettings<GetAssociationNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
    private final UnaryCallSettings<GetIamPolicyNetworkFirewallPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetPacketMirroringRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getPacketMirroringRuleSettings;
    private final UnaryCallSettings<GetRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertNetworkFirewallPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchNetworkFirewallPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> patchPacketMirroringRuleSettings;
    private final OperationCallSettings<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> patchPacketMirroringRuleOperationSettings;
    private final UnaryCallSettings<PatchRuleNetworkFirewallPolicyRequest, Operation> patchRuleSettings;
    private final OperationCallSettings<PatchRuleNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings;
    private final UnaryCallSettings<RemoveAssociationNetworkFirewallPolicyRequest, Operation> removeAssociationSettings;
    private final OperationCallSettings<RemoveAssociationNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
    private final UnaryCallSettings<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation> removePacketMirroringRuleSettings;
    private final OperationCallSettings<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> removePacketMirroringRuleOperationSettings;
    private final UnaryCallSettings<RemoveRuleNetworkFirewallPolicyRequest, Operation> removeRuleSettings;
    private final OperationCallSettings<RemoveRuleNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings;
    private final UnaryCallSettings<SetIamPolicyNetworkFirewallPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNetworkFirewallPoliciesRequest injectToken(AggregatedListNetworkFirewallPoliciesRequest payload, String token) {
            return AggregatedListNetworkFirewallPoliciesRequest.newBuilder((AggregatedListNetworkFirewallPoliciesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListNetworkFirewallPoliciesRequest injectPageSize(AggregatedListNetworkFirewallPoliciesRequest payload, int pageSize) {
            return AggregatedListNetworkFirewallPoliciesRequest.newBuilder((AggregatedListNetworkFirewallPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNetworkFirewallPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkFirewallPolicyAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, FirewallPoliciesScopedList>> extractResources(NetworkFirewallPolicyAggregatedList payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkFirewallPoliciesRequest injectToken(ListNetworkFirewallPoliciesRequest payload, String token) {
            return ListNetworkFirewallPoliciesRequest.newBuilder((ListNetworkFirewallPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListNetworkFirewallPoliciesRequest injectPageSize(ListNetworkFirewallPoliciesRequest payload, int pageSize) {
            return ListNetworkFirewallPoliciesRequest.newBuilder((ListNetworkFirewallPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkFirewallPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FirewallPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FirewallPolicy> extractResources(FirewallPolicyList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse>(){

        public ApiFuture<NetworkFirewallPoliciesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList> callable, AggregatedListNetworkFirewallPoliciesRequest request, ApiCallContext context, ApiFuture<NetworkFirewallPolicyAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkFirewallPoliciesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse>(){

        public ApiFuture<NetworkFirewallPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkFirewallPoliciesRequest, FirewallPolicyList> callable, ListNetworkFirewallPoliciesRequest request, ApiCallContext context, ApiFuture<FirewallPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkFirewallPoliciesClient.ListPagedResponse.createAsync((PageContext<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAssociationNetworkFirewallPolicyRequest, Operation> addAssociationSettings() {
        return this.addAssociationSettings;
    }

    public OperationCallSettings<AddAssociationNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
        return this.addAssociationOperationSettings;
    }

    public UnaryCallSettings<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> addPacketMirroringRuleSettings() {
        return this.addPacketMirroringRuleSettings;
    }

    public OperationCallSettings<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> addPacketMirroringRuleOperationSettings() {
        return this.addPacketMirroringRuleOperationSettings;
    }

    public UnaryCallSettings<AddRuleNetworkFirewallPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public OperationCallSettings<AddRuleNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings() {
        return this.addRuleOperationSettings;
    }

    public PagedCallSettings<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<CloneRulesNetworkFirewallPolicyRequest, Operation> cloneRulesSettings() {
        return this.cloneRulesSettings;
    }

    public OperationCallSettings<CloneRulesNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings() {
        return this.cloneRulesOperationSettings;
    }

    public UnaryCallSettings<DeleteNetworkFirewallPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetNetworkFirewallPolicyRequest, FirewallPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetAssociationNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
        return this.getAssociationSettings;
    }

    public UnaryCallSettings<GetIamPolicyNetworkFirewallPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetPacketMirroringRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getPacketMirroringRuleSettings() {
        return this.getPacketMirroringRuleSettings;
    }

    public UnaryCallSettings<GetRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertNetworkFirewallPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchNetworkFirewallPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> patchPacketMirroringRuleSettings() {
        return this.patchPacketMirroringRuleSettings;
    }

    public OperationCallSettings<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> patchPacketMirroringRuleOperationSettings() {
        return this.patchPacketMirroringRuleOperationSettings;
    }

    public UnaryCallSettings<PatchRuleNetworkFirewallPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public OperationCallSettings<PatchRuleNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
        return this.patchRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveAssociationNetworkFirewallPolicyRequest, Operation> removeAssociationSettings() {
        return this.removeAssociationSettings;
    }

    public OperationCallSettings<RemoveAssociationNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
        return this.removeAssociationOperationSettings;
    }

    public UnaryCallSettings<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation> removePacketMirroringRuleSettings() {
        return this.removePacketMirroringRuleSettings;
    }

    public OperationCallSettings<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> removePacketMirroringRuleOperationSettings() {
        return this.removePacketMirroringRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveRuleNetworkFirewallPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public OperationCallSettings<RemoveRuleNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
        return this.removeRuleOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyNetworkFirewallPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public NetworkFirewallPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworkFirewallPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworkFirewallPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkFirewallPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworkFirewallPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAssociationSettings = settingsBuilder.addAssociationSettings().build();
        this.addAssociationOperationSettings = settingsBuilder.addAssociationOperationSettings().build();
        this.addPacketMirroringRuleSettings = settingsBuilder.addPacketMirroringRuleSettings().build();
        this.addPacketMirroringRuleOperationSettings = settingsBuilder.addPacketMirroringRuleOperationSettings().build();
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.addRuleOperationSettings = settingsBuilder.addRuleOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.cloneRulesSettings = settingsBuilder.cloneRulesSettings().build();
        this.cloneRulesOperationSettings = settingsBuilder.cloneRulesOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getAssociationSettings = settingsBuilder.getAssociationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getPacketMirroringRuleSettings = settingsBuilder.getPacketMirroringRuleSettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchPacketMirroringRuleSettings = settingsBuilder.patchPacketMirroringRuleSettings().build();
        this.patchPacketMirroringRuleOperationSettings = settingsBuilder.patchPacketMirroringRuleOperationSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.patchRuleOperationSettings = settingsBuilder.patchRuleOperationSettings().build();
        this.removeAssociationSettings = settingsBuilder.removeAssociationSettings().build();
        this.removeAssociationOperationSettings = settingsBuilder.removeAssociationOperationSettings().build();
        this.removePacketMirroringRuleSettings = settingsBuilder.removePacketMirroringRuleSettings().build();
        this.removePacketMirroringRuleOperationSettings = settingsBuilder.removePacketMirroringRuleOperationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.removeRuleOperationSettings = settingsBuilder.removeRuleOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworkFirewallPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAssociationNetworkFirewallPolicyRequest, Operation> addAssociationSettings;
        private final OperationCallSettings.Builder<AddAssociationNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings;
        private final UnaryCallSettings.Builder<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> addPacketMirroringRuleSettings;
        private final OperationCallSettings.Builder<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> addPacketMirroringRuleOperationSettings;
        private final UnaryCallSettings.Builder<AddRuleNetworkFirewallPolicyRequest, Operation> addRuleSettings;
        private final OperationCallSettings.Builder<AddRuleNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<CloneRulesNetworkFirewallPolicyRequest, Operation> cloneRulesSettings;
        private final OperationCallSettings.Builder<CloneRulesNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkFirewallPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetNetworkFirewallPolicyRequest, FirewallPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetAssociationNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyNetworkFirewallPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetPacketMirroringRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getPacketMirroringRuleSettings;
        private final UnaryCallSettings.Builder<GetRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertNetworkFirewallPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchNetworkFirewallPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> patchPacketMirroringRuleSettings;
        private final OperationCallSettings.Builder<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> patchPacketMirroringRuleOperationSettings;
        private final UnaryCallSettings.Builder<PatchRuleNetworkFirewallPolicyRequest, Operation> patchRuleSettings;
        private final OperationCallSettings.Builder<PatchRuleNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveAssociationNetworkFirewallPolicyRequest, Operation> removeAssociationSettings;
        private final OperationCallSettings.Builder<RemoveAssociationNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
        private final UnaryCallSettings.Builder<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation> removePacketMirroringRuleSettings;
        private final OperationCallSettings.Builder<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> removePacketMirroringRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleNetworkFirewallPolicyRequest, Operation> removeRuleSettings;
        private final OperationCallSettings.Builder<RemoveRuleNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyNetworkFirewallPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.addPacketMirroringRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addPacketMirroringRuleOperationSettings = OperationCallSettings.newBuilder();
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.cloneRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cloneRulesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPacketMirroringRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchPacketMirroringRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchPacketMirroringRuleOperationSettings = OperationCallSettings.newBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.removePacketMirroringRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removePacketMirroringRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addPacketMirroringRuleSettings, this.addRuleSettings, this.aggregatedListSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getIamPolicySettings, this.getPacketMirroringRuleSettings, this.getRuleSettings, this.insertSettings, (Object[])new UnaryCallSettings.Builder[]{this.listSettings, this.patchSettings, this.patchPacketMirroringRuleSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removePacketMirroringRuleSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NetworkFirewallPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addAssociationSettings = settings.addAssociationSettings.toBuilder();
            this.addAssociationOperationSettings = settings.addAssociationOperationSettings.toBuilder();
            this.addPacketMirroringRuleSettings = settings.addPacketMirroringRuleSettings.toBuilder();
            this.addPacketMirroringRuleOperationSettings = settings.addPacketMirroringRuleOperationSettings.toBuilder();
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.addRuleOperationSettings = settings.addRuleOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.cloneRulesSettings = settings.cloneRulesSettings.toBuilder();
            this.cloneRulesOperationSettings = settings.cloneRulesOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getAssociationSettings = settings.getAssociationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getPacketMirroringRuleSettings = settings.getPacketMirroringRuleSettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchPacketMirroringRuleSettings = settings.patchPacketMirroringRuleSettings.toBuilder();
            this.patchPacketMirroringRuleOperationSettings = settings.patchPacketMirroringRuleOperationSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.patchRuleOperationSettings = settings.patchRuleOperationSettings.toBuilder();
            this.removeAssociationSettings = settings.removeAssociationSettings.toBuilder();
            this.removeAssociationOperationSettings = settings.removeAssociationOperationSettings.toBuilder();
            this.removePacketMirroringRuleSettings = settings.removePacketMirroringRuleSettings.toBuilder();
            this.removePacketMirroringRuleOperationSettings = settings.removePacketMirroringRuleOperationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.removeRuleOperationSettings = settings.removeRuleOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addPacketMirroringRuleSettings, this.addRuleSettings, this.aggregatedListSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getIamPolicySettings, this.getPacketMirroringRuleSettings, this.getRuleSettings, this.insertSettings, (Object[])new UnaryCallSettings.Builder[]{this.listSettings, this.patchSettings, this.patchPacketMirroringRuleSettings, this.patchRuleSettings, this.removeAssociationSettings, this.removePacketMirroringRuleSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworkFirewallPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworkFirewallPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkFirewallPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NetworkFirewallPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addPacketMirroringRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cloneRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPacketMirroringRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchPacketMirroringRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removePacketMirroringRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.addPacketMirroringRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.addRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.cloneRulesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchPacketMirroringRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.removeAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.removePacketMirroringRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.removeRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAssociationNetworkFirewallPolicyRequest, Operation> addAssociationSettings() {
            return this.addAssociationSettings;
        }

        public OperationCallSettings.Builder<AddAssociationNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
            return this.addAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> addPacketMirroringRuleSettings() {
            return this.addPacketMirroringRuleSettings;
        }

        public OperationCallSettings.Builder<AddPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> addPacketMirroringRuleOperationSettings() {
            return this.addPacketMirroringRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<AddRuleNetworkFirewallPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public OperationCallSettings.Builder<AddRuleNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings() {
            return this.addRuleOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, NetworkFirewallPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<CloneRulesNetworkFirewallPolicyRequest, Operation> cloneRulesSettings() {
            return this.cloneRulesSettings;
        }

        public OperationCallSettings.Builder<CloneRulesNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings() {
            return this.cloneRulesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkFirewallPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkFirewallPolicyRequest, FirewallPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetAssociationNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
            return this.getAssociationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyNetworkFirewallPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetPacketMirroringRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getPacketMirroringRuleSettings() {
            return this.getPacketMirroringRuleSettings;
        }

        public UnaryCallSettings.Builder<GetRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkFirewallPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, NetworkFirewallPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchNetworkFirewallPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation> patchPacketMirroringRuleSettings() {
            return this.patchPacketMirroringRuleSettings;
        }

        public OperationCallSettings.Builder<PatchPacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> patchPacketMirroringRuleOperationSettings() {
            return this.patchPacketMirroringRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleNetworkFirewallPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public OperationCallSettings.Builder<PatchRuleNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
            return this.patchRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveAssociationNetworkFirewallPolicyRequest, Operation> removeAssociationSettings() {
            return this.removeAssociationSettings;
        }

        public OperationCallSettings.Builder<RemoveAssociationNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
            return this.removeAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation> removePacketMirroringRuleSettings() {
            return this.removePacketMirroringRuleSettings;
        }

        public OperationCallSettings.Builder<RemovePacketMirroringRuleNetworkFirewallPolicyRequest, Operation, Operation> removePacketMirroringRuleOperationSettings() {
            return this.removePacketMirroringRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleNetworkFirewallPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public OperationCallSettings.Builder<RemoveRuleNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
            return this.removeRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyNetworkFirewallPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NetworkFirewallPoliciesStubSettings build() throws IOException {
            return new NetworkFirewallPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

