/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.AddRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.CopyRulesOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListAssociationsOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest;
import com.google.cloud.compute.v1.MoveOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesClient;
import com.google.cloud.compute.v1.OrganizationSecurityPoliciesListAssociationsResponse;
import com.google.cloud.compute.v1.PatchOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveAssociationOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleOrganizationSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyAssociation;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOrganizationOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonOrganizationSecurityPoliciesCallableFactory;
import com.google.cloud.compute.v1.stub.OrganizationSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.OrganizationSecurityPoliciesStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonOrganizationSecurityPoliciesStub
extends OrganizationSecurityPoliciesStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/AddAssociation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/addAssociation", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasReplaceExistingAssociation()) {
            serializer.putQueryParam(fields, "replaceExistingAssociation", (Object)request.getReplaceExistingAssociation());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("securityPolicyAssociationResource", (Message)request.getSecurityPolicyAssociationResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/AddRule").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/addRule", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("securityPolicyRuleResource", (Message)request.getSecurityPolicyRuleResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/CopyRules").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/copyRules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        if (request.hasSourceSecurityPolicy()) {
            serializer.putQueryParam(fields, "sourceSecurityPolicy", (Object)request.getSourceSecurityPolicy());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<DeleteOrganizationSecurityPolicyRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SecurityPolicy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/GetAssociation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/getAssociation", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasName()) {
            serializer.putQueryParam(fields, "name", (Object)request.getName());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SecurityPolicyAssociation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/GetRule").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/getRule", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasPriority()) {
            serializer.putQueryParam(fields, "priority", (Object)request.getPriority());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SecurityPolicyRule.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertOrganizationSecurityPolicyRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasParentId()) {
            serializer.putQueryParam(fields, "parentId", (Object)request.getParentId());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("securityPolicyResource", (Message)request.getSecurityPolicyResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getParentId());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasParentId()) {
            serializer.putQueryParam(fields, "parentId", (Object)request.getParentId());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SecurityPolicyList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/ListAssociations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/listAssociations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasTargetResource()) {
            serializer.putQueryParam(fields, "targetResource", (Object)request.getTargetResource());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OrganizationSecurityPoliciesListAssociationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/ListPreconfiguredExpressionSets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/listPreconfiguredExpressionSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasParentId()) {
            serializer.putQueryParam(fields, "parentId", (Object)request.getParentId());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SecurityPoliciesListPreconfiguredExpressionSetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MoveOrganizationSecurityPolicyRequest, Operation> moveMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/Move").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/move", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasParentId()) {
            serializer.putQueryParam(fields, "parentId", (Object)request.getParentId());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getParentId());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<PatchOrganizationSecurityPolicyRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/Patch").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("securityPolicyResource", (Message)request.getSecurityPolicyResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/PatchRule").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/patchRule", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasPriority()) {
            serializer.putQueryParam(fields, "priority", (Object)request.getPriority());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("securityPolicyRuleResource", (Message)request.getSecurityPolicyRuleResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/RemoveAssociation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/removeAssociation", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasName()) {
            serializer.putQueryParam(fields, "name", (Object)request.getName());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.OrganizationSecurityPolicies/RemoveRule").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/locations/global/securityPolicies/{securityPolicy}/removeRule", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "securityPolicy", (Object)request.getSecurityPolicy());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasPriority()) {
            serializer.putQueryParam(fields, "priority", (Object)request.getPriority());
        }
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationCallable;
    private final OperationCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationCallable;
    private final UnaryCallable<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleCallable;
    private final OperationCallable<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationCallable;
    private final UnaryCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesCallable;
    private final OperationCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationCallable;
    private final UnaryCallable<DeleteOrganizationSecurityPolicyRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getCallable;
    private final UnaryCallable<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationCallable;
    private final UnaryCallable<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable;
    private final UnaryCallable<InsertOrganizationSecurityPolicyRequest, Operation> insertCallable;
    private final OperationCallable<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList> listCallable;
    private final UnaryCallable<ListOrganizationSecurityPoliciesRequest, OrganizationSecurityPoliciesClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsCallable;
    private final UnaryCallable<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsCallable;
    private final UnaryCallable<MoveOrganizationSecurityPolicyRequest, Operation> moveCallable;
    private final OperationCallable<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationCallable;
    private final UnaryCallable<PatchOrganizationSecurityPolicyRequest, Operation> patchCallable;
    private final OperationCallable<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationCallable;
    private final UnaryCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleCallable;
    private final OperationCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationCallable;
    private final UnaryCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationCallable;
    private final OperationCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationCallable;
    private final UnaryCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleCallable;
    private final OperationCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonGlobalOrganizationOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonOrganizationSecurityPoliciesStub create(OrganizationSecurityPoliciesStubSettings settings) throws IOException {
        return new HttpJsonOrganizationSecurityPoliciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonOrganizationSecurityPoliciesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonOrganizationSecurityPoliciesStub(OrganizationSecurityPoliciesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonOrganizationSecurityPoliciesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonOrganizationSecurityPoliciesStub(OrganizationSecurityPoliciesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonOrganizationSecurityPoliciesStub(OrganizationSecurityPoliciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonOrganizationSecurityPoliciesCallableFactory());
    }

    protected HttpJsonOrganizationSecurityPoliciesStub(OrganizationSecurityPoliciesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonGlobalOrganizationOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings addAssociationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addAssociationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings addRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings copyRulesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(copyRulesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAssociationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAssociationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listAssociationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAssociationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listPreconfiguredExpressionSetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPreconfiguredExpressionSetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings moveTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings removeAssociationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeAssociationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        HttpJsonCallSettings removeRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("security_policy", String.valueOf(request.getSecurityPolicy()));
            return builder.build();
        }).build();
        this.addAssociationCallable = callableFactory.createUnaryCallable(addAssociationTransportSettings, settings.addAssociationSettings(), clientContext);
        this.addAssociationOperationCallable = callableFactory.createOperationCallable(addAssociationTransportSettings, settings.addAssociationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.addRuleCallable = callableFactory.createUnaryCallable(addRuleTransportSettings, settings.addRuleSettings(), clientContext);
        this.addRuleOperationCallable = callableFactory.createOperationCallable(addRuleTransportSettings, settings.addRuleOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.copyRulesCallable = callableFactory.createUnaryCallable(copyRulesTransportSettings, settings.copyRulesSettings(), clientContext);
        this.copyRulesOperationCallable = callableFactory.createOperationCallable(copyRulesTransportSettings, settings.copyRulesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getAssociationCallable = callableFactory.createUnaryCallable(getAssociationTransportSettings, settings.getAssociationSettings(), clientContext);
        this.getRuleCallable = callableFactory.createUnaryCallable(getRuleTransportSettings, settings.getRuleSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listAssociationsCallable = callableFactory.createUnaryCallable(listAssociationsTransportSettings, settings.listAssociationsSettings(), clientContext);
        this.listPreconfiguredExpressionSetsCallable = callableFactory.createUnaryCallable(listPreconfiguredExpressionSetsTransportSettings, settings.listPreconfiguredExpressionSetsSettings(), clientContext);
        this.moveCallable = callableFactory.createUnaryCallable(moveTransportSettings, settings.moveSettings(), clientContext);
        this.moveOperationCallable = callableFactory.createOperationCallable(moveTransportSettings, settings.moveOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.patchOperationCallable = callableFactory.createOperationCallable(patchTransportSettings, settings.patchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.patchRuleCallable = callableFactory.createUnaryCallable(patchRuleTransportSettings, settings.patchRuleSettings(), clientContext);
        this.patchRuleOperationCallable = callableFactory.createOperationCallable(patchRuleTransportSettings, settings.patchRuleOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.removeAssociationCallable = callableFactory.createUnaryCallable(removeAssociationTransportSettings, settings.removeAssociationSettings(), clientContext);
        this.removeAssociationOperationCallable = callableFactory.createOperationCallable(removeAssociationTransportSettings, settings.removeAssociationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.removeRuleCallable = callableFactory.createUnaryCallable(removeRuleTransportSettings, settings.removeRuleSettings(), clientContext);
        this.removeRuleOperationCallable = callableFactory.createOperationCallable(removeRuleTransportSettings, settings.removeRuleOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(addAssociationMethodDescriptor);
        methodDescriptors.add(addRuleMethodDescriptor);
        methodDescriptors.add(copyRulesMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getAssociationMethodDescriptor);
        methodDescriptors.add(getRuleMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(listAssociationsMethodDescriptor);
        methodDescriptors.add(listPreconfiguredExpressionSetsMethodDescriptor);
        methodDescriptors.add(moveMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(patchRuleMethodDescriptor);
        methodDescriptors.add(removeAssociationMethodDescriptor);
        methodDescriptors.add(removeRuleMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation> addAssociationCallable() {
        return this.addAssociationCallable;
    }

    @Override
    public OperationCallable<AddAssociationOrganizationSecurityPolicyRequest, Operation, Operation> addAssociationOperationCallable() {
        return this.addAssociationOperationCallable;
    }

    @Override
    public UnaryCallable<AddRuleOrganizationSecurityPolicyRequest, Operation> addRuleCallable() {
        return this.addRuleCallable;
    }

    @Override
    public OperationCallable<AddRuleOrganizationSecurityPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.addRuleOperationCallable;
    }

    @Override
    public UnaryCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation> copyRulesCallable() {
        return this.copyRulesCallable;
    }

    @Override
    public OperationCallable<CopyRulesOrganizationSecurityPolicyRequest, Operation, Operation> copyRulesOperationCallable() {
        return this.copyRulesOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteOrganizationSecurityPolicyRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteOrganizationSecurityPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetOrganizationSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetAssociationOrganizationSecurityPolicyRequest, SecurityPolicyAssociation> getAssociationCallable() {
        return this.getAssociationCallable;
    }

    @Override
    public UnaryCallable<GetRuleOrganizationSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable() {
        return this.getRuleCallable;
    }

    @Override
    public UnaryCallable<InsertOrganizationSecurityPolicyRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertOrganizationSecurityPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListOrganizationSecurityPoliciesRequest, OrganizationSecurityPoliciesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListAssociationsOrganizationSecurityPolicyRequest, OrganizationSecurityPoliciesListAssociationsResponse> listAssociationsCallable() {
        return this.listAssociationsCallable;
    }

    @Override
    public UnaryCallable<ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsCallable() {
        return this.listPreconfiguredExpressionSetsCallable;
    }

    @Override
    public UnaryCallable<MoveOrganizationSecurityPolicyRequest, Operation> moveCallable() {
        return this.moveCallable;
    }

    @Override
    public OperationCallable<MoveOrganizationSecurityPolicyRequest, Operation, Operation> moveOperationCallable() {
        return this.moveOperationCallable;
    }

    @Override
    public UnaryCallable<PatchOrganizationSecurityPolicyRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public OperationCallable<PatchOrganizationSecurityPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.patchOperationCallable;
    }

    @Override
    public UnaryCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation> patchRuleCallable() {
        return this.patchRuleCallable;
    }

    @Override
    public OperationCallable<PatchRuleOrganizationSecurityPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.patchRuleOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation> removeAssociationCallable() {
        return this.removeAssociationCallable;
    }

    @Override
    public OperationCallable<RemoveAssociationOrganizationSecurityPolicyRequest, Operation, Operation> removeAssociationOperationCallable() {
        return this.removeAssociationOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation> removeRuleCallable() {
        return this.removeRuleCallable;
    }

    @Override
    public OperationCallable<RemoveRuleOrganizationSecurityPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.removeRuleOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

