/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetOperationalStatusInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.InterconnectAttachmentGroup;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsClient;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsGetOperationalStatusResponse;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsListResponse;
import com.google.cloud.compute.v1.ListInterconnectAttachmentGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectAttachmentGroupsCallableFactory;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentGroupsStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentGroupsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonInterconnectAttachmentGroupsStub
extends InterconnectAttachmentGroupsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<DeleteInterconnectAttachmentGroupRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnectAttachmentGroup", (Object)request.getInterconnectAttachmentGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnectAttachmentGroup", (Object)request.getInterconnectAttachmentGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectAttachmentGroup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{resource}/getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasOptionsRequestedPolicyVersion()) {
            serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/GetOperationalStatus").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}/getOperationalStatus", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnectAttachmentGroup", (Object)request.getInterconnectAttachmentGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectAttachmentGroupsGetOperationalStatusResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertInterconnectAttachmentGroupRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/Insert").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("interconnectAttachmentGroupResource", (Message)request.getInterconnectAttachmentGroupResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InterconnectAttachmentGroupsListResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PatchInterconnectAttachmentGroupRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/Patch").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{interconnectAttachmentGroup}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "interconnectAttachmentGroup", (Object)request.getInterconnectAttachmentGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        if (request.hasUpdateMask()) {
            serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("interconnectAttachmentGroupResource", (Message)request.getInterconnectAttachmentGroupResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{resource}/setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("globalSetPolicyRequestResource", (Message)request.getGlobalSetPolicyRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InterconnectAttachmentGroups/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/interconnectAttachmentGroups/{resource}/testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<DeleteInterconnectAttachmentGroupRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getCallable;
    private final UnaryCallable<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusCallable;
    private final UnaryCallable<InsertInterconnectAttachmentGroupRequest, Operation> insertCallable;
    private final OperationCallable<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse> listCallable;
    private final UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchInterconnectAttachmentGroupRequest, Operation> patchCallable;
    private final OperationCallable<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationCallable;
    private final UnaryCallable<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonGlobalOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInterconnectAttachmentGroupsStub create(InterconnectAttachmentGroupsStubSettings settings) throws IOException {
        return new HttpJsonInterconnectAttachmentGroupsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInterconnectAttachmentGroupsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInterconnectAttachmentGroupsStub(InterconnectAttachmentGroupsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInterconnectAttachmentGroupsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInterconnectAttachmentGroupsStub(InterconnectAttachmentGroupsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInterconnectAttachmentGroupsStub(InterconnectAttachmentGroupsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInterconnectAttachmentGroupsCallableFactory());
    }

    protected HttpJsonInterconnectAttachmentGroupsStub(InterconnectAttachmentGroupsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonGlobalOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect_attachment_group", String.valueOf(request.getInterconnectAttachmentGroup()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect_attachment_group", String.valueOf(request.getInterconnectAttachmentGroup()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getOperationalStatusTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getOperationalStatusMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect_attachment_group", String.valueOf(request.getInterconnectAttachmentGroup()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("interconnect_attachment_group", String.valueOf(request.getInterconnectAttachmentGroup()));
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.getOperationalStatusCallable = callableFactory.createUnaryCallable(getOperationalStatusTransportSettings, settings.getOperationalStatusSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.patchOperationCallable = callableFactory.createOperationCallable(patchTransportSettings, settings.patchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(getOperationalStatusMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteInterconnectAttachmentGroupRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusCallable() {
        return this.getOperationalStatusCallable;
    }

    @Override
    public UnaryCallable<InsertInterconnectAttachmentGroupRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PatchInterconnectAttachmentGroupRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public OperationCallable<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationCallable() {
        return this.patchOperationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

