/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetReservationSubBlockRequest;
import com.google.cloud.compute.v1.ListReservationSubBlocksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PerformMaintenanceReservationSubBlockRequest;
import com.google.cloud.compute.v1.ReservationSubBlocksClient;
import com.google.cloud.compute.v1.ReservationSubBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationSubBlocksListResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationSubBlocksCallableFactory;
import com.google.cloud.compute.v1.stub.HttpJsonZoneOperationsStub;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonReservationSubBlocksStub
extends ReservationSubBlocksStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ReservationSubBlocks/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/{parentName}/reservationSubBlocks/{reservationSubBlock}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parentName", (Object)request.getParentName());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "reservationSubBlock", (Object)request.getReservationSubBlock());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReservationSubBlocksGetResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ReservationSubBlocks/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/{parentName}/reservationSubBlocks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parentName", (Object)request.getParentName());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReservationSubBlocksListResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.ReservationSubBlocks/PerformMaintenance").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/{parentName}/reservationSubBlocks/{reservationSubBlock}/performMaintenance", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parentName", (Object)request.getParentName());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "reservationSubBlock", (Object)request.getReservationSubBlock());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getCallable;
    private final UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> listCallable;
    private final UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceCallable;
    private final OperationCallable<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonZoneOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReservationSubBlocksStub create(ReservationSubBlocksStubSettings settings) throws IOException {
        return new HttpJsonReservationSubBlocksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReservationSubBlocksStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReservationSubBlocksStub(ReservationSubBlocksStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonReservationSubBlocksStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReservationSubBlocksStub(ReservationSubBlocksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReservationSubBlocksStub(ReservationSubBlocksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReservationSubBlocksCallableFactory());
    }

    protected HttpJsonReservationSubBlocksStub(ReservationSubBlocksStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonZoneOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent_name", String.valueOf(request.getParentName()));
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("reservation_sub_block", String.valueOf(request.getReservationSubBlock()));
            builder.add("zone", String.valueOf(request.getZone()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent_name", String.valueOf(request.getParentName()));
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("zone", String.valueOf(request.getZone()));
            return builder.build();
        }).build();
        HttpJsonCallSettings performMaintenanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(performMaintenanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent_name", String.valueOf(request.getParentName()));
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("reservation_sub_block", String.valueOf(request.getReservationSubBlock()));
            builder.add("zone", String.valueOf(request.getZone()));
            return builder.build();
        }).build();
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.performMaintenanceCallable = callableFactory.createUnaryCallable(performMaintenanceTransportSettings, settings.performMaintenanceSettings(), clientContext);
        this.performMaintenanceOperationCallable = callableFactory.createOperationCallable(performMaintenanceTransportSettings, settings.performMaintenanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(performMaintenanceMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceCallable() {
        return this.performMaintenanceCallable;
    }

    @Override
    public OperationCallable<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationCallable() {
        return this.performMaintenanceOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

