/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRoutersRequest;
import com.google.cloud.compute.v1.BgpRoute;
import com.google.cloud.compute.v1.DeleteRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.DeleteRouterRequest;
import com.google.cloud.compute.v1.GetNatIpInfoRouterRequest;
import com.google.cloud.compute.v1.GetNatMappingInfoRoutersRequest;
import com.google.cloud.compute.v1.GetRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.GetRouterRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterRequest;
import com.google.cloud.compute.v1.InsertRouterRequest;
import com.google.cloud.compute.v1.ListBgpRoutesRoutersRequest;
import com.google.cloud.compute.v1.ListRoutePoliciesRoutersRequest;
import com.google.cloud.compute.v1.ListRoutersRequest;
import com.google.cloud.compute.v1.NatIpInfoResponse;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.PatchRouterRequest;
import com.google.cloud.compute.v1.PreviewRouterRequest;
import com.google.cloud.compute.v1.RoutePolicy;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersClient;
import com.google.cloud.compute.v1.RoutersGetRoutePolicyResponse;
import com.google.cloud.compute.v1.RoutersListBgpRoutes;
import com.google.cloud.compute.v1.RoutersListRoutePolicies;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.RoutersScopedList;
import com.google.cloud.compute.v1.UpdateRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.UpdateRouterRequest;
import com.google.cloud.compute.v1.VmEndpointNatMappings;
import com.google.cloud.compute.v1.VmEndpointNatMappingsList;
import com.google.cloud.compute.v1.stub.HttpJsonRoutersStub;
import com.google.cloud.compute.v1.stub.RoutersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoutersStubSettings
extends StubSettings<RoutersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteRouterRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRouterRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteRoutePolicyRouterRequest, Operation> deleteRoutePolicySettings;
    private final OperationCallSettings<DeleteRoutePolicyRouterRequest, Operation, Operation> deleteRoutePolicyOperationSettings;
    private final UnaryCallSettings<GetRouterRequest, Router> getSettings;
    private final UnaryCallSettings<GetNatIpInfoRouterRequest, NatIpInfoResponse> getNatIpInfoSettings;
    private final PagedCallSettings<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse> getNatMappingInfoSettings;
    private final UnaryCallSettings<GetRoutePolicyRouterRequest, RoutersGetRoutePolicyResponse> getRoutePolicySettings;
    private final UnaryCallSettings<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusSettings;
    private final UnaryCallSettings<InsertRouterRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRouterRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse> listBgpRoutesSettings;
    private final PagedCallSettings<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse> listRoutePoliciesSettings;
    private final UnaryCallSettings<PatchRouterRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchRouterRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchRoutePolicyRouterRequest, Operation> patchRoutePolicySettings;
    private final OperationCallSettings<PatchRoutePolicyRouterRequest, Operation, Operation> patchRoutePolicyOperationSettings;
    private final UnaryCallSettings<PreviewRouterRequest, RoutersPreviewResponse> previewSettings;
    private final UnaryCallSettings<UpdateRouterRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateRouterRequest, Operation, Operation> updateOperationSettings;
    private final UnaryCallSettings<UpdateRoutePolicyRouterRequest, Operation> updateRoutePolicySettings;
    private final OperationCallSettings<UpdateRoutePolicyRouterRequest, Operation, Operation> updateRoutePolicyOperationSettings;
    private static final PagedListDescriptor<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListRoutersRequest injectToken(AggregatedListRoutersRequest payload, String token) {
            return AggregatedListRoutersRequest.newBuilder((AggregatedListRoutersRequest)payload).setPageToken(token).build();
        }

        public AggregatedListRoutersRequest injectPageSize(AggregatedListRoutersRequest payload, int pageSize) {
            return AggregatedListRoutersRequest.newBuilder((AggregatedListRoutersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListRoutersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RouterAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, RoutersScopedList>> extractResources(RouterAggregatedList payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> GET_NAT_MAPPING_INFO_PAGE_STR_DESC = new PagedListDescriptor<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings>(){

        public String emptyToken() {
            return "";
        }

        public GetNatMappingInfoRoutersRequest injectToken(GetNatMappingInfoRoutersRequest payload, String token) {
            return GetNatMappingInfoRoutersRequest.newBuilder((GetNatMappingInfoRoutersRequest)payload).setPageToken(token).build();
        }

        public GetNatMappingInfoRoutersRequest injectPageSize(GetNatMappingInfoRoutersRequest payload, int pageSize) {
            return GetNatMappingInfoRoutersRequest.newBuilder((GetNatMappingInfoRoutersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(GetNatMappingInfoRoutersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(VmEndpointNatMappingsList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VmEndpointNatMappings> extractResources(VmEndpointNatMappingsList payload) {
            return payload.getResultList();
        }
    };
    private static final PagedListDescriptor<ListRoutersRequest, RouterList, Router> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRoutersRequest, RouterList, Router>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutersRequest injectToken(ListRoutersRequest payload, String token) {
            return ListRoutersRequest.newBuilder((ListRoutersRequest)payload).setPageToken(token).build();
        }

        public ListRoutersRequest injectPageSize(ListRoutersRequest payload, int pageSize) {
            return ListRoutersRequest.newBuilder((ListRoutersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRoutersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RouterList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Router> extractResources(RouterList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute> LIST_BGP_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListBgpRoutesRoutersRequest injectToken(ListBgpRoutesRoutersRequest payload, String token) {
            return ListBgpRoutesRoutersRequest.newBuilder((ListBgpRoutesRoutersRequest)payload).setPageToken(token).build();
        }

        public ListBgpRoutesRoutersRequest injectPageSize(ListBgpRoutesRoutersRequest payload, int pageSize) {
            return ListBgpRoutesRoutersRequest.newBuilder((ListBgpRoutesRoutersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListBgpRoutesRoutersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RoutersListBgpRoutes payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BgpRoute> extractResources(RoutersListBgpRoutes payload) {
            return payload.getResultList();
        }
    };
    private static final PagedListDescriptor<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy> LIST_ROUTE_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutePoliciesRoutersRequest injectToken(ListRoutePoliciesRoutersRequest payload, String token) {
            return ListRoutePoliciesRoutersRequest.newBuilder((ListRoutePoliciesRoutersRequest)payload).setPageToken(token).build();
        }

        public ListRoutePoliciesRoutersRequest injectPageSize(ListRoutePoliciesRoutersRequest payload, int pageSize) {
            return ListRoutePoliciesRoutersRequest.newBuilder((ListRoutePoliciesRoutersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRoutePoliciesRoutersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RoutersListRoutePolicies payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RoutePolicy> extractResources(RoutersListRoutePolicies payload) {
            return payload.getResultList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse>(){

        public ApiFuture<RoutersClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListRoutersRequest, RouterAggregatedList> callable, AggregatedListRoutersRequest request, ApiCallContext context, ApiFuture<RouterAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoutersClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse> GET_NAT_MAPPING_INFO_PAGE_STR_FACT = new PagedListResponseFactory<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse>(){

        public ApiFuture<RoutersClient.GetNatMappingInfoPagedResponse> getFuturePagedResponse(UnaryCallable<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList> callable, GetNatMappingInfoRoutersRequest request, ApiCallContext context, ApiFuture<VmEndpointNatMappingsList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_NAT_MAPPING_INFO_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoutersClient.GetNatMappingInfoPagedResponse.createAsync((PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse>(){

        public ApiFuture<RoutersClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutersRequest, RouterList> callable, ListRoutersRequest request, ApiCallContext context, ApiFuture<RouterList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoutersClient.ListPagedResponse.createAsync((PageContext<ListRoutersRequest, RouterList, Router>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse> LIST_BGP_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse>(){

        public ApiFuture<RoutersClient.ListBgpRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes> callable, ListBgpRoutesRoutersRequest request, ApiCallContext context, ApiFuture<RoutersListBgpRoutes> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BGP_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoutersClient.ListBgpRoutesPagedResponse.createAsync((PageContext<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse> LIST_ROUTE_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse>(){

        public ApiFuture<RoutersClient.ListRoutePoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies> callable, ListRoutePoliciesRoutersRequest request, ApiCallContext context, ApiFuture<RoutersListRoutePolicies> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTE_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RoutersClient.ListRoutePoliciesPagedResponse.createAsync((PageContext<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteRouterRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRouterRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteRoutePolicyRouterRequest, Operation> deleteRoutePolicySettings() {
        return this.deleteRoutePolicySettings;
    }

    public OperationCallSettings<DeleteRoutePolicyRouterRequest, Operation, Operation> deleteRoutePolicyOperationSettings() {
        return this.deleteRoutePolicyOperationSettings;
    }

    public UnaryCallSettings<GetRouterRequest, Router> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetNatIpInfoRouterRequest, NatIpInfoResponse> getNatIpInfoSettings() {
        return this.getNatIpInfoSettings;
    }

    public PagedCallSettings<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse> getNatMappingInfoSettings() {
        return this.getNatMappingInfoSettings;
    }

    public UnaryCallSettings<GetRoutePolicyRouterRequest, RoutersGetRoutePolicyResponse> getRoutePolicySettings() {
        return this.getRoutePolicySettings;
    }

    public UnaryCallSettings<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusSettings() {
        return this.getRouterStatusSettings;
    }

    public UnaryCallSettings<InsertRouterRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRouterRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse> listBgpRoutesSettings() {
        return this.listBgpRoutesSettings;
    }

    public PagedCallSettings<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse> listRoutePoliciesSettings() {
        return this.listRoutePoliciesSettings;
    }

    public UnaryCallSettings<PatchRouterRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchRouterRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchRoutePolicyRouterRequest, Operation> patchRoutePolicySettings() {
        return this.patchRoutePolicySettings;
    }

    public OperationCallSettings<PatchRoutePolicyRouterRequest, Operation, Operation> patchRoutePolicyOperationSettings() {
        return this.patchRoutePolicyOperationSettings;
    }

    public UnaryCallSettings<PreviewRouterRequest, RoutersPreviewResponse> previewSettings() {
        return this.previewSettings;
    }

    public UnaryCallSettings<UpdateRouterRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateRouterRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public UnaryCallSettings<UpdateRoutePolicyRouterRequest, Operation> updateRoutePolicySettings() {
        return this.updateRoutePolicySettings;
    }

    public OperationCallSettings<UpdateRoutePolicyRouterRequest, Operation, Operation> updateRoutePolicyOperationSettings() {
        return this.updateRoutePolicyOperationSettings;
    }

    public RoutersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRoutersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RoutersStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RoutersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RoutersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteRoutePolicySettings = settingsBuilder.deleteRoutePolicySettings().build();
        this.deleteRoutePolicyOperationSettings = settingsBuilder.deleteRoutePolicyOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getNatIpInfoSettings = settingsBuilder.getNatIpInfoSettings().build();
        this.getNatMappingInfoSettings = settingsBuilder.getNatMappingInfoSettings().build();
        this.getRoutePolicySettings = settingsBuilder.getRoutePolicySettings().build();
        this.getRouterStatusSettings = settingsBuilder.getRouterStatusSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listBgpRoutesSettings = settingsBuilder.listBgpRoutesSettings().build();
        this.listRoutePoliciesSettings = settingsBuilder.listRoutePoliciesSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchRoutePolicySettings = settingsBuilder.patchRoutePolicySettings().build();
        this.patchRoutePolicyOperationSettings = settingsBuilder.patchRoutePolicyOperationSettings().build();
        this.previewSettings = settingsBuilder.previewSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
        this.updateRoutePolicySettings = settingsBuilder.updateRoutePolicySettings().build();
        this.updateRoutePolicyOperationSettings = settingsBuilder.updateRoutePolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RoutersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteRouterRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRouterRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRoutePolicyRouterRequest, Operation> deleteRoutePolicySettings;
        private final OperationCallSettings.Builder<DeleteRoutePolicyRouterRequest, Operation, Operation> deleteRoutePolicyOperationSettings;
        private final UnaryCallSettings.Builder<GetRouterRequest, Router> getSettings;
        private final UnaryCallSettings.Builder<GetNatIpInfoRouterRequest, NatIpInfoResponse> getNatIpInfoSettings;
        private final PagedCallSettings.Builder<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse> getNatMappingInfoSettings;
        private final UnaryCallSettings.Builder<GetRoutePolicyRouterRequest, RoutersGetRoutePolicyResponse> getRoutePolicySettings;
        private final UnaryCallSettings.Builder<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusSettings;
        private final UnaryCallSettings.Builder<InsertRouterRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRouterRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse> listBgpRoutesSettings;
        private final PagedCallSettings.Builder<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse> listRoutePoliciesSettings;
        private final UnaryCallSettings.Builder<PatchRouterRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchRouterRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchRoutePolicyRouterRequest, Operation> patchRoutePolicySettings;
        private final OperationCallSettings.Builder<PatchRoutePolicyRouterRequest, Operation, Operation> patchRoutePolicyOperationSettings;
        private final UnaryCallSettings.Builder<PreviewRouterRequest, RoutersPreviewResponse> previewSettings;
        private final UnaryCallSettings.Builder<UpdateRouterRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateRouterRequest, Operation, Operation> updateOperationSettings;
        private final UnaryCallSettings.Builder<UpdateRoutePolicyRouterRequest, Operation> updateRoutePolicySettings;
        private final OperationCallSettings.Builder<UpdateRoutePolicyRouterRequest, Operation, Operation> updateRoutePolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRoutePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRoutePolicyOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNatIpInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getNatMappingInfoSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_NAT_MAPPING_INFO_PAGE_STR_FACT);
            this.getRoutePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRouterStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listBgpRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BGP_ROUTES_PAGE_STR_FACT);
            this.listRoutePoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTE_POLICIES_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchRoutePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRoutePolicyOperationSettings = OperationCallSettings.newBuilder();
            this.previewSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.updateRoutePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRoutePolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.deleteRoutePolicySettings, this.getSettings, this.getNatIpInfoSettings, this.getNatMappingInfoSettings, this.getRoutePolicySettings, this.getRouterStatusSettings, this.insertSettings, this.listSettings, this.listBgpRoutesSettings, this.listRoutePoliciesSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRoutePolicySettings, this.previewSettings, this.updateSettings, this.updateRoutePolicySettings});
            Builder.initDefaults(this);
        }

        protected Builder(RoutersStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteRoutePolicySettings = settings.deleteRoutePolicySettings.toBuilder();
            this.deleteRoutePolicyOperationSettings = settings.deleteRoutePolicyOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getNatIpInfoSettings = settings.getNatIpInfoSettings.toBuilder();
            this.getNatMappingInfoSettings = settings.getNatMappingInfoSettings.toBuilder();
            this.getRoutePolicySettings = settings.getRoutePolicySettings.toBuilder();
            this.getRouterStatusSettings = settings.getRouterStatusSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listBgpRoutesSettings = settings.listBgpRoutesSettings.toBuilder();
            this.listRoutePoliciesSettings = settings.listRoutePoliciesSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchRoutePolicySettings = settings.patchRoutePolicySettings.toBuilder();
            this.patchRoutePolicyOperationSettings = settings.patchRoutePolicyOperationSettings.toBuilder();
            this.previewSettings = settings.previewSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.updateRoutePolicySettings = settings.updateRoutePolicySettings.toBuilder();
            this.updateRoutePolicyOperationSettings = settings.updateRoutePolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.deleteRoutePolicySettings, this.getSettings, this.getNatIpInfoSettings, this.getNatMappingInfoSettings, this.getRoutePolicySettings, this.getRouterStatusSettings, this.insertSettings, this.listSettings, this.listBgpRoutesSettings, this.listRoutePoliciesSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchRoutePolicySettings, this.previewSettings, this.updateSettings, this.updateRoutePolicySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RoutersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RoutersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RoutersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RoutersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRoutePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNatIpInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNatMappingInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRoutePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRouterStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listBgpRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRoutePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRoutePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.previewSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateRoutePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteRoutePolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchRoutePolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.updateRoutePolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListRoutersRequest, RouterAggregatedList, RoutersClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteRouterRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRouterRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRoutePolicyRouterRequest, Operation> deleteRoutePolicySettings() {
            return this.deleteRoutePolicySettings;
        }

        public OperationCallSettings.Builder<DeleteRoutePolicyRouterRequest, Operation, Operation> deleteRoutePolicyOperationSettings() {
            return this.deleteRoutePolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRouterRequest, Router> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetNatIpInfoRouterRequest, NatIpInfoResponse> getNatIpInfoSettings() {
            return this.getNatIpInfoSettings;
        }

        public PagedCallSettings.Builder<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, RoutersClient.GetNatMappingInfoPagedResponse> getNatMappingInfoSettings() {
            return this.getNatMappingInfoSettings;
        }

        public UnaryCallSettings.Builder<GetRoutePolicyRouterRequest, RoutersGetRoutePolicyResponse> getRoutePolicySettings() {
            return this.getRoutePolicySettings;
        }

        public UnaryCallSettings.Builder<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusSettings() {
            return this.getRouterStatusSettings;
        }

        public UnaryCallSettings.Builder<InsertRouterRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRouterRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRoutersRequest, RouterList, RoutersClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, RoutersClient.ListBgpRoutesPagedResponse> listBgpRoutesSettings() {
            return this.listBgpRoutesSettings;
        }

        public PagedCallSettings.Builder<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutersClient.ListRoutePoliciesPagedResponse> listRoutePoliciesSettings() {
            return this.listRoutePoliciesSettings;
        }

        public UnaryCallSettings.Builder<PatchRouterRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchRouterRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRoutePolicyRouterRequest, Operation> patchRoutePolicySettings() {
            return this.patchRoutePolicySettings;
        }

        public OperationCallSettings.Builder<PatchRoutePolicyRouterRequest, Operation, Operation> patchRoutePolicyOperationSettings() {
            return this.patchRoutePolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewRouterRequest, RoutersPreviewResponse> previewSettings() {
            return this.previewSettings;
        }

        public UnaryCallSettings.Builder<UpdateRouterRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateRouterRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateRoutePolicyRouterRequest, Operation> updateRoutePolicySettings() {
            return this.updateRoutePolicySettings;
        }

        public OperationCallSettings.Builder<UpdateRoutePolicyRouterRequest, Operation, Operation> updateRoutePolicyOperationSettings() {
            return this.updateRoutePolicyOperationSettings;
        }

        public RoutersStubSettings build() throws IOException {
            return new RoutersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

