/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.GetOperationalStatusInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.InterconnectAttachmentGroup;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsClient;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsGetOperationalStatusResponse;
import com.google.cloud.compute.v1.InterconnectAttachmentGroupsListResponse;
import com.google.cloud.compute.v1.ListInterconnectAttachmentGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInterconnectAttachmentGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectAttachmentGroupsStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class InterconnectAttachmentGroupsStubSettings
extends StubSettings<InterconnectAttachmentGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteInterconnectAttachmentGroupRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getSettings;
    private final UnaryCallSettings<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusSettings;
    private final UnaryCallSettings<InsertInterconnectAttachmentGroupRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchInterconnectAttachmentGroupRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectAttachmentGroupsRequest injectToken(ListInterconnectAttachmentGroupsRequest payload, String token) {
            return ListInterconnectAttachmentGroupsRequest.newBuilder((ListInterconnectAttachmentGroupsRequest)payload).setPageToken(token).build();
        }

        public ListInterconnectAttachmentGroupsRequest injectPageSize(ListInterconnectAttachmentGroupsRequest payload, int pageSize) {
            return ListInterconnectAttachmentGroupsRequest.newBuilder((ListInterconnectAttachmentGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectAttachmentGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectAttachmentGroupsListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectAttachmentGroup> extractResources(InterconnectAttachmentGroupsListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse>(){

        public ApiFuture<InterconnectAttachmentGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse> callable, ListInterconnectAttachmentGroupsRequest request, ApiCallContext context, ApiFuture<InterconnectAttachmentGroupsListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectAttachmentGroupsClient.ListPagedResponse.createAsync((PageContext<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroup>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteInterconnectAttachmentGroupRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusSettings() {
        return this.getOperationalStatusSettings;
    }

    public UnaryCallSettings<InsertInterconnectAttachmentGroupRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchInterconnectAttachmentGroupRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public InterconnectAttachmentGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectAttachmentGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectAttachmentGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectAttachmentGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectAttachmentGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getOperationalStatusSettings = settingsBuilder.getOperationalStatusSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectAttachmentGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteInterconnectAttachmentGroupRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusSettings;
        private final UnaryCallSettings.Builder<InsertInterconnectAttachmentGroupRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchInterconnectAttachmentGroupRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getOperationalStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.getOperationalStatusSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InterconnectAttachmentGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getOperationalStatusSettings = settings.getOperationalStatusSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.getOperationalStatusSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectAttachmentGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectAttachmentGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectAttachmentGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InterconnectAttachmentGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getOperationalStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteInterconnectAttachmentGroupRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteInterconnectAttachmentGroupRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectAttachmentGroupRequest, InterconnectAttachmentGroup> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyInterconnectAttachmentGroupRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetOperationalStatusInterconnectAttachmentGroupRequest, InterconnectAttachmentGroupsGetOperationalStatusResponse> getOperationalStatusSettings() {
            return this.getOperationalStatusSettings;
        }

        public UnaryCallSettings.Builder<InsertInterconnectAttachmentGroupRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertInterconnectAttachmentGroupRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectAttachmentGroupsRequest, InterconnectAttachmentGroupsListResponse, InterconnectAttachmentGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchInterconnectAttachmentGroupRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchInterconnectAttachmentGroupRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyInterconnectAttachmentGroupRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsInterconnectAttachmentGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public InterconnectAttachmentGroupsStubSettings build() throws IOException {
            return new InterconnectAttachmentGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

