/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ApplyUpdatesToInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.CreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeletePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagerAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupManagerList;
import com.google.cloud.compute.v1.InstanceGroupManagersAbandonInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersApplyUpdatesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersCreateInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersDeleteInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersDeletePerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceGroupManagersListErrorsResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListManagedInstancesResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListPerInstanceConfigsResp;
import com.google.cloud.compute.v1.InstanceGroupManagersPatchPerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceGroupManagersRecreateInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersResumeInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersScopedList;
import com.google.cloud.compute.v1.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSettings;
import com.google.cloud.compute.v1.InstanceGroupManagersStartInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersStopInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersUpdatePerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceManagedByIgmError;
import com.google.cloud.compute.v1.ListErrorsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListManagedInstancesInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListPerInstanceConfigsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ManagedInstance;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PatchPerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PerInstanceConfig;
import com.google.cloud.compute.v1.RecreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.ResizeInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.ResumeInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetTargetPoolsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.StartInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.StopInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.UpdatePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.stub.InstanceGroupManagersStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceGroupManagersClient
implements BackgroundResource {
    private final InstanceGroupManagersSettings settings;
    private final InstanceGroupManagersStub stub;

    public static final InstanceGroupManagersClient create() throws IOException {
        return InstanceGroupManagersClient.create(InstanceGroupManagersSettings.newBuilder().build());
    }

    public static final InstanceGroupManagersClient create(InstanceGroupManagersSettings settings) throws IOException {
        return new InstanceGroupManagersClient(settings);
    }

    public static final InstanceGroupManagersClient create(InstanceGroupManagersStub stub) {
        return new InstanceGroupManagersClient(stub);
    }

    protected InstanceGroupManagersClient(InstanceGroupManagersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupManagersStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstanceGroupManagersClient(InstanceGroupManagersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupManagersSettings getSettings() {
        return this.settings;
    }

    public InstanceGroupManagersStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> abandonInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequestResource) {
        AbandonInstancesInstanceGroupManagerRequest request = AbandonInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersAbandonInstancesRequestResource(instanceGroupManagersAbandonInstancesRequestResource).build();
        return this.abandonInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> abandonInstancesAsync(AbandonInstancesInstanceGroupManagerRequest request) {
        return this.abandonInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AbandonInstancesInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationCallable() {
        return this.stub.abandonInstancesOperationCallable();
    }

    public final UnaryCallable<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesCallable() {
        return this.stub.abandonInstancesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstanceGroupManagersRequest request = AggregatedListInstanceGroupManagersRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstanceGroupManagersRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstanceGroupManagersRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> applyUpdatesToInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersApplyUpdatesRequest instanceGroupManagersApplyUpdatesRequestResource) {
        ApplyUpdatesToInstancesInstanceGroupManagerRequest request = ApplyUpdatesToInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersApplyUpdatesRequestResource(instanceGroupManagersApplyUpdatesRequestResource).build();
        return this.applyUpdatesToInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> applyUpdatesToInstancesAsync(ApplyUpdatesToInstancesInstanceGroupManagerRequest request) {
        return this.applyUpdatesToInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationCallable() {
        return this.stub.applyUpdatesToInstancesOperationCallable();
    }

    public final UnaryCallable<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesCallable() {
        return this.stub.applyUpdatesToInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> createInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersCreateInstancesRequest instanceGroupManagersCreateInstancesRequestResource) {
        CreateInstancesInstanceGroupManagerRequest request = CreateInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersCreateInstancesRequestResource(instanceGroupManagersCreateInstancesRequestResource).build();
        return this.createInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> createInstancesAsync(CreateInstancesInstanceGroupManagerRequest request) {
        return this.createInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstancesInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationCallable() {
        return this.stub.createInstancesOperationCallable();
    }

    public final UnaryCallable<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesCallable() {
        return this.stub.createInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String instanceGroupManager) {
        DeleteInstanceGroupManagerRequest request = DeleteInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInstanceGroupManagerRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceGroupManagerRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceGroupManagerRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> deleteInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequestResource) {
        DeleteInstancesInstanceGroupManagerRequest request = DeleteInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersDeleteInstancesRequestResource(instanceGroupManagersDeleteInstancesRequestResource).build();
        return this.deleteInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteInstancesAsync(DeleteInstancesInstanceGroupManagerRequest request) {
        return this.deleteInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstancesInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationCallable() {
        return this.stub.deleteInstancesOperationCallable();
    }

    public final UnaryCallable<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesCallable() {
        return this.stub.deleteInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> deletePerInstanceConfigsAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersDeletePerInstanceConfigsReq instanceGroupManagersDeletePerInstanceConfigsReqResource) {
        DeletePerInstanceConfigsInstanceGroupManagerRequest request = DeletePerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersDeletePerInstanceConfigsReqResource(instanceGroupManagersDeletePerInstanceConfigsReqResource).build();
        return this.deletePerInstanceConfigsAsync(request);
    }

    public final OperationFuture<Operation, Operation> deletePerInstanceConfigsAsync(DeletePerInstanceConfigsInstanceGroupManagerRequest request) {
        return this.deletePerInstanceConfigsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationCallable() {
        return this.stub.deletePerInstanceConfigsOperationCallable();
    }

    public final UnaryCallable<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsCallable() {
        return this.stub.deletePerInstanceConfigsCallable();
    }

    public final InstanceGroupManager get(String project, String zone, String instanceGroupManager) {
        GetInstanceGroupManagerRequest request = GetInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.get(request);
    }

    public final InstanceGroupManager get(GetInstanceGroupManagerRequest request) {
        return (InstanceGroupManager)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceGroupManagerRequest, InstanceGroupManager> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, InstanceGroupManager instanceGroupManagerResource) {
        InsertInstanceGroupManagerRequest request = InsertInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInstanceGroupManagerRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInstanceGroupManagerRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInstanceGroupManagerRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListInstanceGroupManagersRequest request = ListInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstanceGroupManagersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceGroupManagersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstanceGroupManagersRequest, InstanceGroupManagerList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListErrorsPagedResponse listErrors(String project, String zone, String instanceGroupManager) {
        ListErrorsInstanceGroupManagersRequest request = ListErrorsInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listErrors(request);
    }

    public final ListErrorsPagedResponse listErrors(ListErrorsInstanceGroupManagersRequest request) {
        return (ListErrorsPagedResponse)((Object)this.listErrorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListErrorsInstanceGroupManagersRequest, ListErrorsPagedResponse> listErrorsPagedCallable() {
        return this.stub.listErrorsPagedCallable();
    }

    public final UnaryCallable<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse> listErrorsCallable() {
        return this.stub.listErrorsCallable();
    }

    public final ListManagedInstancesPagedResponse listManagedInstances(String project, String zone, String instanceGroupManager) {
        ListManagedInstancesInstanceGroupManagersRequest request = ListManagedInstancesInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listManagedInstances(request);
    }

    public final ListManagedInstancesPagedResponse listManagedInstances(ListManagedInstancesInstanceGroupManagersRequest request) {
        return (ListManagedInstancesPagedResponse)((Object)this.listManagedInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagedInstancesInstanceGroupManagersRequest, ListManagedInstancesPagedResponse> listManagedInstancesPagedCallable() {
        return this.stub.listManagedInstancesPagedCallable();
    }

    public final UnaryCallable<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesCallable() {
        return this.stub.listManagedInstancesCallable();
    }

    public final ListPerInstanceConfigsPagedResponse listPerInstanceConfigs(String project, String zone, String instanceGroupManager) {
        ListPerInstanceConfigsInstanceGroupManagersRequest request = ListPerInstanceConfigsInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listPerInstanceConfigs(request);
    }

    public final ListPerInstanceConfigsPagedResponse listPerInstanceConfigs(ListPerInstanceConfigsInstanceGroupManagersRequest request) {
        return (ListPerInstanceConfigsPagedResponse)((Object)this.listPerInstanceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPerInstanceConfigsInstanceGroupManagersRequest, ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsPagedCallable() {
        return this.stub.listPerInstanceConfigsPagedCallable();
    }

    public final UnaryCallable<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp> listPerInstanceConfigsCallable() {
        return this.stub.listPerInstanceConfigsCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String zone, String instanceGroupManager, InstanceGroupManager instanceGroupManagerResource) {
        PatchInstanceGroupManagerRequest request = PatchInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchInstanceGroupManagerRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInstanceGroupManagerRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInstanceGroupManagerRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchPerInstanceConfigsAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersPatchPerInstanceConfigsReq instanceGroupManagersPatchPerInstanceConfigsReqResource) {
        PatchPerInstanceConfigsInstanceGroupManagerRequest request = PatchPerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersPatchPerInstanceConfigsReqResource(instanceGroupManagersPatchPerInstanceConfigsReqResource).build();
        return this.patchPerInstanceConfigsAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchPerInstanceConfigsAsync(PatchPerInstanceConfigsInstanceGroupManagerRequest request) {
        return this.patchPerInstanceConfigsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationCallable() {
        return this.stub.patchPerInstanceConfigsOperationCallable();
    }

    public final UnaryCallable<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsCallable() {
        return this.stub.patchPerInstanceConfigsCallable();
    }

    public final OperationFuture<Operation, Operation> recreateInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequestResource) {
        RecreateInstancesInstanceGroupManagerRequest request = RecreateInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersRecreateInstancesRequestResource(instanceGroupManagersRecreateInstancesRequestResource).build();
        return this.recreateInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> recreateInstancesAsync(RecreateInstancesInstanceGroupManagerRequest request) {
        return this.recreateInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RecreateInstancesInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationCallable() {
        return this.stub.recreateInstancesOperationCallable();
    }

    public final UnaryCallable<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesCallable() {
        return this.stub.recreateInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> resizeAsync(String project, String zone, String instanceGroupManager, int size) {
        ResizeInstanceGroupManagerRequest request = ResizeInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setSize(size).build();
        return this.resizeAsync(request);
    }

    public final OperationFuture<Operation, Operation> resizeAsync(ResizeInstanceGroupManagerRequest request) {
        return this.resizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResizeInstanceGroupManagerRequest, Operation, Operation> resizeOperationCallable() {
        return this.stub.resizeOperationCallable();
    }

    public final UnaryCallable<ResizeInstanceGroupManagerRequest, Operation> resizeCallable() {
        return this.stub.resizeCallable();
    }

    public final OperationFuture<Operation, Operation> resumeInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersResumeInstancesRequest instanceGroupManagersResumeInstancesRequestResource) {
        ResumeInstancesInstanceGroupManagerRequest request = ResumeInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersResumeInstancesRequestResource(instanceGroupManagersResumeInstancesRequestResource).build();
        return this.resumeInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> resumeInstancesAsync(ResumeInstancesInstanceGroupManagerRequest request) {
        return this.resumeInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeInstancesInstanceGroupManagerRequest, Operation, Operation> resumeInstancesOperationCallable() {
        return this.stub.resumeInstancesOperationCallable();
    }

    public final UnaryCallable<ResumeInstancesInstanceGroupManagerRequest, Operation> resumeInstancesCallable() {
        return this.stub.resumeInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> setInstanceTemplateAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequestResource) {
        SetInstanceTemplateInstanceGroupManagerRequest request = SetInstanceTemplateInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetInstanceTemplateRequestResource(instanceGroupManagersSetInstanceTemplateRequestResource).build();
        return this.setInstanceTemplateAsync(request);
    }

    public final OperationFuture<Operation, Operation> setInstanceTemplateAsync(SetInstanceTemplateInstanceGroupManagerRequest request) {
        return this.setInstanceTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetInstanceTemplateInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationCallable() {
        return this.stub.setInstanceTemplateOperationCallable();
    }

    public final UnaryCallable<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateCallable() {
        return this.stub.setInstanceTemplateCallable();
    }

    public final OperationFuture<Operation, Operation> setTargetPoolsAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequestResource) {
        SetTargetPoolsInstanceGroupManagerRequest request = SetTargetPoolsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetTargetPoolsRequestResource(instanceGroupManagersSetTargetPoolsRequestResource).build();
        return this.setTargetPoolsAsync(request);
    }

    public final OperationFuture<Operation, Operation> setTargetPoolsAsync(SetTargetPoolsInstanceGroupManagerRequest request) {
        return this.setTargetPoolsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetTargetPoolsInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationCallable() {
        return this.stub.setTargetPoolsOperationCallable();
    }

    public final UnaryCallable<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsCallable() {
        return this.stub.setTargetPoolsCallable();
    }

    public final OperationFuture<Operation, Operation> startInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersStartInstancesRequest instanceGroupManagersStartInstancesRequestResource) {
        StartInstancesInstanceGroupManagerRequest request = StartInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersStartInstancesRequestResource(instanceGroupManagersStartInstancesRequestResource).build();
        return this.startInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> startInstancesAsync(StartInstancesInstanceGroupManagerRequest request) {
        return this.startInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartInstancesInstanceGroupManagerRequest, Operation, Operation> startInstancesOperationCallable() {
        return this.stub.startInstancesOperationCallable();
    }

    public final UnaryCallable<StartInstancesInstanceGroupManagerRequest, Operation> startInstancesCallable() {
        return this.stub.startInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> stopInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersStopInstancesRequest instanceGroupManagersStopInstancesRequestResource) {
        StopInstancesInstanceGroupManagerRequest request = StopInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersStopInstancesRequestResource(instanceGroupManagersStopInstancesRequestResource).build();
        return this.stopInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> stopInstancesAsync(StopInstancesInstanceGroupManagerRequest request) {
        return this.stopInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopInstancesInstanceGroupManagerRequest, Operation, Operation> stopInstancesOperationCallable() {
        return this.stub.stopInstancesOperationCallable();
    }

    public final UnaryCallable<StopInstancesInstanceGroupManagerRequest, Operation> stopInstancesCallable() {
        return this.stub.stopInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> suspendInstancesAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersSuspendInstancesRequest instanceGroupManagersSuspendInstancesRequestResource) {
        SuspendInstancesInstanceGroupManagerRequest request = SuspendInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSuspendInstancesRequestResource(instanceGroupManagersSuspendInstancesRequestResource).build();
        return this.suspendInstancesAsync(request);
    }

    public final OperationFuture<Operation, Operation> suspendInstancesAsync(SuspendInstancesInstanceGroupManagerRequest request) {
        return this.suspendInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SuspendInstancesInstanceGroupManagerRequest, Operation, Operation> suspendInstancesOperationCallable() {
        return this.stub.suspendInstancesOperationCallable();
    }

    public final UnaryCallable<SuspendInstancesInstanceGroupManagerRequest, Operation> suspendInstancesCallable() {
        return this.stub.suspendInstancesCallable();
    }

    public final OperationFuture<Operation, Operation> updatePerInstanceConfigsAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagersUpdatePerInstanceConfigsReq instanceGroupManagersUpdatePerInstanceConfigsReqResource) {
        UpdatePerInstanceConfigsInstanceGroupManagerRequest request = UpdatePerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersUpdatePerInstanceConfigsReqResource(instanceGroupManagersUpdatePerInstanceConfigsReqResource).build();
        return this.updatePerInstanceConfigsAsync(request);
    }

    public final OperationFuture<Operation, Operation> updatePerInstanceConfigsAsync(UpdatePerInstanceConfigsInstanceGroupManagerRequest request) {
        return this.updatePerInstanceConfigsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationCallable() {
        return this.stub.updatePerInstanceConfigsOperationCallable();
    }

    public final UnaryCallable<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsCallable() {
        return this.stub.updatePerInstanceConfigsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPerInstanceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage, ListPerInstanceConfigsFixedSizeCollection> {
        private ListPerInstanceConfigsFixedSizeCollection(List<ListPerInstanceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPerInstanceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListPerInstanceConfigsFixedSizeCollection(null, 0);
        }

        protected ListPerInstanceConfigsFixedSizeCollection createCollection(List<ListPerInstanceConfigsPage> pages, int collectionSize) {
            return new ListPerInstanceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPerInstanceConfigsPage
    extends AbstractPage<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage> {
        private ListPerInstanceConfigsPage(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, InstanceGroupManagersListPerInstanceConfigsResp response) {
            super(context, (Object)response);
        }

        private static ListPerInstanceConfigsPage createEmptyPage() {
            return new ListPerInstanceConfigsPage(null, null);
        }

        protected ListPerInstanceConfigsPage createPage(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, InstanceGroupManagersListPerInstanceConfigsResp response) {
            return new ListPerInstanceConfigsPage(context, response);
        }

        public ApiFuture<ListPerInstanceConfigsPage> createPageAsync(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, ApiFuture<InstanceGroupManagersListPerInstanceConfigsResp> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPerInstanceConfigsPagedResponse
    extends AbstractPagedListResponse<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage, ListPerInstanceConfigsFixedSizeCollection> {
        public static ApiFuture<ListPerInstanceConfigsPagedResponse> createAsync(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, ApiFuture<InstanceGroupManagersListPerInstanceConfigsResp> futureResponse) {
            ApiFuture<ListPerInstanceConfigsPage> futurePage = ListPerInstanceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPerInstanceConfigsPagedResponse((ListPerInstanceConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPerInstanceConfigsPagedResponse(ListPerInstanceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPerInstanceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagedInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage, ListManagedInstancesFixedSizeCollection> {
        private ListManagedInstancesFixedSizeCollection(List<ListManagedInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagedInstancesFixedSizeCollection createEmptyCollection() {
            return new ListManagedInstancesFixedSizeCollection(null, 0);
        }

        protected ListManagedInstancesFixedSizeCollection createCollection(List<ListManagedInstancesPage> pages, int collectionSize) {
            return new ListManagedInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagedInstancesPage
    extends AbstractPage<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage> {
        private ListManagedInstancesPage(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, InstanceGroupManagersListManagedInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListManagedInstancesPage createEmptyPage() {
            return new ListManagedInstancesPage(null, null);
        }

        protected ListManagedInstancesPage createPage(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, InstanceGroupManagersListManagedInstancesResponse response) {
            return new ListManagedInstancesPage(context, response);
        }

        public ApiFuture<ListManagedInstancesPage> createPageAsync(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, ApiFuture<InstanceGroupManagersListManagedInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagedInstancesPagedResponse
    extends AbstractPagedListResponse<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage, ListManagedInstancesFixedSizeCollection> {
        public static ApiFuture<ListManagedInstancesPagedResponse> createAsync(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, ApiFuture<InstanceGroupManagersListManagedInstancesResponse> futureResponse) {
            ApiFuture<ListManagedInstancesPage> futurePage = ListManagedInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagedInstancesPagedResponse((ListManagedInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagedInstancesPagedResponse(ListManagedInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagedInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListErrorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage, ListErrorsFixedSizeCollection> {
        private ListErrorsFixedSizeCollection(List<ListErrorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListErrorsFixedSizeCollection createEmptyCollection() {
            return new ListErrorsFixedSizeCollection(null, 0);
        }

        protected ListErrorsFixedSizeCollection createCollection(List<ListErrorsPage> pages, int collectionSize) {
            return new ListErrorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListErrorsPage
    extends AbstractPage<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage> {
        private ListErrorsPage(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, InstanceGroupManagersListErrorsResponse response) {
            super(context, (Object)response);
        }

        private static ListErrorsPage createEmptyPage() {
            return new ListErrorsPage(null, null);
        }

        protected ListErrorsPage createPage(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, InstanceGroupManagersListErrorsResponse response) {
            return new ListErrorsPage(context, response);
        }

        public ApiFuture<ListErrorsPage> createPageAsync(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, ApiFuture<InstanceGroupManagersListErrorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListErrorsPagedResponse
    extends AbstractPagedListResponse<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage, ListErrorsFixedSizeCollection> {
        public static ApiFuture<ListErrorsPagedResponse> createAsync(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, ApiFuture<InstanceGroupManagersListErrorsResponse> futureResponse) {
            ApiFuture<ListErrorsPage> futurePage = ListErrorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListErrorsPagedResponse((ListErrorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListErrorsPagedResponse(ListErrorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListErrorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage> {
        private ListPage(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, InstanceGroupManagerAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, InstanceGroupManagerAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

