/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTypesRequest;
import com.google.cloud.compute.v1.GetNodeTypeRequest;
import com.google.cloud.compute.v1.ListNodeTypesRequest;
import com.google.cloud.compute.v1.NodeType;
import com.google.cloud.compute.v1.NodeTypeAggregatedList;
import com.google.cloud.compute.v1.NodeTypeList;
import com.google.cloud.compute.v1.NodeTypesScopedList;
import com.google.cloud.compute.v1.NodeTypesSettings;
import com.google.cloud.compute.v1.stub.NodeTypesStub;
import com.google.cloud.compute.v1.stub.NodeTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NodeTypesClient
implements BackgroundResource {
    private final NodeTypesSettings settings;
    private final NodeTypesStub stub;

    public static final NodeTypesClient create() throws IOException {
        return NodeTypesClient.create(NodeTypesSettings.newBuilder().build());
    }

    public static final NodeTypesClient create(NodeTypesSettings settings) throws IOException {
        return new NodeTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final NodeTypesClient create(NodeTypesStub stub) {
        return new NodeTypesClient(stub);
    }

    protected NodeTypesClient(NodeTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeTypesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected NodeTypesClient(NodeTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTypesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNodeTypesRequest request = AggregatedListNodeTypesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNodeTypesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNodeTypesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNodeTypesRequest, NodeTypeAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final NodeType get(String project, String zone, String nodeType) {
        GetNodeTypeRequest request = GetNodeTypeRequest.newBuilder().setProject(project).setZone(zone).setNodeType(nodeType).build();
        return this.get(request);
    }

    public final NodeType get(GetNodeTypeRequest request) {
        return (NodeType)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeTypeRequest, NodeType> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListNodeTypesRequest request = ListNodeTypesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNodeTypesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodeTypesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNodeTypesRequest, NodeTypeList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTypesRequest, NodeTypeList, NodeType, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNodeTypesRequest, NodeTypeList, NodeType, ListPage> {
        private ListPage(PageContext<ListNodeTypesRequest, NodeTypeList, NodeType> context, NodeTypeList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNodeTypesRequest, NodeTypeList, NodeType> context, NodeTypeList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNodeTypesRequest, NodeTypeList, NodeType> context, ApiFuture<NodeTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNodeTypesRequest, NodeTypeList, NodeType, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNodeTypesRequest, NodeTypeList, NodeType> context, ApiFuture<NodeTypeList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>> context, NodeTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>> context, NodeTypeAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>> context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>> context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

