/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRegionCommitmentsRequest;
import com.google.cloud.compute.v1.Commitment;
import com.google.cloud.compute.v1.CommitmentAggregatedList;
import com.google.cloud.compute.v1.CommitmentList;
import com.google.cloud.compute.v1.CommitmentsScopedList;
import com.google.cloud.compute.v1.GetRegionCommitmentRequest;
import com.google.cloud.compute.v1.InsertRegionCommitmentRequest;
import com.google.cloud.compute.v1.ListRegionCommitmentsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionCommitmentsSettings;
import com.google.cloud.compute.v1.UpdateRegionCommitmentRequest;
import com.google.cloud.compute.v1.stub.RegionCommitmentsStub;
import com.google.cloud.compute.v1.stub.RegionCommitmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionCommitmentsClient
implements BackgroundResource {
    private final RegionCommitmentsSettings settings;
    private final RegionCommitmentsStub stub;

    public static final RegionCommitmentsClient create() throws IOException {
        return RegionCommitmentsClient.create(RegionCommitmentsSettings.newBuilder().build());
    }

    public static final RegionCommitmentsClient create(RegionCommitmentsSettings settings) throws IOException {
        return new RegionCommitmentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionCommitmentsClient create(RegionCommitmentsStub stub) {
        return new RegionCommitmentsClient(stub);
    }

    protected RegionCommitmentsClient(RegionCommitmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionCommitmentsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionCommitmentsClient(RegionCommitmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionCommitmentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionCommitmentsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListRegionCommitmentsRequest request = AggregatedListRegionCommitmentsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListRegionCommitmentsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListRegionCommitmentsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Commitment get(String project, String region, String commitment) {
        GetRegionCommitmentRequest request = GetRegionCommitmentRequest.newBuilder().setProject(project).setRegion(region).setCommitment(commitment).build();
        return this.get(request);
    }

    public final Commitment get(GetRegionCommitmentRequest request) {
        return (Commitment)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionCommitmentRequest, Commitment> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, Commitment commitmentResource) {
        InsertRegionCommitmentRequest request = InsertRegionCommitmentRequest.newBuilder().setProject(project).setRegion(region).setCommitmentResource(commitmentResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionCommitmentRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionCommitmentRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionCommitmentRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionCommitmentsRequest request = ListRegionCommitmentsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionCommitmentsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionCommitmentsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionCommitmentsRequest, CommitmentList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, String commitment, Commitment commitmentResource) {
        UpdateRegionCommitmentRequest request = UpdateRegionCommitmentRequest.newBuilder().setProject(project).setRegion(region).setCommitment(commitment).setCommitmentResource(commitmentResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateRegionCommitmentRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegionCommitmentRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRegionCommitmentRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionCommitmentsRequest, CommitmentList, Commitment, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionCommitmentsRequest, CommitmentList, Commitment, ListPage> {
        private ListPage(PageContext<ListRegionCommitmentsRequest, CommitmentList, Commitment> context, CommitmentList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionCommitmentsRequest, CommitmentList, Commitment> context, CommitmentList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionCommitmentsRequest, CommitmentList, Commitment> context, ApiFuture<CommitmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionCommitmentsRequest, CommitmentList, Commitment, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionCommitmentsRequest, CommitmentList, Commitment> context, ApiFuture<CommitmentList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>> context, CommitmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>> context, CommitmentAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>> context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>> context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

