/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.DiskMoveRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.GetProjectRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsRequest;
import com.google.cloud.compute.v1.InstanceMoveRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsRequest;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.MoveDiskProjectRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectsDisableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsEnableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.ProjectsListXpnHostsRequest;
import com.google.cloud.compute.v1.ProjectsSetDefaultNetworkTierRequest;
import com.google.cloud.compute.v1.ProjectsSettings;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectRequest;
import com.google.cloud.compute.v1.UsageExportLocation;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.XpnResourceId;
import com.google.cloud.compute.v1.stub.ProjectsStub;
import com.google.cloud.compute.v1.stub.ProjectsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ProjectsClient
implements BackgroundResource {
    private final ProjectsSettings settings;
    private final ProjectsStub stub;

    public static final ProjectsClient create() throws IOException {
        return ProjectsClient.create(ProjectsSettings.newBuilder().build());
    }

    public static final ProjectsClient create(ProjectsSettings settings) throws IOException {
        return new ProjectsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProjectsClient create(ProjectsStub stub) {
        return new ProjectsClient(stub);
    }

    protected ProjectsClient(ProjectsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProjectsClient(ProjectsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProjectsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> disableXpnHostAsync(String project) {
        DisableXpnHostProjectRequest request = DisableXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.disableXpnHostAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> disableXpnHostAsync(DisableXpnHostProjectRequest request) {
        return this.disableXpnHostOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableXpnHostProjectRequest, Operation, Operation> disableXpnHostOperationCallable() {
        return this.stub.disableXpnHostOperationCallable();
    }

    public final UnaryCallable<DisableXpnHostProjectRequest, Operation> disableXpnHostCallable() {
        return this.stub.disableXpnHostCallable();
    }

    public final OperationFuture<Operation, Operation> disableXpnResourceAsync(String project, ProjectsDisableXpnResourceRequest projectsDisableXpnResourceRequestResource) {
        DisableXpnResourceProjectRequest request = DisableXpnResourceProjectRequest.newBuilder().setProject(project).setProjectsDisableXpnResourceRequestResource(projectsDisableXpnResourceRequestResource).build();
        return this.disableXpnResourceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> disableXpnResourceAsync(DisableXpnResourceProjectRequest request) {
        return this.disableXpnResourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableXpnResourceProjectRequest, Operation, Operation> disableXpnResourceOperationCallable() {
        return this.stub.disableXpnResourceOperationCallable();
    }

    public final UnaryCallable<DisableXpnResourceProjectRequest, Operation> disableXpnResourceCallable() {
        return this.stub.disableXpnResourceCallable();
    }

    public final OperationFuture<Operation, Operation> enableXpnHostAsync(String project) {
        EnableXpnHostProjectRequest request = EnableXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.enableXpnHostAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> enableXpnHostAsync(EnableXpnHostProjectRequest request) {
        return this.enableXpnHostOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableXpnHostProjectRequest, Operation, Operation> enableXpnHostOperationCallable() {
        return this.stub.enableXpnHostOperationCallable();
    }

    public final UnaryCallable<EnableXpnHostProjectRequest, Operation> enableXpnHostCallable() {
        return this.stub.enableXpnHostCallable();
    }

    public final OperationFuture<Operation, Operation> enableXpnResourceAsync(String project, ProjectsEnableXpnResourceRequest projectsEnableXpnResourceRequestResource) {
        EnableXpnResourceProjectRequest request = EnableXpnResourceProjectRequest.newBuilder().setProject(project).setProjectsEnableXpnResourceRequestResource(projectsEnableXpnResourceRequestResource).build();
        return this.enableXpnResourceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> enableXpnResourceAsync(EnableXpnResourceProjectRequest request) {
        return this.enableXpnResourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableXpnResourceProjectRequest, Operation, Operation> enableXpnResourceOperationCallable() {
        return this.stub.enableXpnResourceOperationCallable();
    }

    public final UnaryCallable<EnableXpnResourceProjectRequest, Operation> enableXpnResourceCallable() {
        return this.stub.enableXpnResourceCallable();
    }

    public final Project get(String project) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setProject(project).build();
        return this.get(request);
    }

    public final Project get(GetProjectRequest request) {
        return (Project)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectRequest, Project> getCallable() {
        return this.stub.getCallable();
    }

    public final Project getXpnHost(String project) {
        GetXpnHostProjectRequest request = GetXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.getXpnHost(request);
    }

    public final Project getXpnHost(GetXpnHostProjectRequest request) {
        return (Project)this.getXpnHostCallable().call((Object)request);
    }

    public final UnaryCallable<GetXpnHostProjectRequest, Project> getXpnHostCallable() {
        return this.stub.getXpnHostCallable();
    }

    public final GetXpnResourcesPagedResponse getXpnResources(String project) {
        GetXpnResourcesProjectsRequest request = GetXpnResourcesProjectsRequest.newBuilder().setProject(project).build();
        return this.getXpnResources(request);
    }

    public final GetXpnResourcesPagedResponse getXpnResources(GetXpnResourcesProjectsRequest request) {
        return (GetXpnResourcesPagedResponse)((Object)this.getXpnResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GetXpnResourcesProjectsRequest, GetXpnResourcesPagedResponse> getXpnResourcesPagedCallable() {
        return this.stub.getXpnResourcesPagedCallable();
    }

    public final UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> getXpnResourcesCallable() {
        return this.stub.getXpnResourcesCallable();
    }

    public final ListXpnHostsPagedResponse listXpnHosts(String project, ProjectsListXpnHostsRequest projectsListXpnHostsRequestResource) {
        ListXpnHostsProjectsRequest request = ListXpnHostsProjectsRequest.newBuilder().setProject(project).setProjectsListXpnHostsRequestResource(projectsListXpnHostsRequestResource).build();
        return this.listXpnHosts(request);
    }

    public final ListXpnHostsPagedResponse listXpnHosts(ListXpnHostsProjectsRequest request) {
        return (ListXpnHostsPagedResponse)((Object)this.listXpnHostsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListXpnHostsProjectsRequest, ListXpnHostsPagedResponse> listXpnHostsPagedCallable() {
        return this.stub.listXpnHostsPagedCallable();
    }

    public final UnaryCallable<ListXpnHostsProjectsRequest, XpnHostList> listXpnHostsCallable() {
        return this.stub.listXpnHostsCallable();
    }

    public final OperationFuture<Operation, Operation> moveDiskAsync(String project, DiskMoveRequest diskMoveRequestResource) {
        MoveDiskProjectRequest request = MoveDiskProjectRequest.newBuilder().setProject(project).setDiskMoveRequestResource(diskMoveRequestResource).build();
        return this.moveDiskAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> moveDiskAsync(MoveDiskProjectRequest request) {
        return this.moveDiskOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveDiskProjectRequest, Operation, Operation> moveDiskOperationCallable() {
        return this.stub.moveDiskOperationCallable();
    }

    public final UnaryCallable<MoveDiskProjectRequest, Operation> moveDiskCallable() {
        return this.stub.moveDiskCallable();
    }

    public final OperationFuture<Operation, Operation> moveInstanceAsync(String project, InstanceMoveRequest instanceMoveRequestResource) {
        MoveInstanceProjectRequest request = MoveInstanceProjectRequest.newBuilder().setProject(project).setInstanceMoveRequestResource(instanceMoveRequestResource).build();
        return this.moveInstanceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> moveInstanceAsync(MoveInstanceProjectRequest request) {
        return this.moveInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveInstanceProjectRequest, Operation, Operation> moveInstanceOperationCallable() {
        return this.stub.moveInstanceOperationCallable();
    }

    public final UnaryCallable<MoveInstanceProjectRequest, Operation> moveInstanceCallable() {
        return this.stub.moveInstanceCallable();
    }

    public final OperationFuture<Operation, Operation> setCommonInstanceMetadataAsync(String project, Metadata metadataResource) {
        SetCommonInstanceMetadataProjectRequest request = SetCommonInstanceMetadataProjectRequest.newBuilder().setProject(project).setMetadataResource(metadataResource).build();
        return this.setCommonInstanceMetadataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setCommonInstanceMetadataAsync(SetCommonInstanceMetadataProjectRequest request) {
        return this.setCommonInstanceMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetCommonInstanceMetadataProjectRequest, Operation, Operation> setCommonInstanceMetadataOperationCallable() {
        return this.stub.setCommonInstanceMetadataOperationCallable();
    }

    public final UnaryCallable<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataCallable() {
        return this.stub.setCommonInstanceMetadataCallable();
    }

    public final OperationFuture<Operation, Operation> setDefaultNetworkTierAsync(String project, ProjectsSetDefaultNetworkTierRequest projectsSetDefaultNetworkTierRequestResource) {
        SetDefaultNetworkTierProjectRequest request = SetDefaultNetworkTierProjectRequest.newBuilder().setProject(project).setProjectsSetDefaultNetworkTierRequestResource(projectsSetDefaultNetworkTierRequestResource).build();
        return this.setDefaultNetworkTierAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setDefaultNetworkTierAsync(SetDefaultNetworkTierProjectRequest request) {
        return this.setDefaultNetworkTierOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetDefaultNetworkTierProjectRequest, Operation, Operation> setDefaultNetworkTierOperationCallable() {
        return this.stub.setDefaultNetworkTierOperationCallable();
    }

    public final UnaryCallable<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierCallable() {
        return this.stub.setDefaultNetworkTierCallable();
    }

    public final OperationFuture<Operation, Operation> setUsageExportBucketAsync(String project, UsageExportLocation usageExportLocationResource) {
        SetUsageExportBucketProjectRequest request = SetUsageExportBucketProjectRequest.newBuilder().setProject(project).setUsageExportLocationResource(usageExportLocationResource).build();
        return this.setUsageExportBucketAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setUsageExportBucketAsync(SetUsageExportBucketProjectRequest request) {
        return this.setUsageExportBucketOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetUsageExportBucketProjectRequest, Operation, Operation> setUsageExportBucketOperationCallable() {
        return this.stub.setUsageExportBucketOperationCallable();
    }

    public final UnaryCallable<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketCallable() {
        return this.stub.setUsageExportBucketCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListXpnHostsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage, ListXpnHostsFixedSizeCollection> {
        private ListXpnHostsFixedSizeCollection(List<ListXpnHostsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListXpnHostsFixedSizeCollection createEmptyCollection() {
            return new ListXpnHostsFixedSizeCollection(null, 0);
        }

        protected ListXpnHostsFixedSizeCollection createCollection(List<ListXpnHostsPage> pages, int collectionSize) {
            return new ListXpnHostsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListXpnHostsPage
    extends AbstractPage<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage> {
        private ListXpnHostsPage(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, XpnHostList response) {
            super(context, (Object)response);
        }

        private static ListXpnHostsPage createEmptyPage() {
            return new ListXpnHostsPage(null, null);
        }

        protected ListXpnHostsPage createPage(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, XpnHostList response) {
            return new ListXpnHostsPage(context, response);
        }

        public ApiFuture<ListXpnHostsPage> createPageAsync(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListXpnHostsPagedResponse
    extends AbstractPagedListResponse<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage, ListXpnHostsFixedSizeCollection> {
        public static ApiFuture<ListXpnHostsPagedResponse> createAsync(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            ApiFuture<ListXpnHostsPage> futurePage = ListXpnHostsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListXpnHostsPagedResponse((ListXpnHostsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListXpnHostsPagedResponse(ListXpnHostsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListXpnHostsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetXpnResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage, GetXpnResourcesFixedSizeCollection> {
        private GetXpnResourcesFixedSizeCollection(List<GetXpnResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetXpnResourcesFixedSizeCollection createEmptyCollection() {
            return new GetXpnResourcesFixedSizeCollection(null, 0);
        }

        protected GetXpnResourcesFixedSizeCollection createCollection(List<GetXpnResourcesPage> pages, int collectionSize) {
            return new GetXpnResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetXpnResourcesPage
    extends AbstractPage<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage> {
        private GetXpnResourcesPage(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            super(context, (Object)response);
        }

        private static GetXpnResourcesPage createEmptyPage() {
            return new GetXpnResourcesPage(null, null);
        }

        protected GetXpnResourcesPage createPage(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            return new GetXpnResourcesPage(context, response);
        }

        public ApiFuture<GetXpnResourcesPage> createPageAsync(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetXpnResourcesPagedResponse
    extends AbstractPagedListResponse<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage, GetXpnResourcesFixedSizeCollection> {
        public static ApiFuture<GetXpnResourcesPagedResponse> createAsync(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            ApiFuture<GetXpnResourcesPage> futurePage = GetXpnResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new GetXpnResourcesPagedResponse((GetXpnResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private GetXpnResourcesPagedResponse(GetXpnResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetXpnResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

