/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListMachineTypesRequest;
import com.google.cloud.compute.v1.GetMachineTypeRequest;
import com.google.cloud.compute.v1.ListMachineTypesRequest;
import com.google.cloud.compute.v1.MachineType;
import com.google.cloud.compute.v1.MachineTypeAggregatedList;
import com.google.cloud.compute.v1.MachineTypeList;
import com.google.cloud.compute.v1.MachineTypesScopedList;
import com.google.cloud.compute.v1.MachineTypesSettings;
import com.google.cloud.compute.v1.stub.MachineTypesStub;
import com.google.cloud.compute.v1.stub.MachineTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MachineTypesClient
implements BackgroundResource {
    private final MachineTypesSettings settings;
    private final MachineTypesStub stub;

    public static final MachineTypesClient create() throws IOException {
        return MachineTypesClient.create(MachineTypesSettings.newBuilder().build());
    }

    public static final MachineTypesClient create(MachineTypesSettings settings) throws IOException {
        return new MachineTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MachineTypesClient create(MachineTypesStub stub) {
        return new MachineTypesClient(stub);
    }

    protected MachineTypesClient(MachineTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MachineTypesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MachineTypesClient(MachineTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MachineTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MachineTypesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListMachineTypesRequest request = AggregatedListMachineTypesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListMachineTypesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListMachineTypesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListMachineTypesRequest, MachineTypeAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final MachineType get(String project, String zone, String machineType) {
        GetMachineTypeRequest request = GetMachineTypeRequest.newBuilder().setProject(project).setZone(zone).setMachineType(machineType).build();
        return this.get(request);
    }

    public final MachineType get(GetMachineTypeRequest request) {
        return (MachineType)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetMachineTypeRequest, MachineType> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListMachineTypesRequest request = ListMachineTypesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListMachineTypesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMachineTypesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListMachineTypesRequest, MachineTypeList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMachineTypesRequest, MachineTypeList, MachineType, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListMachineTypesRequest, MachineTypeList, MachineType, ListPage> {
        private ListPage(PageContext<ListMachineTypesRequest, MachineTypeList, MachineType> context, MachineTypeList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListMachineTypesRequest, MachineTypeList, MachineType> context, MachineTypeList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListMachineTypesRequest, MachineTypeList, MachineType> context, ApiFuture<MachineTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListMachineTypesRequest, MachineTypeList, MachineType, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListMachineTypesRequest, MachineTypeList, MachineType> context, ApiFuture<MachineTypeList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>> context, MachineTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>> context, MachineTypeAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>> context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>> context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

