/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectRequest;
import com.google.cloud.compute.v1.GetDiagnosticsInterconnectRequest;
import com.google.cloud.compute.v1.GetInterconnectRequest;
import com.google.cloud.compute.v1.InsertInterconnectRequest;
import com.google.cloud.compute.v1.Interconnect;
import com.google.cloud.compute.v1.InterconnectList;
import com.google.cloud.compute.v1.InterconnectsGetDiagnosticsResponse;
import com.google.cloud.compute.v1.InterconnectsSettings;
import com.google.cloud.compute.v1.ListInterconnectsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectRequest;
import com.google.cloud.compute.v1.stub.InterconnectsStub;
import com.google.cloud.compute.v1.stub.InterconnectsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectsClient
implements BackgroundResource {
    private final InterconnectsSettings settings;
    private final InterconnectsStub stub;

    public static final InterconnectsClient create() throws IOException {
        return InterconnectsClient.create(InterconnectsSettings.newBuilder().build());
    }

    public static final InterconnectsClient create(InterconnectsSettings settings) throws IOException {
        return new InterconnectsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InterconnectsClient create(InterconnectsStub stub) {
        return new InterconnectsClient(stub);
    }

    protected InterconnectsClient(InterconnectsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InterconnectsClient(InterconnectsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String interconnect) {
        DeleteInterconnectRequest request = DeleteInterconnectRequest.newBuilder().setProject(project).setInterconnect(interconnect).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInterconnectRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInterconnectRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInterconnectRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Interconnect get(String project, String interconnect) {
        GetInterconnectRequest request = GetInterconnectRequest.newBuilder().setProject(project).setInterconnect(interconnect).build();
        return this.get(request);
    }

    public final Interconnect get(GetInterconnectRequest request) {
        return (Interconnect)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectRequest, Interconnect> getCallable() {
        return this.stub.getCallable();
    }

    public final InterconnectsGetDiagnosticsResponse getDiagnostics(String project, String interconnect) {
        GetDiagnosticsInterconnectRequest request = GetDiagnosticsInterconnectRequest.newBuilder().setProject(project).setInterconnect(interconnect).build();
        return this.getDiagnostics(request);
    }

    public final InterconnectsGetDiagnosticsResponse getDiagnostics(GetDiagnosticsInterconnectRequest request) {
        return (InterconnectsGetDiagnosticsResponse)this.getDiagnosticsCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiagnosticsInterconnectRequest, InterconnectsGetDiagnosticsResponse> getDiagnosticsCallable() {
        return this.stub.getDiagnosticsCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, Interconnect interconnectResource) {
        InsertInterconnectRequest request = InsertInterconnectRequest.newBuilder().setProject(project).setInterconnectResource(interconnectResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertInterconnectRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInterconnectRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInterconnectRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInterconnectsRequest request = ListInterconnectsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectsRequest, InterconnectList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String interconnect, Interconnect interconnectResource) {
        PatchInterconnectRequest request = PatchInterconnectRequest.newBuilder().setProject(project).setInterconnect(interconnect).setInterconnectResource(interconnectResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchInterconnectRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInterconnectRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInterconnectRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectsRequest, InterconnectList, Interconnect, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectsRequest, InterconnectList, Interconnect, ListPage> {
        private ListPage(PageContext<ListInterconnectsRequest, InterconnectList, Interconnect> context, InterconnectList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectsRequest, InterconnectList, Interconnect> context, InterconnectList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectsRequest, InterconnectList, Interconnect> context, ApiFuture<InterconnectList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectsRequest, InterconnectList, Interconnect, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectsRequest, InterconnectList, Interconnect> context, ApiFuture<InterconnectList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

