/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetReservationBlockRequest;
import com.google.cloud.compute.v1.ListReservationBlocksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PerformMaintenanceReservationBlockRequest;
import com.google.cloud.compute.v1.ReservationBlock;
import com.google.cloud.compute.v1.ReservationBlocksClient;
import com.google.cloud.compute.v1.ReservationBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationBlocksListResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationBlocksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReservationBlocksStubSettings
extends StubSettings<ReservationBlocksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetReservationBlockRequest, ReservationBlocksGetResponse> getSettings;
    private final PagedCallSettings<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PerformMaintenanceReservationBlockRequest, Operation> performMaintenanceSettings;
    private final OperationCallSettings<PerformMaintenanceReservationBlockRequest, Operation, Operation> performMaintenanceOperationSettings;
    private static final PagedListDescriptor<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationBlocksRequest injectToken(ListReservationBlocksRequest payload, String token) {
            return ListReservationBlocksRequest.newBuilder((ListReservationBlocksRequest)payload).setPageToken(token).build();
        }

        public ListReservationBlocksRequest injectPageSize(ListReservationBlocksRequest payload, int pageSize) {
            return ListReservationBlocksRequest.newBuilder((ListReservationBlocksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReservationBlocksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ReservationBlocksListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReservationBlock> extractResources(ReservationBlocksListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse>(){

        public ApiFuture<ReservationBlocksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationBlocksRequest, ReservationBlocksListResponse> callable, ListReservationBlocksRequest request, ApiCallContext context, ApiFuture<ReservationBlocksListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationBlocksClient.ListPagedResponse.createAsync((PageContext<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlock>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetReservationBlockRequest, ReservationBlocksGetResponse> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PerformMaintenanceReservationBlockRequest, Operation> performMaintenanceSettings() {
        return this.performMaintenanceSettings;
    }

    public OperationCallSettings<PerformMaintenanceReservationBlockRequest, Operation, Operation> performMaintenanceOperationSettings() {
        return this.performMaintenanceOperationSettings;
    }

    public ReservationBlocksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReservationBlocksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReservationBlocksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationBlocksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReservationBlocksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.performMaintenanceSettings = settingsBuilder.performMaintenanceSettings().build();
        this.performMaintenanceOperationSettings = settingsBuilder.performMaintenanceOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReservationBlocksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetReservationBlockRequest, ReservationBlocksGetResponse> getSettings;
        private final PagedCallSettings.Builder<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PerformMaintenanceReservationBlockRequest, Operation> performMaintenanceSettings;
        private final OperationCallSettings.Builder<PerformMaintenanceReservationBlockRequest, Operation, Operation> performMaintenanceOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.performMaintenanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.performMaintenanceOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings, this.performMaintenanceSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReservationBlocksStubSettings settings) {
            super((StubSettings)settings);
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.performMaintenanceSettings = settings.performMaintenanceSettings.toBuilder();
            this.performMaintenanceOperationSettings = settings.performMaintenanceOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings, this.performMaintenanceSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReservationBlocksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReservationBlocksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationBlocksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReservationBlocksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.performMaintenanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.performMaintenanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetReservationBlockRequest, ReservationBlocksGetResponse> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListReservationBlocksRequest, ReservationBlocksListResponse, ReservationBlocksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PerformMaintenanceReservationBlockRequest, Operation> performMaintenanceSettings() {
            return this.performMaintenanceSettings;
        }

        public OperationCallSettings.Builder<PerformMaintenanceReservationBlockRequest, Operation, Operation> performMaintenanceOperationSettings() {
            return this.performMaintenanceOperationSettings;
        }

        public ReservationBlocksStubSettings build() throws IOException {
            return new ReservationBlocksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

