/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListMachineTypesRequest;
import com.google.cloud.compute.v1.GetMachineTypeRequest;
import com.google.cloud.compute.v1.ListMachineTypesRequest;
import com.google.cloud.compute.v1.MachineType;
import com.google.cloud.compute.v1.MachineTypeAggregatedList;
import com.google.cloud.compute.v1.MachineTypeList;
import com.google.cloud.compute.v1.MachineTypesClient;
import com.google.cloud.compute.v1.MachineTypesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonMachineTypesStub;
import com.google.cloud.compute.v1.stub.MachineTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MachineTypesStubSettings
extends StubSettings<MachineTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetMachineTypeRequest, MachineType> getSettings;
    private final PagedCallSettings<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListMachineTypesRequest injectToken(AggregatedListMachineTypesRequest payload, String token) {
            return AggregatedListMachineTypesRequest.newBuilder((AggregatedListMachineTypesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListMachineTypesRequest injectPageSize(AggregatedListMachineTypesRequest payload, int pageSize) {
            return AggregatedListMachineTypesRequest.newBuilder((AggregatedListMachineTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListMachineTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(MachineTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, MachineTypesScopedList>> extractResources(MachineTypeAggregatedList payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListMachineTypesRequest, MachineTypeList, MachineType> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListMachineTypesRequest, MachineTypeList, MachineType>(){

        public String emptyToken() {
            return "";
        }

        public ListMachineTypesRequest injectToken(ListMachineTypesRequest payload, String token) {
            return ListMachineTypesRequest.newBuilder((ListMachineTypesRequest)payload).setPageToken(token).build();
        }

        public ListMachineTypesRequest injectPageSize(ListMachineTypesRequest payload, int pageSize) {
            return ListMachineTypesRequest.newBuilder((ListMachineTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListMachineTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(MachineTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MachineType> extractResources(MachineTypeList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse>(){

        public ApiFuture<MachineTypesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListMachineTypesRequest, MachineTypeAggregatedList> callable, AggregatedListMachineTypesRequest request, ApiCallContext context, ApiFuture<MachineTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MachineTypesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, Map.Entry<String, MachineTypesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse>(){

        public ApiFuture<MachineTypesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListMachineTypesRequest, MachineTypeList> callable, ListMachineTypesRequest request, ApiCallContext context, ApiFuture<MachineTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MachineTypesClient.ListPagedResponse.createAsync((PageContext<ListMachineTypesRequest, MachineTypeList, MachineType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetMachineTypeRequest, MachineType> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public MachineTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMachineTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MachineTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MachineTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MachineTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MachineTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetMachineTypeRequest, MachineType> getSettings;
        private final PagedCallSettings.Builder<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MachineTypesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MachineTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MachineTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MachineTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MachineTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListMachineTypesRequest, MachineTypeAggregatedList, MachineTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetMachineTypeRequest, MachineType> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListMachineTypesRequest, MachineTypeList, MachineTypesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public MachineTypesStubSettings build() throws IOException {
            return new MachineTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

