/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRoutersRequest;
import com.google.cloud.compute.v1.BgpRoute;
import com.google.cloud.compute.v1.DeleteRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.DeleteRouterRequest;
import com.google.cloud.compute.v1.GetNatIpInfoRouterRequest;
import com.google.cloud.compute.v1.GetNatMappingInfoRoutersRequest;
import com.google.cloud.compute.v1.GetRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.GetRouterRequest;
import com.google.cloud.compute.v1.GetRouterStatusRouterRequest;
import com.google.cloud.compute.v1.InsertRouterRequest;
import com.google.cloud.compute.v1.ListBgpRoutesRoutersRequest;
import com.google.cloud.compute.v1.ListRoutePoliciesRoutersRequest;
import com.google.cloud.compute.v1.ListRoutersRequest;
import com.google.cloud.compute.v1.NatIpInfoResponse;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.PatchRouterRequest;
import com.google.cloud.compute.v1.PreviewRouterRequest;
import com.google.cloud.compute.v1.RoutePolicy;
import com.google.cloud.compute.v1.Router;
import com.google.cloud.compute.v1.RouterAggregatedList;
import com.google.cloud.compute.v1.RouterList;
import com.google.cloud.compute.v1.RouterStatusResponse;
import com.google.cloud.compute.v1.RoutersGetRoutePolicyResponse;
import com.google.cloud.compute.v1.RoutersListBgpRoutes;
import com.google.cloud.compute.v1.RoutersListRoutePolicies;
import com.google.cloud.compute.v1.RoutersPreviewResponse;
import com.google.cloud.compute.v1.RoutersScopedList;
import com.google.cloud.compute.v1.RoutersSettings;
import com.google.cloud.compute.v1.UpdateRoutePolicyRouterRequest;
import com.google.cloud.compute.v1.UpdateRouterRequest;
import com.google.cloud.compute.v1.VmEndpointNatMappings;
import com.google.cloud.compute.v1.VmEndpointNatMappingsList;
import com.google.cloud.compute.v1.stub.RoutersStub;
import com.google.cloud.compute.v1.stub.RoutersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RoutersClient
implements BackgroundResource {
    private final RoutersSettings settings;
    private final RoutersStub stub;

    public static final RoutersClient create() throws IOException {
        return RoutersClient.create(RoutersSettings.newBuilder().build());
    }

    public static final RoutersClient create(RoutersSettings settings) throws IOException {
        return new RoutersClient(settings);
    }

    public static final RoutersClient create(RoutersStub stub) {
        return new RoutersClient(stub);
    }

    protected RoutersClient(RoutersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoutersStubSettings)settings.getStubSettings()).createStub();
    }

    protected RoutersClient(RoutersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoutersSettings getSettings() {
        return this.settings;
    }

    public RoutersStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListRoutersRequest request = AggregatedListRoutersRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListRoutersRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListRoutersRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListRoutersRequest, RouterAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String router) {
        DeleteRouterRequest request = DeleteRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRouterRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRouterRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRouterRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> deleteRoutePolicyAsync(String project, String region, String router) {
        DeleteRoutePolicyRouterRequest request = DeleteRoutePolicyRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.deleteRoutePolicyAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteRoutePolicyAsync(DeleteRoutePolicyRouterRequest request) {
        return this.deleteRoutePolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRoutePolicyRouterRequest, Operation, Operation> deleteRoutePolicyOperationCallable() {
        return this.stub.deleteRoutePolicyOperationCallable();
    }

    public final UnaryCallable<DeleteRoutePolicyRouterRequest, Operation> deleteRoutePolicyCallable() {
        return this.stub.deleteRoutePolicyCallable();
    }

    public final Router get(String project, String region, String router) {
        GetRouterRequest request = GetRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.get(request);
    }

    public final Router get(GetRouterRequest request) {
        return (Router)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouterRequest, Router> getCallable() {
        return this.stub.getCallable();
    }

    public final NatIpInfoResponse getNatIpInfo(String project, String region, String router) {
        GetNatIpInfoRouterRequest request = GetNatIpInfoRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getNatIpInfo(request);
    }

    public final NatIpInfoResponse getNatIpInfo(GetNatIpInfoRouterRequest request) {
        return (NatIpInfoResponse)this.getNatIpInfoCallable().call((Object)request);
    }

    public final UnaryCallable<GetNatIpInfoRouterRequest, NatIpInfoResponse> getNatIpInfoCallable() {
        return this.stub.getNatIpInfoCallable();
    }

    public final GetNatMappingInfoPagedResponse getNatMappingInfo(String project, String region, String router) {
        GetNatMappingInfoRoutersRequest request = GetNatMappingInfoRoutersRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getNatMappingInfo(request);
    }

    public final GetNatMappingInfoPagedResponse getNatMappingInfo(GetNatMappingInfoRoutersRequest request) {
        return (GetNatMappingInfoPagedResponse)((Object)this.getNatMappingInfoPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GetNatMappingInfoRoutersRequest, GetNatMappingInfoPagedResponse> getNatMappingInfoPagedCallable() {
        return this.stub.getNatMappingInfoPagedCallable();
    }

    public final UnaryCallable<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList> getNatMappingInfoCallable() {
        return this.stub.getNatMappingInfoCallable();
    }

    public final RoutersGetRoutePolicyResponse getRoutePolicy(String project, String region, String router) {
        GetRoutePolicyRouterRequest request = GetRoutePolicyRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getRoutePolicy(request);
    }

    public final RoutersGetRoutePolicyResponse getRoutePolicy(GetRoutePolicyRouterRequest request) {
        return (RoutersGetRoutePolicyResponse)this.getRoutePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetRoutePolicyRouterRequest, RoutersGetRoutePolicyResponse> getRoutePolicyCallable() {
        return this.stub.getRoutePolicyCallable();
    }

    public final RouterStatusResponse getRouterStatus(String project, String region, String router) {
        GetRouterStatusRouterRequest request = GetRouterStatusRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.getRouterStatus(request);
    }

    public final RouterStatusResponse getRouterStatus(GetRouterStatusRouterRequest request) {
        return (RouterStatusResponse)this.getRouterStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouterStatusRouterRequest, RouterStatusResponse> getRouterStatusCallable() {
        return this.stub.getRouterStatusCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, Router routerResource) {
        InsertRouterRequest request = InsertRouterRequest.newBuilder().setProject(project).setRegion(region).setRouterResource(routerResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRouterRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRouterRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRouterRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRoutersRequest request = ListRoutersRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRoutersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRoutersRequest, RouterList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListBgpRoutesPagedResponse listBgpRoutes(String project, String region, String router) {
        ListBgpRoutesRoutersRequest request = ListBgpRoutesRoutersRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.listBgpRoutes(request);
    }

    public final ListBgpRoutesPagedResponse listBgpRoutes(ListBgpRoutesRoutersRequest request) {
        return (ListBgpRoutesPagedResponse)((Object)this.listBgpRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBgpRoutesRoutersRequest, ListBgpRoutesPagedResponse> listBgpRoutesPagedCallable() {
        return this.stub.listBgpRoutesPagedCallable();
    }

    public final UnaryCallable<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes> listBgpRoutesCallable() {
        return this.stub.listBgpRoutesCallable();
    }

    public final ListRoutePoliciesPagedResponse listRoutePolicies(String project, String region, String router) {
        ListRoutePoliciesRoutersRequest request = ListRoutePoliciesRoutersRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).build();
        return this.listRoutePolicies(request);
    }

    public final ListRoutePoliciesPagedResponse listRoutePolicies(ListRoutePoliciesRoutersRequest request) {
        return (ListRoutePoliciesPagedResponse)((Object)this.listRoutePoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutePoliciesRoutersRequest, ListRoutePoliciesPagedResponse> listRoutePoliciesPagedCallable() {
        return this.stub.listRoutePoliciesPagedCallable();
    }

    public final UnaryCallable<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies> listRoutePoliciesCallable() {
        return this.stub.listRoutePoliciesCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String router, Router routerResource) {
        PatchRouterRequest request = PatchRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchRouterRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRouterRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRouterRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRoutePolicyAsync(String project, String region, String router, RoutePolicy routePolicyResource) {
        PatchRoutePolicyRouterRequest request = PatchRoutePolicyRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRoutePolicyResource(routePolicyResource).build();
        return this.patchRoutePolicyAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRoutePolicyAsync(PatchRoutePolicyRouterRequest request) {
        return this.patchRoutePolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRoutePolicyRouterRequest, Operation, Operation> patchRoutePolicyOperationCallable() {
        return this.stub.patchRoutePolicyOperationCallable();
    }

    public final UnaryCallable<PatchRoutePolicyRouterRequest, Operation> patchRoutePolicyCallable() {
        return this.stub.patchRoutePolicyCallable();
    }

    public final RoutersPreviewResponse preview(String project, String region, String router, Router routerResource) {
        PreviewRouterRequest request = PreviewRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.preview(request);
    }

    public final RoutersPreviewResponse preview(PreviewRouterRequest request) {
        return (RoutersPreviewResponse)this.previewCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewRouterRequest, RoutersPreviewResponse> previewCallable() {
        return this.stub.previewCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, String router, Router routerResource) {
        UpdateRouterRequest request = UpdateRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRouterResource(routerResource).build();
        return this.updateAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateAsync(UpdateRouterRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRouterRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRouterRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final OperationFuture<Operation, Operation> updateRoutePolicyAsync(String project, String region, String router, RoutePolicy routePolicyResource) {
        UpdateRoutePolicyRouterRequest request = UpdateRoutePolicyRouterRequest.newBuilder().setProject(project).setRegion(region).setRouter(router).setRoutePolicyResource(routePolicyResource).build();
        return this.updateRoutePolicyAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateRoutePolicyAsync(UpdateRoutePolicyRouterRequest request) {
        return this.updateRoutePolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRoutePolicyRouterRequest, Operation, Operation> updateRoutePolicyOperationCallable() {
        return this.stub.updateRoutePolicyOperationCallable();
    }

    public final UnaryCallable<UpdateRoutePolicyRouterRequest, Operation> updateRoutePolicyCallable() {
        return this.stub.updateRoutePolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRoutePoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy, ListRoutePoliciesPage, ListRoutePoliciesFixedSizeCollection> {
        private ListRoutePoliciesFixedSizeCollection(List<ListRoutePoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutePoliciesFixedSizeCollection createEmptyCollection() {
            return new ListRoutePoliciesFixedSizeCollection(null, 0);
        }

        protected ListRoutePoliciesFixedSizeCollection createCollection(List<ListRoutePoliciesPage> pages, int collectionSize) {
            return new ListRoutePoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutePoliciesPage
    extends AbstractPage<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy, ListRoutePoliciesPage> {
        private ListRoutePoliciesPage(PageContext<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy> context, RoutersListRoutePolicies response) {
            super(context, (Object)response);
        }

        private static ListRoutePoliciesPage createEmptyPage() {
            return new ListRoutePoliciesPage(null, null);
        }

        protected ListRoutePoliciesPage createPage(PageContext<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy> context, RoutersListRoutePolicies response) {
            return new ListRoutePoliciesPage(context, response);
        }

        public ApiFuture<ListRoutePoliciesPage> createPageAsync(PageContext<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy> context, ApiFuture<RoutersListRoutePolicies> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutePoliciesPagedResponse
    extends AbstractPagedListResponse<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy, ListRoutePoliciesPage, ListRoutePoliciesFixedSizeCollection> {
        public static ApiFuture<ListRoutePoliciesPagedResponse> createAsync(PageContext<ListRoutePoliciesRoutersRequest, RoutersListRoutePolicies, RoutePolicy> context, ApiFuture<RoutersListRoutePolicies> futureResponse) {
            ApiFuture<ListRoutePoliciesPage> futurePage = ListRoutePoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRoutePoliciesPagedResponse((ListRoutePoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRoutePoliciesPagedResponse(ListRoutePoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutePoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBgpRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute, ListBgpRoutesPage, ListBgpRoutesFixedSizeCollection> {
        private ListBgpRoutesFixedSizeCollection(List<ListBgpRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBgpRoutesFixedSizeCollection createEmptyCollection() {
            return new ListBgpRoutesFixedSizeCollection(null, 0);
        }

        protected ListBgpRoutesFixedSizeCollection createCollection(List<ListBgpRoutesPage> pages, int collectionSize) {
            return new ListBgpRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBgpRoutesPage
    extends AbstractPage<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute, ListBgpRoutesPage> {
        private ListBgpRoutesPage(PageContext<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute> context, RoutersListBgpRoutes response) {
            super(context, (Object)response);
        }

        private static ListBgpRoutesPage createEmptyPage() {
            return new ListBgpRoutesPage(null, null);
        }

        protected ListBgpRoutesPage createPage(PageContext<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute> context, RoutersListBgpRoutes response) {
            return new ListBgpRoutesPage(context, response);
        }

        public ApiFuture<ListBgpRoutesPage> createPageAsync(PageContext<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute> context, ApiFuture<RoutersListBgpRoutes> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBgpRoutesPagedResponse
    extends AbstractPagedListResponse<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute, ListBgpRoutesPage, ListBgpRoutesFixedSizeCollection> {
        public static ApiFuture<ListBgpRoutesPagedResponse> createAsync(PageContext<ListBgpRoutesRoutersRequest, RoutersListBgpRoutes, BgpRoute> context, ApiFuture<RoutersListBgpRoutes> futureResponse) {
            ApiFuture<ListBgpRoutesPage> futurePage = ListBgpRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBgpRoutesPagedResponse((ListBgpRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBgpRoutesPagedResponse(ListBgpRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBgpRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutersRequest, RouterList, Router, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRoutersRequest, RouterList, Router, ListPage> {
        private ListPage(PageContext<ListRoutersRequest, RouterList, Router> context, RouterList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRoutersRequest, RouterList, Router> context, RouterList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRoutersRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRoutersRequest, RouterList, Router, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRoutersRequest, RouterList, Router> context, ApiFuture<RouterList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetNatMappingInfoFixedSizeCollection
    extends AbstractFixedSizeCollection<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage, GetNatMappingInfoFixedSizeCollection> {
        private GetNatMappingInfoFixedSizeCollection(List<GetNatMappingInfoPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetNatMappingInfoFixedSizeCollection createEmptyCollection() {
            return new GetNatMappingInfoFixedSizeCollection(null, 0);
        }

        protected GetNatMappingInfoFixedSizeCollection createCollection(List<GetNatMappingInfoPage> pages, int collectionSize) {
            return new GetNatMappingInfoFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetNatMappingInfoPage
    extends AbstractPage<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage> {
        private GetNatMappingInfoPage(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, VmEndpointNatMappingsList response) {
            super(context, (Object)response);
        }

        private static GetNatMappingInfoPage createEmptyPage() {
            return new GetNatMappingInfoPage(null, null);
        }

        protected GetNatMappingInfoPage createPage(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, VmEndpointNatMappingsList response) {
            return new GetNatMappingInfoPage(context, response);
        }

        public ApiFuture<GetNatMappingInfoPage> createPageAsync(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, ApiFuture<VmEndpointNatMappingsList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetNatMappingInfoPagedResponse
    extends AbstractPagedListResponse<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings, GetNatMappingInfoPage, GetNatMappingInfoFixedSizeCollection> {
        public static ApiFuture<GetNatMappingInfoPagedResponse> createAsync(PageContext<GetNatMappingInfoRoutersRequest, VmEndpointNatMappingsList, VmEndpointNatMappings> context, ApiFuture<VmEndpointNatMappingsList> futureResponse) {
            ApiFuture<GetNatMappingInfoPage> futurePage = GetNatMappingInfoPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new GetNatMappingInfoPagedResponse((GetNatMappingInfoPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private GetNatMappingInfoPagedResponse(GetNatMappingInfoPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetNatMappingInfoFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, RouterAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, RouterAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, ApiFuture<RouterAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListRoutersRequest, RouterAggregatedList, Map.Entry<String, RoutersScopedList>> context, ApiFuture<RouterAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

