/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInstanceSettingRequest;
import com.google.cloud.compute.v1.InstanceSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceSettingRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceSettingsServiceCallableFactory;
import com.google.cloud.compute.v1.stub.HttpJsonZoneOperationsStub;
import com.google.cloud.compute.v1.stub.InstanceSettingsServiceStub;
import com.google.cloud.compute.v1.stub.InstanceSettingsServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonInstanceSettingsServiceStub
extends InstanceSettingsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetInstanceSettingRequest, InstanceSettings> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceSettingsService/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceSettings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InstanceSettings.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<PatchInstanceSettingRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceSettingsService/Patch").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceSettings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        if (request.hasUpdateMask()) {
            serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceSettingsResource", (Message)request.getInstanceSettingsResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<GetInstanceSettingRequest, InstanceSettings> getCallable;
    private final UnaryCallable<PatchInstanceSettingRequest, Operation> patchCallable;
    private final OperationCallable<PatchInstanceSettingRequest, Operation, Operation> patchOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonZoneOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInstanceSettingsServiceStub create(InstanceSettingsServiceStubSettings settings) throws IOException {
        return new HttpJsonInstanceSettingsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInstanceSettingsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInstanceSettingsServiceStub(InstanceSettingsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInstanceSettingsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInstanceSettingsServiceStub(InstanceSettingsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInstanceSettingsServiceStub(InstanceSettingsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInstanceSettingsServiceCallableFactory());
    }

    protected HttpJsonInstanceSettingsServiceStub(InstanceSettingsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonZoneOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("zone", String.valueOf(request.getZone()));
            return builder.build();
        }).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("zone", String.valueOf(request.getZone()));
            return builder.build();
        }).build();
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.patchOperationCallable = callableFactory.createOperationCallable(patchTransportSettings, settings.patchOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetInstanceSettingRequest, InstanceSettings> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<PatchInstanceSettingRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public OperationCallable<PatchInstanceSettingRequest, Operation, Operation> patchOperationCallable() {
        return this.patchOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

