/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetReservationSubBlockRequest;
import com.google.cloud.compute.v1.ListReservationSubBlocksRequest;
import com.google.cloud.compute.v1.ReservationSubBlock;
import com.google.cloud.compute.v1.ReservationSubBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationSubBlocksListResponse;
import com.google.cloud.compute.v1.ReservationSubBlocksSettings;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReservationSubBlocksClient
implements BackgroundResource {
    private final ReservationSubBlocksSettings settings;
    private final ReservationSubBlocksStub stub;

    public static final ReservationSubBlocksClient create() throws IOException {
        return ReservationSubBlocksClient.create(ReservationSubBlocksSettings.newBuilder().build());
    }

    public static final ReservationSubBlocksClient create(ReservationSubBlocksSettings settings) throws IOException {
        return new ReservationSubBlocksClient(settings);
    }

    public static final ReservationSubBlocksClient create(ReservationSubBlocksStub stub) {
        return new ReservationSubBlocksClient(stub);
    }

    protected ReservationSubBlocksClient(ReservationSubBlocksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReservationSubBlocksStubSettings)settings.getStubSettings()).createStub();
    }

    protected ReservationSubBlocksClient(ReservationSubBlocksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReservationSubBlocksSettings getSettings() {
        return this.settings;
    }

    public ReservationSubBlocksStub getStub() {
        return this.stub;
    }

    public final ReservationSubBlocksGetResponse get(String project, String zone, String parentName, String reservationSubBlock) {
        GetReservationSubBlockRequest request = GetReservationSubBlockRequest.newBuilder().setProject(project).setZone(zone).setParentName(parentName).setReservationSubBlock(reservationSubBlock).build();
        return this.get(request);
    }

    public final ReservationSubBlocksGetResponse get(GetReservationSubBlockRequest request) {
        return (ReservationSubBlocksGetResponse)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone, String parentName) {
        ListReservationSubBlocksRequest request = ListReservationSubBlocksRequest.newBuilder().setProject(project).setZone(zone).setParentName(parentName).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListReservationSubBlocksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReservationSubBlocksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock, ListPage> {
        private ListPage(PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> context, ReservationSubBlocksListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> context, ReservationSubBlocksListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> context, ApiFuture<ReservationSubBlocksListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> context, ApiFuture<ReservationSubBlocksListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

