/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInstanceSettingRequest;
import com.google.cloud.compute.v1.InstanceSettings;
import com.google.cloud.compute.v1.InstanceSettingsServiceSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceSettingRequest;
import com.google.cloud.compute.v1.stub.InstanceSettingsServiceStub;
import com.google.cloud.compute.v1.stub.InstanceSettingsServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class InstanceSettingsServiceClient
implements BackgroundResource {
    private final InstanceSettingsServiceSettings settings;
    private final InstanceSettingsServiceStub stub;

    public static final InstanceSettingsServiceClient create() throws IOException {
        return InstanceSettingsServiceClient.create(InstanceSettingsServiceSettings.newBuilder().build());
    }

    public static final InstanceSettingsServiceClient create(InstanceSettingsServiceSettings settings) throws IOException {
        return new InstanceSettingsServiceClient(settings);
    }

    public static final InstanceSettingsServiceClient create(InstanceSettingsServiceStub stub) {
        return new InstanceSettingsServiceClient(stub);
    }

    protected InstanceSettingsServiceClient(InstanceSettingsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceSettingsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstanceSettingsServiceClient(InstanceSettingsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceSettingsServiceSettings getSettings() {
        return this.settings;
    }

    public InstanceSettingsServiceStub getStub() {
        return this.stub;
    }

    public final InstanceSettings get(String project, String zone) {
        GetInstanceSettingRequest request = GetInstanceSettingRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.get(request);
    }

    public final InstanceSettings get(GetInstanceSettingRequest request) {
        return (InstanceSettings)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceSettingRequest, InstanceSettings> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String zone, InstanceSettings instanceSettingsResource) {
        PatchInstanceSettingRequest request = PatchInstanceSettingRequest.newBuilder().setProject(project).setZone(zone).setInstanceSettingsResource(instanceSettingsResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchInstanceSettingRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInstanceSettingRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInstanceSettingRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

