/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AggregatedListNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.CloneRulesNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPoliciesScopedList;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.NetworkFirewallPoliciesSettings;
import com.google.cloud.compute.v1.NetworkFirewallPolicyAggregatedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveAssociationNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NetworkFirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.NetworkFirewallPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkFirewallPoliciesClient
implements BackgroundResource {
    private final NetworkFirewallPoliciesSettings settings;
    private final NetworkFirewallPoliciesStub stub;

    public static final NetworkFirewallPoliciesClient create() throws IOException {
        return NetworkFirewallPoliciesClient.create(NetworkFirewallPoliciesSettings.newBuilder().build());
    }

    public static final NetworkFirewallPoliciesClient create(NetworkFirewallPoliciesSettings settings) throws IOException {
        return new NetworkFirewallPoliciesClient(settings);
    }

    public static final NetworkFirewallPoliciesClient create(NetworkFirewallPoliciesStub stub) {
        return new NetworkFirewallPoliciesClient(stub);
    }

    protected NetworkFirewallPoliciesClient(NetworkFirewallPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkFirewallPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected NetworkFirewallPoliciesClient(NetworkFirewallPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkFirewallPoliciesSettings getSettings() {
        return this.settings;
    }

    public NetworkFirewallPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(String project, String firewallPolicy, FirewallPolicyAssociation firewallPolicyAssociationResource) {
        AddAssociationNetworkFirewallPolicyRequest request = AddAssociationNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).setFirewallPolicyAssociationResource(firewallPolicyAssociationResource).build();
        return this.addAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(AddAssociationNetworkFirewallPolicyRequest request) {
        return this.addAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddAssociationNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationCallable() {
        return this.stub.addAssociationOperationCallable();
    }

    public final UnaryCallable<AddAssociationNetworkFirewallPolicyRequest, Operation> addAssociationCallable() {
        return this.stub.addAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(String project, String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        AddRuleNetworkFirewallPolicyRequest request = AddRuleNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.addRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(AddRuleNetworkFirewallPolicyRequest request) {
        return this.addRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddRuleNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.stub.addRuleOperationCallable();
    }

    public final UnaryCallable<AddRuleNetworkFirewallPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNetworkFirewallPoliciesRequest request = AggregatedListNetworkFirewallPoliciesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNetworkFirewallPoliciesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNetworkFirewallPoliciesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> cloneRulesAsync(String project, String firewallPolicy) {
        CloneRulesNetworkFirewallPolicyRequest request = CloneRulesNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.cloneRulesAsync(request);
    }

    public final OperationFuture<Operation, Operation> cloneRulesAsync(CloneRulesNetworkFirewallPolicyRequest request) {
        return this.cloneRulesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CloneRulesNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationCallable() {
        return this.stub.cloneRulesOperationCallable();
    }

    public final UnaryCallable<CloneRulesNetworkFirewallPolicyRequest, Operation> cloneRulesCallable() {
        return this.stub.cloneRulesCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String firewallPolicy) {
        DeleteNetworkFirewallPolicyRequest request = DeleteNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNetworkFirewallPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkFirewallPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final FirewallPolicy get(String project, String firewallPolicy) {
        GetNetworkFirewallPolicyRequest request = GetNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.get(request);
    }

    public final FirewallPolicy get(GetNetworkFirewallPolicyRequest request) {
        return (FirewallPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkFirewallPolicyRequest, FirewallPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final FirewallPolicyAssociation getAssociation(String project, String firewallPolicy) {
        GetAssociationNetworkFirewallPolicyRequest request = GetAssociationNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.getAssociation(request);
    }

    public final FirewallPolicyAssociation getAssociation(GetAssociationNetworkFirewallPolicyRequest request) {
        return (FirewallPolicyAssociation)this.getAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssociationNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationCallable() {
        return this.stub.getAssociationCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyNetworkFirewallPolicyRequest request = GetIamPolicyNetworkFirewallPolicyRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyNetworkFirewallPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyNetworkFirewallPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final FirewallPolicyRule getRule(String project, String firewallPolicy) {
        GetRuleNetworkFirewallPolicyRequest request = GetRuleNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.getRule(request);
    }

    public final FirewallPolicyRule getRule(GetRuleNetworkFirewallPolicyRequest request) {
        return (FirewallPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, FirewallPolicy firewallPolicyResource) {
        InsertNetworkFirewallPolicyRequest request = InsertNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicyResource(firewallPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertNetworkFirewallPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNetworkFirewallPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNetworkFirewallPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListNetworkFirewallPoliciesRequest request = ListNetworkFirewallPoliciesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNetworkFirewallPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkFirewallPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNetworkFirewallPoliciesRequest, FirewallPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String firewallPolicy, FirewallPolicy firewallPolicyResource) {
        PatchNetworkFirewallPolicyRequest request = PatchNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).setFirewallPolicyResource(firewallPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchNetworkFirewallPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchNetworkFirewallPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchNetworkFirewallPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(String project, String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        PatchRuleNetworkFirewallPolicyRequest request = PatchRuleNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.patchRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(PatchRuleNetworkFirewallPolicyRequest request) {
        return this.patchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRuleNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.stub.patchRuleOperationCallable();
    }

    public final UnaryCallable<PatchRuleNetworkFirewallPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(String project, String firewallPolicy) {
        RemoveAssociationNetworkFirewallPolicyRequest request = RemoveAssociationNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.removeAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(RemoveAssociationNetworkFirewallPolicyRequest request) {
        return this.removeAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveAssociationNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationCallable() {
        return this.stub.removeAssociationOperationCallable();
    }

    public final UnaryCallable<RemoveAssociationNetworkFirewallPolicyRequest, Operation> removeAssociationCallable() {
        return this.stub.removeAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(String project, String firewallPolicy) {
        RemoveRuleNetworkFirewallPolicyRequest request = RemoveRuleNetworkFirewallPolicyRequest.newBuilder().setProject(project).setFirewallPolicy(firewallPolicy).build();
        return this.removeRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(RemoveRuleNetworkFirewallPolicyRequest request) {
        return this.removeRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveRuleNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.stub.removeRuleOperationCallable();
    }

    public final UnaryCallable<RemoveRuleNetworkFirewallPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyNetworkFirewallPolicyRequest request = SetIamPolicyNetworkFirewallPolicyRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyNetworkFirewallPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyNetworkFirewallPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNetworkFirewallPolicyRequest request = TestIamPermissionsNetworkFirewallPolicyRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsNetworkFirewallPolicyRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage> {
        private ListPage(PageContext<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>> context, NetworkFirewallPolicyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>> context, NetworkFirewallPolicyAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>> context, ApiFuture<NetworkFirewallPolicyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNetworkFirewallPoliciesRequest, NetworkFirewallPolicyAggregatedList, Map.Entry<String, FirewallPoliciesScopedList>> context, ApiFuture<NetworkFirewallPolicyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

