/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddPeeringNetworkRequest;
import com.google.cloud.compute.v1.DeleteNetworkRequest;
import com.google.cloud.compute.v1.ExchangedPeeringRoute;
import com.google.cloud.compute.v1.ExchangedPeeringRoutesList;
import com.google.cloud.compute.v1.GetEffectiveFirewallsNetworkRequest;
import com.google.cloud.compute.v1.GetNetworkRequest;
import com.google.cloud.compute.v1.InsertNetworkRequest;
import com.google.cloud.compute.v1.ListNetworksRequest;
import com.google.cloud.compute.v1.ListPeeringRoutesNetworksRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.NetworksClient;
import com.google.cloud.compute.v1.NetworksGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkRequest;
import com.google.cloud.compute.v1.RemovePeeringNetworkRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkRequest;
import com.google.cloud.compute.v1.UpdatePeeringNetworkRequest;
import com.google.cloud.compute.v1.stub.HttpJsonNetworksStub;
import com.google.cloud.compute.v1.stub.NetworksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class NetworksStubSettings
extends StubSettings<NetworksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddPeeringNetworkRequest, Operation> addPeeringSettings;
    private final OperationCallSettings<AddPeeringNetworkRequest, Operation, Operation> addPeeringOperationSettings;
    private final UnaryCallSettings<DeleteNetworkRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteNetworkRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetNetworkRequest, Network> getSettings;
    private final UnaryCallSettings<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
    private final UnaryCallSettings<InsertNetworkRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertNetworkRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings;
    private final UnaryCallSettings<PatchNetworkRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchNetworkRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<RemovePeeringNetworkRequest, Operation> removePeeringSettings;
    private final OperationCallSettings<RemovePeeringNetworkRequest, Operation, Operation> removePeeringOperationSettings;
    private final UnaryCallSettings<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings;
    private final OperationCallSettings<SwitchToCustomModeNetworkRequest, Operation, Operation> switchToCustomModeOperationSettings;
    private final UnaryCallSettings<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings;
    private final OperationCallSettings<UpdatePeeringNetworkRequest, Operation, Operation> updatePeeringOperationSettings;
    private static final PagedListDescriptor<ListNetworksRequest, NetworkList, Network> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksRequest, NetworkList, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksRequest injectToken(ListNetworksRequest payload, String token) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageToken(token).build();
        }

        public ListNetworksRequest injectPageSize(ListNetworksRequest payload, int pageSize) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(NetworkList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> LIST_PEERING_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListPeeringRoutesNetworksRequest injectToken(ListPeeringRoutesNetworksRequest payload, String token) {
            return ListPeeringRoutesNetworksRequest.newBuilder((ListPeeringRoutesNetworksRequest)payload).setPageToken(token).build();
        }

        public ListPeeringRoutesNetworksRequest injectPageSize(ListPeeringRoutesNetworksRequest payload, int pageSize) {
            return ListPeeringRoutesNetworksRequest.newBuilder((ListPeeringRoutesNetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPeeringRoutesNetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ExchangedPeeringRoutesList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ExchangedPeeringRoute> extractResources(ExchangedPeeringRoutesList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse>(){

        public ApiFuture<NetworksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksRequest, NetworkList> callable, ListNetworksRequest request, ApiCallContext context, ApiFuture<NetworkList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworksClient.ListPagedResponse.createAsync((PageContext<ListNetworksRequest, NetworkList, Network>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> LIST_PEERING_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse>(){

        public ApiFuture<NetworksClient.ListPeeringRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList> callable, ListPeeringRoutesNetworksRequest request, ApiCallContext context, ApiFuture<ExchangedPeeringRoutesList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PEERING_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworksClient.ListPeeringRoutesPagedResponse.createAsync((PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddPeeringNetworkRequest, Operation> addPeeringSettings() {
        return this.addPeeringSettings;
    }

    public OperationCallSettings<AddPeeringNetworkRequest, Operation, Operation> addPeeringOperationSettings() {
        return this.addPeeringOperationSettings;
    }

    public UnaryCallSettings<DeleteNetworkRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteNetworkRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetNetworkRequest, Network> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
        return this.getEffectiveFirewallsSettings;
    }

    public UnaryCallSettings<InsertNetworkRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertNetworkRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings() {
        return this.listPeeringRoutesSettings;
    }

    public UnaryCallSettings<PatchNetworkRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchNetworkRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<RemovePeeringNetworkRequest, Operation> removePeeringSettings() {
        return this.removePeeringSettings;
    }

    public OperationCallSettings<RemovePeeringNetworkRequest, Operation, Operation> removePeeringOperationSettings() {
        return this.removePeeringOperationSettings;
    }

    public UnaryCallSettings<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings() {
        return this.switchToCustomModeSettings;
    }

    public OperationCallSettings<SwitchToCustomModeNetworkRequest, Operation, Operation> switchToCustomModeOperationSettings() {
        return this.switchToCustomModeOperationSettings;
    }

    public UnaryCallSettings<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings() {
        return this.updatePeeringSettings;
    }

    public OperationCallSettings<UpdatePeeringNetworkRequest, Operation, Operation> updatePeeringOperationSettings() {
        return this.updatePeeringOperationSettings;
    }

    public NetworksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addPeeringSettings = settingsBuilder.addPeeringSettings().build();
        this.addPeeringOperationSettings = settingsBuilder.addPeeringOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getEffectiveFirewallsSettings = settingsBuilder.getEffectiveFirewallsSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listPeeringRoutesSettings = settingsBuilder.listPeeringRoutesSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.removePeeringSettings = settingsBuilder.removePeeringSettings().build();
        this.removePeeringOperationSettings = settingsBuilder.removePeeringOperationSettings().build();
        this.switchToCustomModeSettings = settingsBuilder.switchToCustomModeSettings().build();
        this.switchToCustomModeOperationSettings = settingsBuilder.switchToCustomModeOperationSettings().build();
        this.updatePeeringSettings = settingsBuilder.updatePeeringSettings().build();
        this.updatePeeringOperationSettings = settingsBuilder.updatePeeringOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddPeeringNetworkRequest, Operation> addPeeringSettings;
        private final OperationCallSettings.Builder<AddPeeringNetworkRequest, Operation, Operation> addPeeringOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteNetworkRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetNetworkRequest, Network> getSettings;
        private final UnaryCallSettings.Builder<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
        private final UnaryCallSettings.Builder<InsertNetworkRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertNetworkRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings;
        private final UnaryCallSettings.Builder<PatchNetworkRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchNetworkRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<RemovePeeringNetworkRequest, Operation> removePeeringSettings;
        private final OperationCallSettings.Builder<RemovePeeringNetworkRequest, Operation, Operation> removePeeringOperationSettings;
        private final UnaryCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings;
        private final OperationCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation, Operation> switchToCustomModeOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings;
        private final OperationCallSettings.Builder<UpdatePeeringNetworkRequest, Operation, Operation> updatePeeringOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addPeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addPeeringOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectiveFirewallsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listPeeringRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PEERING_ROUTES_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.removePeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removePeeringOperationSettings = OperationCallSettings.newBuilder();
            this.switchToCustomModeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.switchToCustomModeOperationSettings = OperationCallSettings.newBuilder();
            this.updatePeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePeeringOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringSettings, this.deleteSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.insertSettings, this.listSettings, this.listPeeringRoutesSettings, this.patchSettings, this.removePeeringSettings, this.switchToCustomModeSettings, this.updatePeeringSettings);
            Builder.initDefaults(this);
        }

        protected Builder(NetworksStubSettings settings) {
            super((StubSettings)settings);
            this.addPeeringSettings = settings.addPeeringSettings.toBuilder();
            this.addPeeringOperationSettings = settings.addPeeringOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getEffectiveFirewallsSettings = settings.getEffectiveFirewallsSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listPeeringRoutesSettings = settings.listPeeringRoutesSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.removePeeringSettings = settings.removePeeringSettings.toBuilder();
            this.removePeeringOperationSettings = settings.removePeeringOperationSettings.toBuilder();
            this.switchToCustomModeSettings = settings.switchToCustomModeSettings.toBuilder();
            this.switchToCustomModeOperationSettings = settings.switchToCustomModeOperationSettings.toBuilder();
            this.updatePeeringSettings = settings.updatePeeringSettings.toBuilder();
            this.updatePeeringOperationSettings = settings.updatePeeringOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringSettings, this.deleteSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.insertSettings, this.listSettings, this.listPeeringRoutesSettings, this.patchSettings, this.removePeeringSettings, this.switchToCustomModeSettings, this.updatePeeringSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(NetworksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addPeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEffectiveFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPeeringRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removePeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.switchToCustomModeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addPeeringOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removePeeringOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.switchToCustomModeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updatePeeringOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddPeeringNetworkRequest, Operation> addPeeringSettings() {
            return this.addPeeringSettings;
        }

        public OperationCallSettings.Builder<AddPeeringNetworkRequest, Operation, Operation> addPeeringOperationSettings() {
            return this.addPeeringOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteNetworkRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkRequest, Network> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
            return this.getEffectiveFirewallsSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertNetworkRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings() {
            return this.listPeeringRoutesSettings;
        }

        public UnaryCallSettings.Builder<PatchNetworkRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchNetworkRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<RemovePeeringNetworkRequest, Operation> removePeeringSettings() {
            return this.removePeeringSettings;
        }

        public OperationCallSettings.Builder<RemovePeeringNetworkRequest, Operation, Operation> removePeeringOperationSettings() {
            return this.removePeeringOperationSettings;
        }

        public UnaryCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings() {
            return this.switchToCustomModeSettings;
        }

        public OperationCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation, Operation> switchToCustomModeOperationSettings() {
            return this.switchToCustomModeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings() {
            return this.updatePeeringSettings;
        }

        public OperationCallSettings.Builder<UpdatePeeringNetworkRequest, Operation, Operation> updatePeeringOperationSettings() {
            return this.updatePeeringOperationSettings;
        }

        public NetworksStubSettings build() throws IOException {
            return new NetworksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

