/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupsRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupRequest;
import com.google.cloud.compute.v1.GetInstanceGroupRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupList;
import com.google.cloud.compute.v1.InstanceGroupsClient;
import com.google.cloud.compute.v1.InstanceGroupsListInstances;
import com.google.cloud.compute.v1.ListInstanceGroupsRequest;
import com.google.cloud.compute.v1.ListInstancesInstanceGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveInstancesInstanceGroupRequest;
import com.google.cloud.compute.v1.SetNamedPortsInstanceGroupRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceGroupsCallableFactory;
import com.google.cloud.compute.v1.stub.HttpJsonZoneOperationsStub;
import com.google.cloud.compute.v1.stub.InstanceGroupsStub;
import com.google.cloud.compute.v1.stub.InstanceGroupsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonInstanceGroupsStub
extends InstanceGroupsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<AddInstancesInstanceGroupRequest, Operation> addInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/AddInstances").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceGroupsAddInstancesRequestResource", (Message)request.getInstanceGroupsAddInstancesRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/instanceGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasIncludeAllScopes()) {
            serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InstanceGroupAggregatedList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteInstanceGroupRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetInstanceGroupRequest, InstanceGroup> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InstanceGroup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<InsertInstanceGroupRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceGroupResource", (Message)request.getInstanceGroupResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<ListInstanceGroupsRequest, InstanceGroupList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InstanceGroupList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances> listInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/ListInstances").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceGroupsListInstancesRequestResource", (Message)request.getInstanceGroupsListInstancesRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)InstanceGroupsListInstances.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/RemoveInstances").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceGroupsRemoveInstancesRequestResource", (Message)request.getInstanceGroupsRemoveInstancesRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.InstanceGroups/SetNamedPorts").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instanceGroup", (Object)request.getInstanceGroup());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "zone", (Object)request.getZone());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceGroupsSetNamedPortsRequestResource", (Message)request.getInstanceGroupsSetNamedPortsRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        opName.append(":").append(request.getZone());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<AddInstancesInstanceGroupRequest, Operation> addInstancesCallable;
    private final OperationCallable<AddInstancesInstanceGroupRequest, Operation, Operation> addInstancesOperationCallable;
    private final UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteInstanceGroupRequest, Operation> deleteCallable;
    private final OperationCallable<DeleteInstanceGroupRequest, Operation, Operation> deleteOperationCallable;
    private final UnaryCallable<GetInstanceGroupRequest, InstanceGroup> getCallable;
    private final UnaryCallable<InsertInstanceGroupRequest, Operation> insertCallable;
    private final OperationCallable<InsertInstanceGroupRequest, Operation, Operation> insertOperationCallable;
    private final UnaryCallable<ListInstanceGroupsRequest, InstanceGroupList> listCallable;
    private final UnaryCallable<ListInstanceGroupsRequest, InstanceGroupsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances> listInstancesCallable;
    private final UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesCallable;
    private final OperationCallable<RemoveInstancesInstanceGroupRequest, Operation, Operation> removeInstancesOperationCallable;
    private final UnaryCallable<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsCallable;
    private final OperationCallable<SetNamedPortsInstanceGroupRequest, Operation, Operation> setNamedPortsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonZoneOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonInstanceGroupsStub create(InstanceGroupsStubSettings settings) throws IOException {
        return new HttpJsonInstanceGroupsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonInstanceGroupsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonInstanceGroupsStub(InstanceGroupsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonInstanceGroupsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonInstanceGroupsStub(InstanceGroupsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonInstanceGroupsStub(InstanceGroupsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonInstanceGroupsCallableFactory());
    }

    protected HttpJsonInstanceGroupsStub(InstanceGroupsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonZoneOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings addInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addInstancesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings removeInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeInstancesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setNamedPortsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setNamedPortsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.addInstancesCallable = callableFactory.createUnaryCallable(addInstancesTransportSettings, settings.addInstancesSettings(), clientContext);
        this.addInstancesOperationCallable = callableFactory.createOperationCallable(addInstancesTransportSettings, settings.addInstancesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteOperationCallable = callableFactory.createOperationCallable(deleteTransportSettings, settings.deleteOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.insertOperationCallable = callableFactory.createOperationCallable(insertTransportSettings, settings.insertOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.removeInstancesCallable = callableFactory.createUnaryCallable(removeInstancesTransportSettings, settings.removeInstancesSettings(), clientContext);
        this.removeInstancesOperationCallable = callableFactory.createOperationCallable(removeInstancesTransportSettings, settings.removeInstancesOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setNamedPortsCallable = callableFactory.createUnaryCallable(setNamedPortsTransportSettings, settings.setNamedPortsSettings(), clientContext);
        this.setNamedPortsOperationCallable = callableFactory.createOperationCallable(setNamedPortsTransportSettings, settings.setNamedPortsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(addInstancesMethodDescriptor);
        methodDescriptors.add(aggregatedListMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(listInstancesMethodDescriptor);
        methodDescriptors.add(removeInstancesMethodDescriptor);
        methodDescriptors.add(setNamedPortsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AddInstancesInstanceGroupRequest, Operation> addInstancesCallable() {
        return this.addInstancesCallable;
    }

    @Override
    public OperationCallable<AddInstancesInstanceGroupRequest, Operation, Operation> addInstancesOperationCallable() {
        return this.addInstancesOperationCallable;
    }

    @Override
    public UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<AggregatedListInstanceGroupsRequest, InstanceGroupsClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceGroupRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public UnaryCallable<GetInstanceGroupRequest, InstanceGroup> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertInstanceGroupRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public OperationCallable<InsertInstanceGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.insertOperationCallable;
    }

    @Override
    public UnaryCallable<ListInstanceGroupsRequest, InstanceGroupList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListInstanceGroupsRequest, InstanceGroupsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsListInstances> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesInstanceGroupsRequest, InstanceGroupsClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<RemoveInstancesInstanceGroupRequest, Operation> removeInstancesCallable() {
        return this.removeInstancesCallable;
    }

    @Override
    public OperationCallable<RemoveInstancesInstanceGroupRequest, Operation, Operation> removeInstancesOperationCallable() {
        return this.removeInstancesOperationCallable;
    }

    @Override
    public UnaryCallable<SetNamedPortsInstanceGroupRequest, Operation> setNamedPortsCallable() {
        return this.setNamedPortsCallable;
    }

    @Override
    public OperationCallable<SetNamedPortsInstanceGroupRequest, Operation, Operation> setNamedPortsOperationCallable() {
        return this.setNamedPortsOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

