/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetHttpProxiesRequest;
import com.google.cloud.compute.v1.DeleteTargetHttpProxyRequest;
import com.google.cloud.compute.v1.GetTargetHttpProxyRequest;
import com.google.cloud.compute.v1.InsertTargetHttpProxyRequest;
import com.google.cloud.compute.v1.ListTargetHttpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetHttpProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapTargetHttpProxyRequest;
import com.google.cloud.compute.v1.TargetHttpProxiesScopedList;
import com.google.cloud.compute.v1.TargetHttpProxiesSettings;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyAggregatedList;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.TargetHttpProxiesStub;
import com.google.cloud.compute.v1.stub.TargetHttpProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetHttpProxiesClient
implements BackgroundResource {
    private final TargetHttpProxiesSettings settings;
    private final TargetHttpProxiesStub stub;

    public static final TargetHttpProxiesClient create() throws IOException {
        return TargetHttpProxiesClient.create(TargetHttpProxiesSettings.newBuilder().build());
    }

    public static final TargetHttpProxiesClient create(TargetHttpProxiesSettings settings) throws IOException {
        return new TargetHttpProxiesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetHttpProxiesClient create(TargetHttpProxiesStub stub) {
        return new TargetHttpProxiesClient(stub);
    }

    protected TargetHttpProxiesClient(TargetHttpProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetHttpProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetHttpProxiesClient(TargetHttpProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetHttpProxiesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetHttpProxiesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetHttpProxiesRequest request = AggregatedListTargetHttpProxiesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetHttpProxiesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetHttpProxiesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String targetHttpProxy) {
        DeleteTargetHttpProxyRequest request = DeleteTargetHttpProxyRequest.newBuilder().setProject(project).setTargetHttpProxy(targetHttpProxy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteTargetHttpProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetHttpProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetHttpProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetHttpProxy get(String project, String targetHttpProxy) {
        GetTargetHttpProxyRequest request = GetTargetHttpProxyRequest.newBuilder().setProject(project).setTargetHttpProxy(targetHttpProxy).build();
        return this.get(request);
    }

    public final TargetHttpProxy get(GetTargetHttpProxyRequest request) {
        return (TargetHttpProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetHttpProxyRequest, TargetHttpProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, TargetHttpProxy targetHttpProxyResource) {
        InsertTargetHttpProxyRequest request = InsertTargetHttpProxyRequest.newBuilder().setProject(project).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertTargetHttpProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertTargetHttpProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertTargetHttpProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetHttpProxiesRequest request = ListTargetHttpProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetHttpProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetHttpProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetHttpProxiesRequest, TargetHttpProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String targetHttpProxy, TargetHttpProxy targetHttpProxyResource) {
        PatchTargetHttpProxyRequest request = PatchTargetHttpProxyRequest.newBuilder().setProject(project).setTargetHttpProxy(targetHttpProxy).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchTargetHttpProxyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchTargetHttpProxyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchTargetHttpProxyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> setUrlMapAsync(String project, String targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapTargetHttpProxyRequest request = SetUrlMapTargetHttpProxyRequest.newBuilder().setProject(project).setTargetHttpProxy(targetHttpProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setUrlMapAsync(SetUrlMapTargetHttpProxyRequest request) {
        return this.setUrlMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetUrlMapTargetHttpProxyRequest, Operation, Operation> setUrlMapOperationCallable() {
        return this.stub.setUrlMapOperationCallable();
    }

    public final UnaryCallable<SetUrlMapTargetHttpProxyRequest, Operation> setUrlMapCallable() {
        return this.stub.setUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage> {
        private ListPage(PageContext<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>> context, TargetHttpProxyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>> context, TargetHttpProxyAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>> context, ApiFuture<TargetHttpProxyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetHttpProxiesRequest, TargetHttpProxyAggregatedList, Map.Entry<String, TargetHttpProxiesScopedList>> context, ApiFuture<TargetHttpProxyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

