/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetSslProxyRequest;
import com.google.cloud.compute.v1.GetTargetSslProxyRequest;
import com.google.cloud.compute.v1.InsertTargetSslProxyRequest;
import com.google.cloud.compute.v1.ListTargetSslProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetCertificateMapTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetSslProxyRequest;
import com.google.cloud.compute.v1.TargetSslProxiesClient;
import com.google.cloud.compute.v1.TargetSslProxy;
import com.google.cloud.compute.v1.TargetSslProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetSslProxiesStub;
import com.google.cloud.compute.v1.stub.TargetSslProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetSslProxiesStubSettings
extends StubSettings<TargetSslProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteTargetSslProxyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteTargetSslProxyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetTargetSslProxyRequest, TargetSslProxy> getSettings;
    private final UnaryCallSettings<InsertTargetSslProxyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertTargetSslProxyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceSettings;
    private final OperationCallSettings<SetBackendServiceTargetSslProxyRequest, Operation, Operation> setBackendServiceOperationSettings;
    private final UnaryCallSettings<SetCertificateMapTargetSslProxyRequest, Operation> setCertificateMapSettings;
    private final OperationCallSettings<SetCertificateMapTargetSslProxyRequest, Operation, Operation> setCertificateMapOperationSettings;
    private final UnaryCallSettings<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderSettings;
    private final OperationCallSettings<SetProxyHeaderTargetSslProxyRequest, Operation, Operation> setProxyHeaderOperationSettings;
    private final UnaryCallSettings<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesSettings;
    private final OperationCallSettings<SetSslCertificatesTargetSslProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
    private final UnaryCallSettings<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicySettings;
    private final OperationCallSettings<SetSslPolicyTargetSslProxyRequest, Operation, Operation> setSslPolicyOperationSettings;
    private static final PagedListDescriptor<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetSslProxiesRequest injectToken(ListTargetSslProxiesRequest payload, String token) {
            return ListTargetSslProxiesRequest.newBuilder((ListTargetSslProxiesRequest)payload).setPageToken(token).build();
        }

        public ListTargetSslProxiesRequest injectPageSize(ListTargetSslProxiesRequest payload, int pageSize) {
            return ListTargetSslProxiesRequest.newBuilder((ListTargetSslProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetSslProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetSslProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetSslProxy> extractResources(TargetSslProxyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse>(){

        public ApiFuture<TargetSslProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetSslProxiesRequest, TargetSslProxyList> callable, ListTargetSslProxiesRequest request, ApiCallContext context, ApiFuture<TargetSslProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetSslProxiesClient.ListPagedResponse.createAsync((PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetSslProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteTargetSslProxyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetTargetSslProxyRequest, TargetSslProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertTargetSslProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertTargetSslProxyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceSettings() {
        return this.setBackendServiceSettings;
    }

    public OperationCallSettings<SetBackendServiceTargetSslProxyRequest, Operation, Operation> setBackendServiceOperationSettings() {
        return this.setBackendServiceOperationSettings;
    }

    public UnaryCallSettings<SetCertificateMapTargetSslProxyRequest, Operation> setCertificateMapSettings() {
        return this.setCertificateMapSettings;
    }

    public OperationCallSettings<SetCertificateMapTargetSslProxyRequest, Operation, Operation> setCertificateMapOperationSettings() {
        return this.setCertificateMapOperationSettings;
    }

    public UnaryCallSettings<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderSettings() {
        return this.setProxyHeaderSettings;
    }

    public OperationCallSettings<SetProxyHeaderTargetSslProxyRequest, Operation, Operation> setProxyHeaderOperationSettings() {
        return this.setProxyHeaderOperationSettings;
    }

    public UnaryCallSettings<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesSettings() {
        return this.setSslCertificatesSettings;
    }

    public OperationCallSettings<SetSslCertificatesTargetSslProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
        return this.setSslCertificatesOperationSettings;
    }

    public UnaryCallSettings<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicySettings() {
        return this.setSslPolicySettings;
    }

    public OperationCallSettings<SetSslPolicyTargetSslProxyRequest, Operation, Operation> setSslPolicyOperationSettings() {
        return this.setSslPolicyOperationSettings;
    }

    public TargetSslProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetSslProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetSslProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetSslProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetSslProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.setBackendServiceSettings = settingsBuilder.setBackendServiceSettings().build();
        this.setBackendServiceOperationSettings = settingsBuilder.setBackendServiceOperationSettings().build();
        this.setCertificateMapSettings = settingsBuilder.setCertificateMapSettings().build();
        this.setCertificateMapOperationSettings = settingsBuilder.setCertificateMapOperationSettings().build();
        this.setProxyHeaderSettings = settingsBuilder.setProxyHeaderSettings().build();
        this.setProxyHeaderOperationSettings = settingsBuilder.setProxyHeaderOperationSettings().build();
        this.setSslCertificatesSettings = settingsBuilder.setSslCertificatesSettings().build();
        this.setSslCertificatesOperationSettings = settingsBuilder.setSslCertificatesOperationSettings().build();
        this.setSslPolicySettings = settingsBuilder.setSslPolicySettings().build();
        this.setSslPolicyOperationSettings = settingsBuilder.setSslPolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetSslProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetSslProxyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteTargetSslProxyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetTargetSslProxyRequest, TargetSslProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertTargetSslProxyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertTargetSslProxyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceSettings;
        private final OperationCallSettings.Builder<SetBackendServiceTargetSslProxyRequest, Operation, Operation> setBackendServiceOperationSettings;
        private final UnaryCallSettings.Builder<SetCertificateMapTargetSslProxyRequest, Operation> setCertificateMapSettings;
        private final OperationCallSettings.Builder<SetCertificateMapTargetSslProxyRequest, Operation, Operation> setCertificateMapOperationSettings;
        private final UnaryCallSettings.Builder<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderSettings;
        private final OperationCallSettings.Builder<SetProxyHeaderTargetSslProxyRequest, Operation, Operation> setProxyHeaderOperationSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesSettings;
        private final OperationCallSettings.Builder<SetSslCertificatesTargetSslProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
        private final UnaryCallSettings.Builder<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicySettings;
        private final OperationCallSettings.Builder<SetSslPolicyTargetSslProxyRequest, Operation, Operation> setSslPolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.setBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setBackendServiceOperationSettings = OperationCallSettings.newBuilder();
            this.setCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setCertificateMapOperationSettings = OperationCallSettings.newBuilder();
            this.setProxyHeaderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setProxyHeaderOperationSettings = OperationCallSettings.newBuilder();
            this.setSslCertificatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslCertificatesOperationSettings = OperationCallSettings.newBuilder();
            this.setSslPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setBackendServiceSettings, this.setCertificateMapSettings, this.setProxyHeaderSettings, this.setSslCertificatesSettings, this.setSslPolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(TargetSslProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.setBackendServiceSettings = settings.setBackendServiceSettings.toBuilder();
            this.setBackendServiceOperationSettings = settings.setBackendServiceOperationSettings.toBuilder();
            this.setCertificateMapSettings = settings.setCertificateMapSettings.toBuilder();
            this.setCertificateMapOperationSettings = settings.setCertificateMapOperationSettings.toBuilder();
            this.setProxyHeaderSettings = settings.setProxyHeaderSettings.toBuilder();
            this.setProxyHeaderOperationSettings = settings.setProxyHeaderOperationSettings.toBuilder();
            this.setSslCertificatesSettings = settings.setSslCertificatesSettings.toBuilder();
            this.setSslCertificatesOperationSettings = settings.setSslCertificatesOperationSettings.toBuilder();
            this.setSslPolicySettings = settings.setSslPolicySettings.toBuilder();
            this.setSslPolicyOperationSettings = settings.setSslPolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setBackendServiceSettings, this.setCertificateMapSettings, this.setProxyHeaderSettings, this.setSslCertificatesSettings, this.setSslPolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetSslProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetSslProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetSslProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TargetSslProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setProxyHeaderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setBackendServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setCertificateMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setProxyHeaderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSslCertificatesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSslPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetSslProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteTargetSslProxyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTargetSslProxyRequest, TargetSslProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetSslProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertTargetSslProxyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceSettings() {
            return this.setBackendServiceSettings;
        }

        public OperationCallSettings.Builder<SetBackendServiceTargetSslProxyRequest, Operation, Operation> setBackendServiceOperationSettings() {
            return this.setBackendServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<SetCertificateMapTargetSslProxyRequest, Operation> setCertificateMapSettings() {
            return this.setCertificateMapSettings;
        }

        public OperationCallSettings.Builder<SetCertificateMapTargetSslProxyRequest, Operation, Operation> setCertificateMapOperationSettings() {
            return this.setCertificateMapOperationSettings;
        }

        public UnaryCallSettings.Builder<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderSettings() {
            return this.setProxyHeaderSettings;
        }

        public OperationCallSettings.Builder<SetProxyHeaderTargetSslProxyRequest, Operation, Operation> setProxyHeaderOperationSettings() {
            return this.setProxyHeaderOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesSettings() {
            return this.setSslCertificatesSettings;
        }

        public OperationCallSettings.Builder<SetSslCertificatesTargetSslProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
            return this.setSslCertificatesOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicySettings() {
            return this.setSslPolicySettings;
        }

        public OperationCallSettings.Builder<SetSslPolicyTargetSslProxyRequest, Operation, Operation> setSslPolicyOperationSettings() {
            return this.setSslPolicyOperationSettings;
        }

        public TargetSslProxiesStubSettings build() throws IOException {
            return new TargetSslProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

