/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListForwardingRulesRequest;
import com.google.cloud.compute.v1.DeleteForwardingRuleRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleAggregatedList;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.ForwardingRulesClient;
import com.google.cloud.compute.v1.ForwardingRulesScopedList;
import com.google.cloud.compute.v1.GetForwardingRuleRequest;
import com.google.cloud.compute.v1.InsertForwardingRuleRequest;
import com.google.cloud.compute.v1.ListForwardingRulesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchForwardingRuleRequest;
import com.google.cloud.compute.v1.SetLabelsForwardingRuleRequest;
import com.google.cloud.compute.v1.SetTargetForwardingRuleRequest;
import com.google.cloud.compute.v1.stub.ForwardingRulesStub;
import com.google.cloud.compute.v1.stub.HttpJsonForwardingRulesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class ForwardingRulesStubSettings
extends StubSettings<ForwardingRulesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteForwardingRuleRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteForwardingRuleRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetForwardingRuleRequest, ForwardingRule> getSettings;
    private final UnaryCallSettings<InsertForwardingRuleRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertForwardingRuleRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchForwardingRuleRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchForwardingRuleRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetLabelsForwardingRuleRequest, Operation> setLabelsSettings;
    private final OperationCallSettings<SetLabelsForwardingRuleRequest, Operation, Operation> setLabelsOperationSettings;
    private final UnaryCallSettings<SetTargetForwardingRuleRequest, Operation> setTargetSettings;
    private final OperationCallSettings<SetTargetForwardingRuleRequest, Operation, Operation> setTargetOperationSettings;
    private static final PagedListDescriptor<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListForwardingRulesRequest injectToken(AggregatedListForwardingRulesRequest payload, String token) {
            return AggregatedListForwardingRulesRequest.newBuilder((AggregatedListForwardingRulesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListForwardingRulesRequest injectPageSize(AggregatedListForwardingRulesRequest payload, int pageSize) {
            return AggregatedListForwardingRulesRequest.newBuilder((AggregatedListForwardingRulesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListForwardingRulesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ForwardingRuleAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, ForwardingRulesScopedList>> extractResources(ForwardingRuleAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule>(){

        public String emptyToken() {
            return "";
        }

        public ListForwardingRulesRequest injectToken(ListForwardingRulesRequest payload, String token) {
            return ListForwardingRulesRequest.newBuilder((ListForwardingRulesRequest)payload).setPageToken(token).build();
        }

        public ListForwardingRulesRequest injectPageSize(ListForwardingRulesRequest payload, int pageSize) {
            return ListForwardingRulesRequest.newBuilder((ListForwardingRulesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListForwardingRulesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ForwardingRuleList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ForwardingRule> extractResources(ForwardingRuleList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse>(){

        public ApiFuture<ForwardingRulesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList> callable, AggregatedListForwardingRulesRequest request, ApiCallContext context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ForwardingRulesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse>(){

        public ApiFuture<ForwardingRulesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListForwardingRulesRequest, ForwardingRuleList> callable, ListForwardingRulesRequest request, ApiCallContext context, ApiFuture<ForwardingRuleList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ForwardingRulesClient.ListPagedResponse.createAsync((PageContext<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteForwardingRuleRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteForwardingRuleRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetForwardingRuleRequest, ForwardingRule> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertForwardingRuleRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertForwardingRuleRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchForwardingRuleRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchForwardingRuleRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetLabelsForwardingRuleRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public OperationCallSettings<SetLabelsForwardingRuleRequest, Operation, Operation> setLabelsOperationSettings() {
        return this.setLabelsOperationSettings;
    }

    public UnaryCallSettings<SetTargetForwardingRuleRequest, Operation> setTargetSettings() {
        return this.setTargetSettings;
    }

    public OperationCallSettings<SetTargetForwardingRuleRequest, Operation, Operation> setTargetOperationSettings() {
        return this.setTargetOperationSettings;
    }

    public ForwardingRulesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonForwardingRulesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ForwardingRulesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ForwardingRulesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ForwardingRulesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLabelsOperationSettings = settingsBuilder.setLabelsOperationSettings().build();
        this.setTargetSettings = settingsBuilder.setTargetSettings().build();
        this.setTargetOperationSettings = settingsBuilder.setTargetOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ForwardingRulesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteForwardingRuleRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteForwardingRuleRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetForwardingRuleRequest, ForwardingRule> getSettings;
        private final UnaryCallSettings.Builder<InsertForwardingRuleRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertForwardingRuleRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchForwardingRuleRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchForwardingRuleRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetLabelsForwardingRuleRequest, Operation> setLabelsSettings;
        private final OperationCallSettings.Builder<SetLabelsForwardingRuleRequest, Operation, Operation> setLabelsOperationSettings;
        private final UnaryCallSettings.Builder<SetTargetForwardingRuleRequest, Operation> setTargetSettings;
        private final OperationCallSettings.Builder<SetTargetForwardingRuleRequest, Operation, Operation> setTargetOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.setTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTargetOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setLabelsSettings, this.setTargetSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ForwardingRulesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLabelsOperationSettings = settings.setLabelsOperationSettings.toBuilder();
            this.setTargetSettings = settings.setTargetSettings.toBuilder();
            this.setTargetOperationSettings = settings.setTargetOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setLabelsSettings, this.setTargetSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ForwardingRulesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ForwardingRulesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ForwardingRulesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ForwardingRulesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setTargetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, ForwardingRulesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteForwardingRuleRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteForwardingRuleRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetForwardingRuleRequest, ForwardingRule> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertForwardingRuleRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertForwardingRuleRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRulesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchForwardingRuleRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchForwardingRuleRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsForwardingRuleRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public OperationCallSettings.Builder<SetLabelsForwardingRuleRequest, Operation, Operation> setLabelsOperationSettings() {
            return this.setLabelsOperationSettings;
        }

        public UnaryCallSettings.Builder<SetTargetForwardingRuleRequest, Operation> setTargetSettings() {
            return this.setTargetSettings;
        }

        public OperationCallSettings.Builder<SetTargetForwardingRuleRequest, Operation, Operation> setTargetOperationSettings() {
            return this.setTargetOperationSettings;
        }

        public ForwardingRulesStubSettings build() throws IOException {
            return new ForwardingRulesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

