/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteMachineImageRequest;
import com.google.cloud.compute.v1.GetIamPolicyMachineImageRequest;
import com.google.cloud.compute.v1.GetMachineImageRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertMachineImageRequest;
import com.google.cloud.compute.v1.ListMachineImagesRequest;
import com.google.cloud.compute.v1.MachineImage;
import com.google.cloud.compute.v1.MachineImageList;
import com.google.cloud.compute.v1.MachineImagesSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyMachineImageRequest;
import com.google.cloud.compute.v1.TestIamPermissionsMachineImageRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.MachineImagesStub;
import com.google.cloud.compute.v1.stub.MachineImagesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MachineImagesClient
implements BackgroundResource {
    private final MachineImagesSettings settings;
    private final MachineImagesStub stub;

    public static final MachineImagesClient create() throws IOException {
        return MachineImagesClient.create(MachineImagesSettings.newBuilder().build());
    }

    public static final MachineImagesClient create(MachineImagesSettings settings) throws IOException {
        return new MachineImagesClient(settings);
    }

    public static final MachineImagesClient create(MachineImagesStub stub) {
        return new MachineImagesClient(stub);
    }

    protected MachineImagesClient(MachineImagesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MachineImagesStubSettings)settings.getStubSettings()).createStub();
    }

    protected MachineImagesClient(MachineImagesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MachineImagesSettings getSettings() {
        return this.settings;
    }

    public MachineImagesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String machineImage) {
        DeleteMachineImageRequest request = DeleteMachineImageRequest.newBuilder().setProject(project).setMachineImage(machineImage).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteMachineImageRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMachineImageRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteMachineImageRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final MachineImage get(String project, String machineImage) {
        GetMachineImageRequest request = GetMachineImageRequest.newBuilder().setProject(project).setMachineImage(machineImage).build();
        return this.get(request);
    }

    public final MachineImage get(GetMachineImageRequest request) {
        return (MachineImage)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetMachineImageRequest, MachineImage> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyMachineImageRequest request = GetIamPolicyMachineImageRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyMachineImageRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyMachineImageRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, MachineImage machineImageResource) {
        InsertMachineImageRequest request = InsertMachineImageRequest.newBuilder().setProject(project).setMachineImageResource(machineImageResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertMachineImageRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertMachineImageRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertMachineImageRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListMachineImagesRequest request = ListMachineImagesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListMachineImagesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMachineImagesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListMachineImagesRequest, MachineImageList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyMachineImageRequest request = SetIamPolicyMachineImageRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyMachineImageRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyMachineImageRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsMachineImageRequest request = TestIamPermissionsMachineImageRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsMachineImageRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsMachineImageRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMachineImagesRequest, MachineImageList, MachineImage, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListMachineImagesRequest, MachineImageList, MachineImage, ListPage> {
        private ListPage(PageContext<ListMachineImagesRequest, MachineImageList, MachineImage> context, MachineImageList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListMachineImagesRequest, MachineImageList, MachineImage> context, MachineImageList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListMachineImagesRequest, MachineImageList, MachineImage> context, ApiFuture<MachineImageList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListMachineImagesRequest, MachineImageList, MachineImage, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListMachineImagesRequest, MachineImageList, MachineImage> context, ApiFuture<MachineImageList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

