/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.RegionTargetHttpsProxiesClient;
import com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionTargetHttpsProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionTargetHttpsProxiesStubSettings
extends StubSettings<RegionTargetHttpsProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteRegionTargetHttpsProxyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetRegionTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
    private final UnaryCallSettings<InsertRegionTargetHttpsProxyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchRegionTargetHttpsProxyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchRegionTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
    private final OperationCallSettings<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
    private final UnaryCallSettings<SetUrlMapRegionTargetHttpsProxyRequest, Operation> setUrlMapSettings;
    private final OperationCallSettings<SetUrlMapRegionTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings;
    private static final PagedListDescriptor<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionTargetHttpsProxiesRequest injectToken(ListRegionTargetHttpsProxiesRequest payload, String token) {
            return ListRegionTargetHttpsProxiesRequest.newBuilder((ListRegionTargetHttpsProxiesRequest)payload).setPageToken(token).build();
        }

        public ListRegionTargetHttpsProxiesRequest injectPageSize(ListRegionTargetHttpsProxiesRequest payload, int pageSize) {
            return ListRegionTargetHttpsProxiesRequest.newBuilder((ListRegionTargetHttpsProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionTargetHttpsProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetHttpsProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetHttpsProxy> extractResources(TargetHttpsProxyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse>(){

        public ApiFuture<RegionTargetHttpsProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList> callable, ListRegionTargetHttpsProxiesRequest request, ApiCallContext context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionTargetHttpsProxiesClient.ListPagedResponse.createAsync((PageContext<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionTargetHttpsProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetRegionTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertRegionTargetHttpsProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchRegionTargetHttpsProxyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchRegionTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
        return this.setSslCertificatesSettings;
    }

    public OperationCallSettings<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
        return this.setSslCertificatesOperationSettings;
    }

    public UnaryCallSettings<SetUrlMapRegionTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
        return this.setUrlMapSettings;
    }

    public OperationCallSettings<SetUrlMapRegionTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings() {
        return this.setUrlMapOperationSettings;
    }

    public RegionTargetHttpsProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionTargetHttpsProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionTargetHttpsProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionTargetHttpsProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionTargetHttpsProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setSslCertificatesSettings = settingsBuilder.setSslCertificatesSettings().build();
        this.setSslCertificatesOperationSettings = settingsBuilder.setSslCertificatesOperationSettings().build();
        this.setUrlMapSettings = settingsBuilder.setUrlMapSettings().build();
        this.setUrlMapOperationSettings = settingsBuilder.setUrlMapOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionTargetHttpsProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionTargetHttpsProxyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionTargetHttpsProxyRequest, TargetHttpsProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertRegionTargetHttpsProxyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchRegionTargetHttpsProxyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchRegionTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation> setSslCertificatesSettings;
        private final OperationCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings;
        private final UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyRequest, Operation> setUrlMapSettings;
        private final OperationCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setSslCertificatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSslCertificatesOperationSettings = OperationCallSettings.newBuilder();
            this.setUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUrlMapOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setSslCertificatesSettings, this.setUrlMapSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionTargetHttpsProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setSslCertificatesSettings = settings.setSslCertificatesSettings.toBuilder();
            this.setSslCertificatesOperationSettings = settings.setSslCertificatesOperationSettings.toBuilder();
            this.setUrlMapSettings = settings.setUrlMapSettings.toBuilder();
            this.setUrlMapOperationSettings = settings.setUrlMapOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.setSslCertificatesSettings, this.setUrlMapSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionTargetHttpsProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionTargetHttpsProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionTargetHttpsProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionTargetHttpsProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSslCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSslCertificatesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setUrlMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionTargetHttpsProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRegionTargetHttpsProxyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionTargetHttpsProxyRequest, TargetHttpsProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionTargetHttpsProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionTargetHttpsProxyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, RegionTargetHttpsProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionTargetHttpsProxyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchRegionTargetHttpsProxyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation> setSslCertificatesSettings() {
            return this.setSslCertificatesSettings;
        }

        public OperationCallSettings.Builder<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation, Operation> setSslCertificatesOperationSettings() {
            return this.setSslCertificatesOperationSettings;
        }

        public UnaryCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyRequest, Operation> setUrlMapSettings() {
            return this.setUrlMapSettings;
        }

        public OperationCallSettings.Builder<SetUrlMapRegionTargetHttpsProxyRequest, Operation, Operation> setUrlMapOperationSettings() {
            return this.setUrlMapOperationSettings;
        }

        public RegionTargetHttpsProxiesStubSettings build() throws IOException {
            return new RegionTargetHttpsProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

