/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRegionCommitmentsRequest;
import com.google.cloud.compute.v1.Commitment;
import com.google.cloud.compute.v1.CommitmentAggregatedList;
import com.google.cloud.compute.v1.CommitmentList;
import com.google.cloud.compute.v1.CommitmentsScopedList;
import com.google.cloud.compute.v1.GetRegionCommitmentRequest;
import com.google.cloud.compute.v1.InsertRegionCommitmentRequest;
import com.google.cloud.compute.v1.ListRegionCommitmentsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionCommitmentsClient;
import com.google.cloud.compute.v1.UpdateRegionCommitmentRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionCommitmentsStub;
import com.google.cloud.compute.v1.stub.RegionCommitmentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionCommitmentsStubSettings
extends StubSettings<RegionCommitmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetRegionCommitmentRequest, Commitment> getSettings;
    private final UnaryCallSettings<InsertRegionCommitmentRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionCommitmentRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<UpdateRegionCommitmentRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateRegionCommitmentRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListRegionCommitmentsRequest injectToken(AggregatedListRegionCommitmentsRequest payload, String token) {
            return AggregatedListRegionCommitmentsRequest.newBuilder((AggregatedListRegionCommitmentsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListRegionCommitmentsRequest injectPageSize(AggregatedListRegionCommitmentsRequest payload, int pageSize) {
            return AggregatedListRegionCommitmentsRequest.newBuilder((AggregatedListRegionCommitmentsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListRegionCommitmentsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(CommitmentAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, CommitmentsScopedList>> extractResources(CommitmentAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListRegionCommitmentsRequest, CommitmentList, Commitment> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionCommitmentsRequest, CommitmentList, Commitment>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionCommitmentsRequest injectToken(ListRegionCommitmentsRequest payload, String token) {
            return ListRegionCommitmentsRequest.newBuilder((ListRegionCommitmentsRequest)payload).setPageToken(token).build();
        }

        public ListRegionCommitmentsRequest injectPageSize(ListRegionCommitmentsRequest payload, int pageSize) {
            return ListRegionCommitmentsRequest.newBuilder((ListRegionCommitmentsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionCommitmentsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(CommitmentList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Commitment> extractResources(CommitmentList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse>(){

        public ApiFuture<RegionCommitmentsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList> callable, AggregatedListRegionCommitmentsRequest request, ApiCallContext context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionCommitmentsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, Map.Entry<String, CommitmentsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse>(){

        public ApiFuture<RegionCommitmentsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionCommitmentsRequest, CommitmentList> callable, ListRegionCommitmentsRequest request, ApiCallContext context, ApiFuture<CommitmentList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionCommitmentsClient.ListPagedResponse.createAsync((PageContext<ListRegionCommitmentsRequest, CommitmentList, Commitment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetRegionCommitmentRequest, Commitment> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertRegionCommitmentRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionCommitmentRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<UpdateRegionCommitmentRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateRegionCommitmentRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public RegionCommitmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionCommitmentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionCommitmentsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionCommitmentsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionCommitmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionCommitmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetRegionCommitmentRequest, Commitment> getSettings;
        private final UnaryCallSettings.Builder<InsertRegionCommitmentRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionCommitmentRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<UpdateRegionCommitmentRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateRegionCommitmentRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.insertSettings, this.listSettings, this.updateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionCommitmentsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.insertSettings, this.listSettings, this.updateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionCommitmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionCommitmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionCommitmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionCommitmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListRegionCommitmentsRequest, CommitmentAggregatedList, RegionCommitmentsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetRegionCommitmentRequest, Commitment> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionCommitmentRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionCommitmentRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionCommitmentsRequest, CommitmentList, RegionCommitmentsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionCommitmentRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateRegionCommitmentRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public RegionCommitmentsStubSettings build() throws IOException {
            return new RegionCommitmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

