/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListRegionSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.RegionSecurityPoliciesClient;
import com.google.cloud.compute.v1.RemoveRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.HttpJsonRegionSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionSecurityPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionSecurityPoliciesStubSettings
extends StubSettings<RegionSecurityPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddRuleRegionSecurityPolicyRequest, Operation> addRuleSettings;
    private final OperationCallSettings<AddRuleRegionSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
    private final UnaryCallSettings<DeleteRegionSecurityPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetRegionSecurityPolicyRequest, SecurityPolicy> getSettings;
    private final UnaryCallSettings<GetRuleRegionSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertRegionSecurityPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchRegionSecurityPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchRuleRegionSecurityPolicyRequest, Operation> patchRuleSettings;
    private final OperationCallSettings<PatchRuleRegionSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
    private final UnaryCallSettings<RemoveRuleRegionSecurityPolicyRequest, Operation> removeRuleSettings;
    private final OperationCallSettings<RemoveRuleRegionSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
    private static final PagedListDescriptor<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionSecurityPoliciesRequest injectToken(ListRegionSecurityPoliciesRequest payload, String token) {
            return ListRegionSecurityPoliciesRequest.newBuilder((ListRegionSecurityPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListRegionSecurityPoliciesRequest injectPageSize(ListRegionSecurityPoliciesRequest payload, int pageSize) {
            return ListRegionSecurityPoliciesRequest.newBuilder((ListRegionSecurityPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionSecurityPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SecurityPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecurityPolicy> extractResources(SecurityPolicyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse>(){

        public ApiFuture<RegionSecurityPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionSecurityPoliciesRequest, SecurityPolicyList> callable, ListRegionSecurityPoliciesRequest request, ApiCallContext context, ApiFuture<SecurityPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionSecurityPoliciesClient.ListPagedResponse.createAsync((PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddRuleRegionSecurityPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public OperationCallSettings<AddRuleRegionSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
        return this.addRuleOperationSettings;
    }

    public UnaryCallSettings<DeleteRegionSecurityPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetRegionSecurityPolicyRequest, SecurityPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetRuleRegionSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertRegionSecurityPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchRegionSecurityPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchRuleRegionSecurityPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public OperationCallSettings<PatchRuleRegionSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
        return this.patchRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveRuleRegionSecurityPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public OperationCallSettings<RemoveRuleRegionSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
        return this.removeRuleOperationSettings;
    }

    public RegionSecurityPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionSecurityPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionSecurityPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionSecurityPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionSecurityPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.addRuleOperationSettings = settingsBuilder.addRuleOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.patchRuleOperationSettings = settingsBuilder.patchRuleOperationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.removeRuleOperationSettings = settingsBuilder.removeRuleOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionSecurityPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddRuleRegionSecurityPolicyRequest, Operation> addRuleSettings;
        private final OperationCallSettings.Builder<AddRuleRegionSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegionSecurityPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionSecurityPolicyRequest, SecurityPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetRuleRegionSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertRegionSecurityPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchRegionSecurityPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchRuleRegionSecurityPolicyRequest, Operation> patchRuleSettings;
        private final OperationCallSettings.Builder<PatchRuleRegionSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleRegionSecurityPolicyRequest, Operation> removeRuleSettings;
        private final OperationCallSettings.Builder<RemoveRuleRegionSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSettings, this.deleteSettings, this.getSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.patchSettings, this.patchRuleSettings, this.removeRuleSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionSecurityPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.addRuleOperationSettings = settings.addRuleOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.patchRuleOperationSettings = settings.patchRuleOperationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.removeRuleOperationSettings = settings.removeRuleOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSettings, this.deleteSettings, this.getSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.patchSettings, this.patchRuleSettings, this.removeRuleSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionSecurityPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionSecurityPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionSecurityPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionSecurityPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddRuleRegionSecurityPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public OperationCallSettings.Builder<AddRuleRegionSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
            return this.addRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionSecurityPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionSecurityPolicyRequest, SecurityPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetRuleRegionSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionSecurityPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionSecurityPoliciesRequest, SecurityPolicyList, RegionSecurityPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionSecurityPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleRegionSecurityPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public OperationCallSettings.Builder<PatchRuleRegionSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
            return this.patchRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleRegionSecurityPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public OperationCallSettings.Builder<RemoveRuleRegionSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
            return this.removeRuleOperationSettings;
        }

        public RegionSecurityPoliciesStubSettings build() throws IOException {
            return new RegionSecurityPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

