/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.GetResourcePolicyRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchResourcePolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ResourcePoliciesClient;
import com.google.cloud.compute.v1.ResourcePoliciesScopedList;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonResourcePoliciesStub;
import com.google.cloud.compute.v1.stub.ResourcePoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class ResourcePoliciesStubSettings
extends StubSettings<ResourcePoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteResourcePolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteResourcePolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetResourcePolicyRequest, ResourcePolicy> getSettings;
    private final UnaryCallSettings<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertResourcePolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertResourcePolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchResourcePolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchResourcePolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListResourcePoliciesRequest injectToken(AggregatedListResourcePoliciesRequest payload, String token) {
            return AggregatedListResourcePoliciesRequest.newBuilder((AggregatedListResourcePoliciesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListResourcePoliciesRequest injectPageSize(AggregatedListResourcePoliciesRequest payload, int pageSize) {
            return AggregatedListResourcePoliciesRequest.newBuilder((AggregatedListResourcePoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListResourcePoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ResourcePolicyAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, ResourcePoliciesScopedList>> extractResources(ResourcePolicyAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListResourcePoliciesRequest injectToken(ListResourcePoliciesRequest payload, String token) {
            return ListResourcePoliciesRequest.newBuilder((ListResourcePoliciesRequest)payload).setPageToken(token).build();
        }

        public ListResourcePoliciesRequest injectPageSize(ListResourcePoliciesRequest payload, int pageSize) {
            return ListResourcePoliciesRequest.newBuilder((ListResourcePoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListResourcePoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ResourcePolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourcePolicy> extractResources(ResourcePolicyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse>(){

        public ApiFuture<ResourcePoliciesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList> callable, AggregatedListResourcePoliciesRequest request, ApiCallContext context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ResourcePoliciesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse>(){

        public ApiFuture<ResourcePoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourcePoliciesRequest, ResourcePolicyList> callable, ListResourcePoliciesRequest request, ApiCallContext context, ApiFuture<ResourcePolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ResourcePoliciesClient.ListPagedResponse.createAsync((PageContext<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteResourcePolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteResourcePolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetResourcePolicyRequest, ResourcePolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertResourcePolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertResourcePolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchResourcePolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchResourcePolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ResourcePoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonResourcePoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ResourcePoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ResourcePoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ResourcePoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ResourcePoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteResourcePolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteResourcePolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetResourcePolicyRequest, ResourcePolicy> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertResourcePolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertResourcePolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchResourcePolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchResourcePolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ResourcePoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ResourcePoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ResourcePoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ResourcePoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ResourcePoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, ResourcePoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteResourcePolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteResourcePolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetResourcePolicyRequest, ResourcePolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertResourcePolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertResourcePolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchResourcePolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchResourcePolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ResourcePoliciesStubSettings build() throws IOException {
            return new ResourcePoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

