/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.CloneRulesRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListRegionNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.RegionNetworkFirewallPoliciesSettings;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.RemoveAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.RegionNetworkFirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionNetworkFirewallPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionNetworkFirewallPoliciesClient
implements BackgroundResource {
    private final RegionNetworkFirewallPoliciesSettings settings;
    private final RegionNetworkFirewallPoliciesStub stub;

    public static final RegionNetworkFirewallPoliciesClient create() throws IOException {
        return RegionNetworkFirewallPoliciesClient.create(RegionNetworkFirewallPoliciesSettings.newBuilder().build());
    }

    public static final RegionNetworkFirewallPoliciesClient create(RegionNetworkFirewallPoliciesSettings settings) throws IOException {
        return new RegionNetworkFirewallPoliciesClient(settings);
    }

    public static final RegionNetworkFirewallPoliciesClient create(RegionNetworkFirewallPoliciesStub stub) {
        return new RegionNetworkFirewallPoliciesClient(stub);
    }

    protected RegionNetworkFirewallPoliciesClient(RegionNetworkFirewallPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionNetworkFirewallPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionNetworkFirewallPoliciesClient(RegionNetworkFirewallPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionNetworkFirewallPoliciesSettings getSettings() {
        return this.settings;
    }

    public RegionNetworkFirewallPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(String project, String region, String firewallPolicy, FirewallPolicyAssociation firewallPolicyAssociationResource) {
        AddAssociationRegionNetworkFirewallPolicyRequest request = AddAssociationRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).setFirewallPolicyAssociationResource(firewallPolicyAssociationResource).build();
        return this.addAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> addAssociationAsync(AddAssociationRegionNetworkFirewallPolicyRequest request) {
        return this.addAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationCallable() {
        return this.stub.addAssociationOperationCallable();
    }

    public final UnaryCallable<AddAssociationRegionNetworkFirewallPolicyRequest, Operation> addAssociationCallable() {
        return this.stub.addAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(String project, String region, String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        AddRuleRegionNetworkFirewallPolicyRequest request = AddRuleRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.addRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(AddRuleRegionNetworkFirewallPolicyRequest request) {
        return this.addRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.stub.addRuleOperationCallable();
    }

    public final UnaryCallable<AddRuleRegionNetworkFirewallPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final OperationFuture<Operation, Operation> cloneRulesAsync(String project, String region, String firewallPolicy) {
        CloneRulesRegionNetworkFirewallPolicyRequest request = CloneRulesRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.cloneRulesAsync(request);
    }

    public final OperationFuture<Operation, Operation> cloneRulesAsync(CloneRulesRegionNetworkFirewallPolicyRequest request) {
        return this.cloneRulesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CloneRulesRegionNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationCallable() {
        return this.stub.cloneRulesOperationCallable();
    }

    public final UnaryCallable<CloneRulesRegionNetworkFirewallPolicyRequest, Operation> cloneRulesCallable() {
        return this.stub.cloneRulesCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String firewallPolicy) {
        DeleteRegionNetworkFirewallPolicyRequest request = DeleteRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionNetworkFirewallPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionNetworkFirewallPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final FirewallPolicy get(String project, String region, String firewallPolicy) {
        GetRegionNetworkFirewallPolicyRequest request = GetRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.get(request);
    }

    public final FirewallPolicy get(GetRegionNetworkFirewallPolicyRequest request) {
        return (FirewallPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionNetworkFirewallPolicyRequest, FirewallPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final FirewallPolicyAssociation getAssociation(String project, String region, String firewallPolicy) {
        GetAssociationRegionNetworkFirewallPolicyRequest request = GetAssociationRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.getAssociation(request);
    }

    public final FirewallPolicyAssociation getAssociation(GetAssociationRegionNetworkFirewallPolicyRequest request) {
        return (FirewallPolicyAssociation)this.getAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssociationRegionNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationCallable() {
        return this.stub.getAssociationCallable();
    }

    public final RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse getEffectiveFirewalls(String project, String region, String network) {
        GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest request = GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setNetwork(network).build();
        return this.getEffectiveFirewalls(request);
    }

    public final RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse getEffectiveFirewalls(GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest request) {
        return (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse)this.getEffectiveFirewallsCallable().call((Object)request);
    }

    public final UnaryCallable<GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest, RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse> getEffectiveFirewallsCallable() {
        return this.stub.getEffectiveFirewallsCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyRegionNetworkFirewallPolicyRequest request = GetIamPolicyRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRegionNetworkFirewallPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final FirewallPolicyRule getRule(String project, String region, String firewallPolicy) {
        GetRuleRegionNetworkFirewallPolicyRequest request = GetRuleRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.getRule(request);
    }

    public final FirewallPolicyRule getRule(GetRuleRegionNetworkFirewallPolicyRequest request) {
        return (FirewallPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleRegionNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, FirewallPolicy firewallPolicyResource) {
        InsertRegionNetworkFirewallPolicyRequest request = InsertRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicyResource(firewallPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionNetworkFirewallPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionNetworkFirewallPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionNetworkFirewallPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionNetworkFirewallPoliciesRequest request = ListRegionNetworkFirewallPoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionNetworkFirewallPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionNetworkFirewallPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String firewallPolicy, FirewallPolicy firewallPolicyResource) {
        PatchRegionNetworkFirewallPolicyRequest request = PatchRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).setFirewallPolicyResource(firewallPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionNetworkFirewallPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionNetworkFirewallPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionNetworkFirewallPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(String project, String region, String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        PatchRuleRegionNetworkFirewallPolicyRequest request = PatchRuleRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.patchRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(PatchRuleRegionNetworkFirewallPolicyRequest request) {
        return this.patchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.stub.patchRuleOperationCallable();
    }

    public final UnaryCallable<PatchRuleRegionNetworkFirewallPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(String project, String region, String firewallPolicy) {
        RemoveAssociationRegionNetworkFirewallPolicyRequest request = RemoveAssociationRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.removeAssociationAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeAssociationAsync(RemoveAssociationRegionNetworkFirewallPolicyRequest request) {
        return this.removeAssociationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationCallable() {
        return this.stub.removeAssociationOperationCallable();
    }

    public final UnaryCallable<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation> removeAssociationCallable() {
        return this.stub.removeAssociationCallable();
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(String project, String region, String firewallPolicy) {
        RemoveRuleRegionNetworkFirewallPolicyRequest request = RemoveRuleRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setFirewallPolicy(firewallPolicy).build();
        return this.removeRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(RemoveRuleRegionNetworkFirewallPolicyRequest request) {
        return this.removeRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.stub.removeRuleOperationCallable();
    }

    public final UnaryCallable<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyRegionNetworkFirewallPolicyRequest request = SetIamPolicyRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRegionNetworkFirewallPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionNetworkFirewallPolicyRequest request = TestIamPermissionsRegionNetworkFirewallPolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsRegionNetworkFirewallPolicyRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRegionNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage> {
        private ListPage(PageContext<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

