/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceRequest;
import com.google.cloud.compute.v1.GetTargetInstanceRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceRequest;
import com.google.cloud.compute.v1.ListTargetInstancesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetSecurityPolicyTargetInstanceRequest;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.TargetInstancesClient;
import com.google.cloud.compute.v1.TargetInstancesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetInstancesStub;
import com.google.cloud.compute.v1.stub.TargetInstancesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetInstancesStubSettings
extends StubSettings<TargetInstancesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteTargetInstanceRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteTargetInstanceRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetTargetInstanceRequest, TargetInstance> getSettings;
    private final UnaryCallSettings<InsertTargetInstanceRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertTargetInstanceRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<SetSecurityPolicyTargetInstanceRequest, Operation> setSecurityPolicySettings;
    private final OperationCallSettings<SetSecurityPolicyTargetInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
    private static final PagedListDescriptor<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetInstancesRequest injectToken(AggregatedListTargetInstancesRequest payload, String token) {
            return AggregatedListTargetInstancesRequest.newBuilder((AggregatedListTargetInstancesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListTargetInstancesRequest injectPageSize(AggregatedListTargetInstancesRequest payload, int pageSize) {
            return AggregatedListTargetInstancesRequest.newBuilder((AggregatedListTargetInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetInstanceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, TargetInstancesScopedList>> extractResources(TargetInstanceAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListTargetInstancesRequest, TargetInstanceList, TargetInstance> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetInstancesRequest, TargetInstanceList, TargetInstance>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetInstancesRequest injectToken(ListTargetInstancesRequest payload, String token) {
            return ListTargetInstancesRequest.newBuilder((ListTargetInstancesRequest)payload).setPageToken(token).build();
        }

        public ListTargetInstancesRequest injectPageSize(ListTargetInstancesRequest payload, int pageSize) {
            return ListTargetInstancesRequest.newBuilder((ListTargetInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetInstanceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetInstance> extractResources(TargetInstanceList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse>(){

        public ApiFuture<TargetInstancesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList> callable, AggregatedListTargetInstancesRequest request, ApiCallContext context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetInstancesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse>(){

        public ApiFuture<TargetInstancesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetInstancesRequest, TargetInstanceList> callable, ListTargetInstancesRequest request, ApiCallContext context, ApiFuture<TargetInstanceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetInstancesClient.ListPagedResponse.createAsync((PageContext<ListTargetInstancesRequest, TargetInstanceList, TargetInstance>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteTargetInstanceRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteTargetInstanceRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetTargetInstanceRequest, TargetInstance> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertTargetInstanceRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertTargetInstanceRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<SetSecurityPolicyTargetInstanceRequest, Operation> setSecurityPolicySettings() {
        return this.setSecurityPolicySettings;
    }

    public OperationCallSettings<SetSecurityPolicyTargetInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
        return this.setSecurityPolicyOperationSettings;
    }

    public TargetInstancesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetInstancesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return TargetInstancesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetInstancesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetInstancesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetInstancesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.setSecurityPolicySettings = settingsBuilder.setSecurityPolicySettings().build();
        this.setSecurityPolicyOperationSettings = settingsBuilder.setSecurityPolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetInstancesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteTargetInstanceRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteTargetInstanceRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetTargetInstanceRequest, TargetInstance> getSettings;
        private final UnaryCallSettings.Builder<InsertTargetInstanceRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertTargetInstanceRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<SetSecurityPolicyTargetInstanceRequest, Operation> setSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetSecurityPolicyTargetInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.setSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setSecurityPolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(TargetInstancesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.setSecurityPolicySettings = settings.setSecurityPolicySettings.toBuilder();
            this.setSecurityPolicyOperationSettings = settings.setSecurityPolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setSecurityPolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetInstancesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetInstancesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetInstancesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TargetInstancesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, TargetInstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetInstanceRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTargetInstanceRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTargetInstanceRequest, TargetInstance> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetInstanceRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertTargetInstanceRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetInstancesRequest, TargetInstanceList, TargetInstancesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<SetSecurityPolicyTargetInstanceRequest, Operation> setSecurityPolicySettings() {
            return this.setSecurityPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetSecurityPolicyTargetInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
            return this.setSecurityPolicyOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return TargetInstancesStubSettings.getDefaultEndpoint();
        }

        public TargetInstancesStubSettings build() throws IOException {
            return new TargetInstancesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

