/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.AggregatedListDisksRequest;
import com.google.cloud.compute.v1.BulkInsertDiskRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskRequest;
import com.google.cloud.compute.v1.DeleteDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.DisksClient;
import com.google.cloud.compute.v1.DisksScopedList;
import com.google.cloud.compute.v1.GetDiskRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.InsertDiskRequest;
import com.google.cloud.compute.v1.ListDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.ResizeDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.SetLabelsDiskRequest;
import com.google.cloud.compute.v1.StartAsyncReplicationDiskRequest;
import com.google.cloud.compute.v1.StopAsyncReplicationDiskRequest;
import com.google.cloud.compute.v1.StopGroupAsyncReplicationDiskRequest;
import com.google.cloud.compute.v1.TestIamPermissionsDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateDiskRequest;
import com.google.cloud.compute.v1.stub.DisksStub;
import com.google.cloud.compute.v1.stub.HttpJsonDisksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class DisksStubSettings
extends StubSettings<DisksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings;
    private final OperationCallSettings<AddResourcePoliciesDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings;
    private final PagedCallSettings<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<BulkInsertDiskRequest, Operation> bulkInsertSettings;
    private final OperationCallSettings<BulkInsertDiskRequest, Operation, Operation> bulkInsertOperationSettings;
    private final UnaryCallSettings<CreateSnapshotDiskRequest, Operation> createSnapshotSettings;
    private final OperationCallSettings<CreateSnapshotDiskRequest, Operation, Operation> createSnapshotOperationSettings;
    private final UnaryCallSettings<DeleteDiskRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteDiskRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetDiskRequest, Disk> getSettings;
    private final UnaryCallSettings<GetIamPolicyDiskRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertDiskRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertDiskRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings;
    private final OperationCallSettings<RemoveResourcePoliciesDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
    private final UnaryCallSettings<ResizeDiskRequest, Operation> resizeSettings;
    private final OperationCallSettings<ResizeDiskRequest, Operation, Operation> resizeOperationSettings;
    private final UnaryCallSettings<SetIamPolicyDiskRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsDiskRequest, Operation> setLabelsSettings;
    private final OperationCallSettings<SetLabelsDiskRequest, Operation, Operation> setLabelsOperationSettings;
    private final UnaryCallSettings<StartAsyncReplicationDiskRequest, Operation> startAsyncReplicationSettings;
    private final OperationCallSettings<StartAsyncReplicationDiskRequest, Operation, Operation> startAsyncReplicationOperationSettings;
    private final UnaryCallSettings<StopAsyncReplicationDiskRequest, Operation> stopAsyncReplicationSettings;
    private final OperationCallSettings<StopAsyncReplicationDiskRequest, Operation, Operation> stopAsyncReplicationOperationSettings;
    private final UnaryCallSettings<StopGroupAsyncReplicationDiskRequest, Operation> stopGroupAsyncReplicationSettings;
    private final OperationCallSettings<StopGroupAsyncReplicationDiskRequest, Operation, Operation> stopGroupAsyncReplicationOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateDiskRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateDiskRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListDisksRequest injectToken(AggregatedListDisksRequest payload, String token) {
            return AggregatedListDisksRequest.newBuilder((AggregatedListDisksRequest)payload).setPageToken(token).build();
        }

        public AggregatedListDisksRequest injectPageSize(AggregatedListDisksRequest payload, int pageSize) {
            return AggregatedListDisksRequest.newBuilder((AggregatedListDisksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListDisksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, DisksScopedList>> extractResources(DiskAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListDisksRequest, DiskList, Disk> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListDisksRequest, DiskList, Disk>(){

        public String emptyToken() {
            return "";
        }

        public ListDisksRequest injectToken(ListDisksRequest payload, String token) {
            return ListDisksRequest.newBuilder((ListDisksRequest)payload).setPageToken(token).build();
        }

        public ListDisksRequest injectPageSize(ListDisksRequest payload, int pageSize) {
            return ListDisksRequest.newBuilder((ListDisksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDisksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Disk> extractResources(DiskList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse>(){

        public ApiFuture<DisksClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListDisksRequest, DiskAggregatedList> callable, AggregatedListDisksRequest request, ApiCallContext context, ApiFuture<DiskAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DisksClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListDisksRequest, DiskList, DisksClient.ListPagedResponse>(){

        public ApiFuture<DisksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListDisksRequest, DiskList> callable, ListDisksRequest request, ApiCallContext context, ApiFuture<DiskList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DisksClient.ListPagedResponse.createAsync((PageContext<ListDisksRequest, DiskList, Disk>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings() {
        return this.addResourcePoliciesSettings;
    }

    public OperationCallSettings<AddResourcePoliciesDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
        return this.addResourcePoliciesOperationSettings;
    }

    public PagedCallSettings<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<BulkInsertDiskRequest, Operation> bulkInsertSettings() {
        return this.bulkInsertSettings;
    }

    public OperationCallSettings<BulkInsertDiskRequest, Operation, Operation> bulkInsertOperationSettings() {
        return this.bulkInsertOperationSettings;
    }

    public UnaryCallSettings<CreateSnapshotDiskRequest, Operation> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public OperationCallSettings<CreateSnapshotDiskRequest, Operation, Operation> createSnapshotOperationSettings() {
        return this.createSnapshotOperationSettings;
    }

    public UnaryCallSettings<DeleteDiskRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteDiskRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetDiskRequest, Disk> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyDiskRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertDiskRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertDiskRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings() {
        return this.removeResourcePoliciesSettings;
    }

    public OperationCallSettings<RemoveResourcePoliciesDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
        return this.removeResourcePoliciesOperationSettings;
    }

    public UnaryCallSettings<ResizeDiskRequest, Operation> resizeSettings() {
        return this.resizeSettings;
    }

    public OperationCallSettings<ResizeDiskRequest, Operation, Operation> resizeOperationSettings() {
        return this.resizeOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyDiskRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsDiskRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public OperationCallSettings<SetLabelsDiskRequest, Operation, Operation> setLabelsOperationSettings() {
        return this.setLabelsOperationSettings;
    }

    public UnaryCallSettings<StartAsyncReplicationDiskRequest, Operation> startAsyncReplicationSettings() {
        return this.startAsyncReplicationSettings;
    }

    public OperationCallSettings<StartAsyncReplicationDiskRequest, Operation, Operation> startAsyncReplicationOperationSettings() {
        return this.startAsyncReplicationOperationSettings;
    }

    public UnaryCallSettings<StopAsyncReplicationDiskRequest, Operation> stopAsyncReplicationSettings() {
        return this.stopAsyncReplicationSettings;
    }

    public OperationCallSettings<StopAsyncReplicationDiskRequest, Operation, Operation> stopAsyncReplicationOperationSettings() {
        return this.stopAsyncReplicationOperationSettings;
    }

    public UnaryCallSettings<StopGroupAsyncReplicationDiskRequest, Operation> stopGroupAsyncReplicationSettings() {
        return this.stopGroupAsyncReplicationSettings;
    }

    public OperationCallSettings<StopGroupAsyncReplicationDiskRequest, Operation, Operation> stopGroupAsyncReplicationOperationSettings() {
        return this.stopGroupAsyncReplicationOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateDiskRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateDiskRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public DisksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDisksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return DisksStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DisksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DisksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DisksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addResourcePoliciesSettings = settingsBuilder.addResourcePoliciesSettings().build();
        this.addResourcePoliciesOperationSettings = settingsBuilder.addResourcePoliciesOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.bulkInsertSettings = settingsBuilder.bulkInsertSettings().build();
        this.bulkInsertOperationSettings = settingsBuilder.bulkInsertOperationSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.createSnapshotOperationSettings = settingsBuilder.createSnapshotOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.removeResourcePoliciesSettings = settingsBuilder.removeResourcePoliciesSettings().build();
        this.removeResourcePoliciesOperationSettings = settingsBuilder.removeResourcePoliciesOperationSettings().build();
        this.resizeSettings = settingsBuilder.resizeSettings().build();
        this.resizeOperationSettings = settingsBuilder.resizeOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLabelsOperationSettings = settingsBuilder.setLabelsOperationSettings().build();
        this.startAsyncReplicationSettings = settingsBuilder.startAsyncReplicationSettings().build();
        this.startAsyncReplicationOperationSettings = settingsBuilder.startAsyncReplicationOperationSettings().build();
        this.stopAsyncReplicationSettings = settingsBuilder.stopAsyncReplicationSettings().build();
        this.stopAsyncReplicationOperationSettings = settingsBuilder.stopAsyncReplicationOperationSettings().build();
        this.stopGroupAsyncReplicationSettings = settingsBuilder.stopGroupAsyncReplicationSettings().build();
        this.stopGroupAsyncReplicationOperationSettings = settingsBuilder.stopGroupAsyncReplicationOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DisksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings;
        private final OperationCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<BulkInsertDiskRequest, Operation> bulkInsertSettings;
        private final OperationCallSettings.Builder<BulkInsertDiskRequest, Operation, Operation> bulkInsertOperationSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotDiskRequest, Operation> createSnapshotSettings;
        private final OperationCallSettings.Builder<CreateSnapshotDiskRequest, Operation, Operation> createSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDiskRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteDiskRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetDiskRequest, Disk> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyDiskRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertDiskRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertDiskRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings;
        private final OperationCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
        private final UnaryCallSettings.Builder<ResizeDiskRequest, Operation> resizeSettings;
        private final OperationCallSettings.Builder<ResizeDiskRequest, Operation, Operation> resizeOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyDiskRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsDiskRequest, Operation> setLabelsSettings;
        private final OperationCallSettings.Builder<SetLabelsDiskRequest, Operation, Operation> setLabelsOperationSettings;
        private final UnaryCallSettings.Builder<StartAsyncReplicationDiskRequest, Operation> startAsyncReplicationSettings;
        private final OperationCallSettings.Builder<StartAsyncReplicationDiskRequest, Operation, Operation> startAsyncReplicationOperationSettings;
        private final UnaryCallSettings.Builder<StopAsyncReplicationDiskRequest, Operation> stopAsyncReplicationSettings;
        private final OperationCallSettings.Builder<StopAsyncReplicationDiskRequest, Operation, Operation> stopAsyncReplicationOperationSettings;
        private final UnaryCallSettings.Builder<StopGroupAsyncReplicationDiskRequest, Operation> stopGroupAsyncReplicationSettings;
        private final OperationCallSettings.Builder<StopGroupAsyncReplicationDiskRequest, Operation, Operation> stopGroupAsyncReplicationOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateDiskRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateDiskRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.bulkInsertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.bulkInsertOperationSettings = OperationCallSettings.newBuilder();
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.removeResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.resizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.startAsyncReplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startAsyncReplicationOperationSettings = OperationCallSettings.newBuilder();
            this.stopAsyncReplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopAsyncReplicationOperationSettings = OperationCallSettings.newBuilder();
            this.stopGroupAsyncReplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopGroupAsyncReplicationOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.aggregatedListSettings, this.bulkInsertSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.setLabelsSettings, this.startAsyncReplicationSettings, this.stopAsyncReplicationSettings, this.stopGroupAsyncReplicationSettings, this.testIamPermissionsSettings, this.updateSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DisksStubSettings settings) {
            super((StubSettings)settings);
            this.addResourcePoliciesSettings = settings.addResourcePoliciesSettings.toBuilder();
            this.addResourcePoliciesOperationSettings = settings.addResourcePoliciesOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.bulkInsertSettings = settings.bulkInsertSettings.toBuilder();
            this.bulkInsertOperationSettings = settings.bulkInsertOperationSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.createSnapshotOperationSettings = settings.createSnapshotOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.removeResourcePoliciesSettings = settings.removeResourcePoliciesSettings.toBuilder();
            this.removeResourcePoliciesOperationSettings = settings.removeResourcePoliciesOperationSettings.toBuilder();
            this.resizeSettings = settings.resizeSettings.toBuilder();
            this.resizeOperationSettings = settings.resizeOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLabelsOperationSettings = settings.setLabelsOperationSettings.toBuilder();
            this.startAsyncReplicationSettings = settings.startAsyncReplicationSettings.toBuilder();
            this.startAsyncReplicationOperationSettings = settings.startAsyncReplicationOperationSettings.toBuilder();
            this.stopAsyncReplicationSettings = settings.stopAsyncReplicationSettings.toBuilder();
            this.stopAsyncReplicationOperationSettings = settings.stopAsyncReplicationOperationSettings.toBuilder();
            this.stopGroupAsyncReplicationSettings = settings.stopGroupAsyncReplicationSettings.toBuilder();
            this.stopGroupAsyncReplicationOperationSettings = settings.stopGroupAsyncReplicationOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.aggregatedListSettings, this.bulkInsertSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.setLabelsSettings, this.startAsyncReplicationSettings, this.stopAsyncReplicationSettings, this.stopGroupAsyncReplicationSettings, this.testIamPermissionsSettings, this.updateSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DisksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DisksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DisksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DisksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.bulkInsertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.removeResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startAsyncReplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopAsyncReplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopGroupAsyncReplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.bulkInsertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.createSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resizeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.startAsyncReplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.stopAsyncReplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.stopGroupAsyncReplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings() {
            return this.addResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
            return this.addResourcePoliciesOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<BulkInsertDiskRequest, Operation> bulkInsertSettings() {
            return this.bulkInsertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BulkInsertDiskRequest, Operation, Operation> bulkInsertOperationSettings() {
            return this.bulkInsertOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotDiskRequest, Operation> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSnapshotDiskRequest, Operation, Operation> createSnapshotOperationSettings() {
            return this.createSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDiskRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDiskRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDiskRequest, Disk> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyDiskRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertDiskRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertDiskRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings() {
            return this.removeResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
            return this.removeResourcePoliciesOperationSettings;
        }

        public UnaryCallSettings.Builder<ResizeDiskRequest, Operation> resizeSettings() {
            return this.resizeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResizeDiskRequest, Operation, Operation> resizeOperationSettings() {
            return this.resizeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyDiskRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsDiskRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetLabelsDiskRequest, Operation, Operation> setLabelsOperationSettings() {
            return this.setLabelsOperationSettings;
        }

        public UnaryCallSettings.Builder<StartAsyncReplicationDiskRequest, Operation> startAsyncReplicationSettings() {
            return this.startAsyncReplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartAsyncReplicationDiskRequest, Operation, Operation> startAsyncReplicationOperationSettings() {
            return this.startAsyncReplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<StopAsyncReplicationDiskRequest, Operation> stopAsyncReplicationSettings() {
            return this.stopAsyncReplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopAsyncReplicationDiskRequest, Operation, Operation> stopAsyncReplicationOperationSettings() {
            return this.stopAsyncReplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<StopGroupAsyncReplicationDiskRequest, Operation> stopGroupAsyncReplicationSettings() {
            return this.stopGroupAsyncReplicationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopGroupAsyncReplicationDiskRequest, Operation, Operation> stopGroupAsyncReplicationOperationSettings() {
            return this.stopGroupAsyncReplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateDiskRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDiskRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return DisksStubSettings.getDefaultEndpoint();
        }

        public DisksStubSettings build() throws IOException {
            return new DisksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

