/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionInstanceTemplateRequest;
import com.google.cloud.compute.v1.GetRegionInstanceTemplateRequest;
import com.google.cloud.compute.v1.InsertRegionInstanceTemplateRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplateList;
import com.google.cloud.compute.v1.ListRegionInstanceTemplatesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstanceTemplatesSettings;
import com.google.cloud.compute.v1.stub.RegionInstanceTemplatesStub;
import com.google.cloud.compute.v1.stub.RegionInstanceTemplatesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionInstanceTemplatesClient
implements BackgroundResource {
    private final RegionInstanceTemplatesSettings settings;
    private final RegionInstanceTemplatesStub stub;

    public static final RegionInstanceTemplatesClient create() throws IOException {
        return RegionInstanceTemplatesClient.create(RegionInstanceTemplatesSettings.newBuilder().build());
    }

    public static final RegionInstanceTemplatesClient create(RegionInstanceTemplatesSettings settings) throws IOException {
        return new RegionInstanceTemplatesClient(settings);
    }

    public static final RegionInstanceTemplatesClient create(RegionInstanceTemplatesStub stub) {
        return new RegionInstanceTemplatesClient(stub);
    }

    protected RegionInstanceTemplatesClient(RegionInstanceTemplatesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstanceTemplatesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionInstanceTemplatesClient(RegionInstanceTemplatesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstanceTemplatesSettings getSettings() {
        return this.settings;
    }

    public RegionInstanceTemplatesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String instanceTemplate) {
        DeleteRegionInstanceTemplateRequest request = DeleteRegionInstanceTemplateRequest.newBuilder().setProject(project).setRegion(region).setInstanceTemplate(instanceTemplate).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionInstanceTemplateRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionInstanceTemplateRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionInstanceTemplateRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstanceTemplate get(String project, String region, String instanceTemplate) {
        GetRegionInstanceTemplateRequest request = GetRegionInstanceTemplateRequest.newBuilder().setProject(project).setRegion(region).setInstanceTemplate(instanceTemplate).build();
        return this.get(request);
    }

    public final InstanceTemplate get(GetRegionInstanceTemplateRequest request) {
        return (InstanceTemplate)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionInstanceTemplateRequest, InstanceTemplate> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, InstanceTemplate instanceTemplateResource) {
        InsertRegionInstanceTemplateRequest request = InsertRegionInstanceTemplateRequest.newBuilder().setProject(project).setRegion(region).setInstanceTemplateResource(instanceTemplateResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionInstanceTemplateRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionInstanceTemplateRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionInstanceTemplateRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionInstanceTemplatesRequest request = ListRegionInstanceTemplatesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionInstanceTemplatesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionInstanceTemplatesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionInstanceTemplatesRequest, InstanceTemplateList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage> {
        private ListPage(PageContext<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

