/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionInstanceGroupRequest;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.ListInstancesRegionInstanceGroupsRequest;
import com.google.cloud.compute.v1.ListRegionInstanceGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstanceGroupList;
import com.google.cloud.compute.v1.RegionInstanceGroupsClient;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstances;
import com.google.cloud.compute.v1.SetNamedPortsRegionInstanceGroupRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionInstanceGroupsStub;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionInstanceGroupsStubSettings
extends StubSettings<RegionInstanceGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetRegionInstanceGroupRequest, InstanceGroup> getSettings;
    private final PagedCallSettings<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<SetNamedPortsRegionInstanceGroupRequest, Operation> setNamedPortsSettings;
    private final OperationCallSettings<SetNamedPortsRegionInstanceGroupRequest, Operation, Operation> setNamedPortsOperationSettings;
    private static final PagedListDescriptor<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionInstanceGroupsRequest injectToken(ListRegionInstanceGroupsRequest payload, String token) {
            return ListRegionInstanceGroupsRequest.newBuilder((ListRegionInstanceGroupsRequest)payload).setPageToken(token).build();
        }

        public ListRegionInstanceGroupsRequest injectPageSize(ListRegionInstanceGroupsRequest payload, int pageSize) {
            return ListRegionInstanceGroupsRequest.newBuilder((ListRegionInstanceGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionInstanceGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroup> extractResources(RegionInstanceGroupList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRegionInstanceGroupsRequest injectToken(ListInstancesRegionInstanceGroupsRequest payload, String token) {
            return ListInstancesRegionInstanceGroupsRequest.newBuilder((ListInstancesRegionInstanceGroupsRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRegionInstanceGroupsRequest injectPageSize(ListInstancesRegionInstanceGroupsRequest payload, int pageSize) {
            return ListInstancesRegionInstanceGroupsRequest.newBuilder((ListInstancesRegionInstanceGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRegionInstanceGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupsListInstances payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceWithNamedPorts> extractResources(RegionInstanceGroupsListInstances payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse>(){

        public ApiFuture<RegionInstanceGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionInstanceGroupsRequest, RegionInstanceGroupList> callable, ListRegionInstanceGroupsRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupsClient.ListPagedResponse.createAsync((PageContext<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, InstanceGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse>(){

        public ApiFuture<RegionInstanceGroupsClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances> callable, ListInstancesRegionInstanceGroupsRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupsListInstances> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupsClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, InstanceWithNamedPorts>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetRegionInstanceGroupRequest, InstanceGroup> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<SetNamedPortsRegionInstanceGroupRequest, Operation> setNamedPortsSettings() {
        return this.setNamedPortsSettings;
    }

    public OperationCallSettings<SetNamedPortsRegionInstanceGroupRequest, Operation, Operation> setNamedPortsOperationSettings() {
        return this.setNamedPortsOperationSettings;
    }

    public RegionInstanceGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionInstanceGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RegionInstanceGroupsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionInstanceGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionInstanceGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionInstanceGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.setNamedPortsSettings = settingsBuilder.setNamedPortsSettings().build();
        this.setNamedPortsOperationSettings = settingsBuilder.setNamedPortsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionInstanceGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetRegionInstanceGroupRequest, InstanceGroup> getSettings;
        private final PagedCallSettings.Builder<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<SetNamedPortsRegionInstanceGroupRequest, Operation> setNamedPortsSettings;
        private final OperationCallSettings.Builder<SetNamedPortsRegionInstanceGroupRequest, Operation, Operation> setNamedPortsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.setNamedPortsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNamedPortsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings, this.listInstancesSettings, this.setNamedPortsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionInstanceGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.setNamedPortsSettings = settings.setNamedPortsSettings.toBuilder();
            this.setNamedPortsOperationSettings = settings.setNamedPortsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings, this.listInstancesSettings, this.setNamedPortsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionInstanceGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionInstanceGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionInstanceGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionInstanceGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNamedPortsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNamedPortsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetRegionInstanceGroupRequest, InstanceGroup> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListRegionInstanceGroupsRequest, RegionInstanceGroupList, RegionInstanceGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRegionInstanceGroupsRequest, RegionInstanceGroupsListInstances, RegionInstanceGroupsClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<SetNamedPortsRegionInstanceGroupRequest, Operation> setNamedPortsSettings() {
            return this.setNamedPortsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetNamedPortsRegionInstanceGroupRequest, Operation, Operation> setNamedPortsOperationSettings() {
            return this.setNamedPortsOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RegionInstanceGroupsStubSettings.getDefaultEndpoint();
        }

        public RegionInstanceGroupsStubSettings build() throws IOException {
            return new RegionInstanceGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

