/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddHealthCheckTargetPoolRequest;
import com.google.cloud.compute.v1.AddInstanceTargetPoolRequest;
import com.google.cloud.compute.v1.AggregatedListTargetPoolsRequest;
import com.google.cloud.compute.v1.DeleteTargetPoolRequest;
import com.google.cloud.compute.v1.GetHealthTargetPoolRequest;
import com.google.cloud.compute.v1.GetTargetPoolRequest;
import com.google.cloud.compute.v1.InsertTargetPoolRequest;
import com.google.cloud.compute.v1.ListTargetPoolsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RemoveHealthCheckTargetPoolRequest;
import com.google.cloud.compute.v1.RemoveInstanceTargetPoolRequest;
import com.google.cloud.compute.v1.SetBackupTargetPoolRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyTargetPoolRequest;
import com.google.cloud.compute.v1.TargetPool;
import com.google.cloud.compute.v1.TargetPoolAggregatedList;
import com.google.cloud.compute.v1.TargetPoolInstanceHealth;
import com.google.cloud.compute.v1.TargetPoolList;
import com.google.cloud.compute.v1.TargetPoolsClient;
import com.google.cloud.compute.v1.TargetPoolsScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetPoolsStub;
import com.google.cloud.compute.v1.stub.TargetPoolsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetPoolsStubSettings
extends StubSettings<TargetPoolsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddHealthCheckTargetPoolRequest, Operation> addHealthCheckSettings;
    private final OperationCallSettings<AddHealthCheckTargetPoolRequest, Operation, Operation> addHealthCheckOperationSettings;
    private final UnaryCallSettings<AddInstanceTargetPoolRequest, Operation> addInstanceSettings;
    private final OperationCallSettings<AddInstanceTargetPoolRequest, Operation, Operation> addInstanceOperationSettings;
    private final PagedCallSettings<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteTargetPoolRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteTargetPoolRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetTargetPoolRequest, TargetPool> getSettings;
    private final UnaryCallSettings<GetHealthTargetPoolRequest, TargetPoolInstanceHealth> getHealthSettings;
    private final UnaryCallSettings<InsertTargetPoolRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertTargetPoolRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<RemoveHealthCheckTargetPoolRequest, Operation> removeHealthCheckSettings;
    private final OperationCallSettings<RemoveHealthCheckTargetPoolRequest, Operation, Operation> removeHealthCheckOperationSettings;
    private final UnaryCallSettings<RemoveInstanceTargetPoolRequest, Operation> removeInstanceSettings;
    private final OperationCallSettings<RemoveInstanceTargetPoolRequest, Operation, Operation> removeInstanceOperationSettings;
    private final UnaryCallSettings<SetBackupTargetPoolRequest, Operation> setBackupSettings;
    private final OperationCallSettings<SetBackupTargetPoolRequest, Operation, Operation> setBackupOperationSettings;
    private final UnaryCallSettings<SetSecurityPolicyTargetPoolRequest, Operation> setSecurityPolicySettings;
    private final OperationCallSettings<SetSecurityPolicyTargetPoolRequest, Operation, Operation> setSecurityPolicyOperationSettings;
    private static final PagedListDescriptor<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListTargetPoolsRequest injectToken(AggregatedListTargetPoolsRequest payload, String token) {
            return AggregatedListTargetPoolsRequest.newBuilder((AggregatedListTargetPoolsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListTargetPoolsRequest injectPageSize(AggregatedListTargetPoolsRequest payload, int pageSize) {
            return AggregatedListTargetPoolsRequest.newBuilder((AggregatedListTargetPoolsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListTargetPoolsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetPoolAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, TargetPoolsScopedList>> extractResources(TargetPoolAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListTargetPoolsRequest, TargetPoolList, TargetPool> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetPoolsRequest, TargetPoolList, TargetPool>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetPoolsRequest injectToken(ListTargetPoolsRequest payload, String token) {
            return ListTargetPoolsRequest.newBuilder((ListTargetPoolsRequest)payload).setPageToken(token).build();
        }

        public ListTargetPoolsRequest injectPageSize(ListTargetPoolsRequest payload, int pageSize) {
            return ListTargetPoolsRequest.newBuilder((ListTargetPoolsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetPoolsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetPoolList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetPool> extractResources(TargetPoolList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse>(){

        public ApiFuture<TargetPoolsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList> callable, AggregatedListTargetPoolsRequest request, ApiCallContext context, ApiFuture<TargetPoolAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetPoolsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, Map.Entry<String, TargetPoolsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse>(){

        public ApiFuture<TargetPoolsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetPoolsRequest, TargetPoolList> callable, ListTargetPoolsRequest request, ApiCallContext context, ApiFuture<TargetPoolList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetPoolsClient.ListPagedResponse.createAsync((PageContext<ListTargetPoolsRequest, TargetPoolList, TargetPool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddHealthCheckTargetPoolRequest, Operation> addHealthCheckSettings() {
        return this.addHealthCheckSettings;
    }

    public OperationCallSettings<AddHealthCheckTargetPoolRequest, Operation, Operation> addHealthCheckOperationSettings() {
        return this.addHealthCheckOperationSettings;
    }

    public UnaryCallSettings<AddInstanceTargetPoolRequest, Operation> addInstanceSettings() {
        return this.addInstanceSettings;
    }

    public OperationCallSettings<AddInstanceTargetPoolRequest, Operation, Operation> addInstanceOperationSettings() {
        return this.addInstanceOperationSettings;
    }

    public PagedCallSettings<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteTargetPoolRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteTargetPoolRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetTargetPoolRequest, TargetPool> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetHealthTargetPoolRequest, TargetPoolInstanceHealth> getHealthSettings() {
        return this.getHealthSettings;
    }

    public UnaryCallSettings<InsertTargetPoolRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertTargetPoolRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<RemoveHealthCheckTargetPoolRequest, Operation> removeHealthCheckSettings() {
        return this.removeHealthCheckSettings;
    }

    public OperationCallSettings<RemoveHealthCheckTargetPoolRequest, Operation, Operation> removeHealthCheckOperationSettings() {
        return this.removeHealthCheckOperationSettings;
    }

    public UnaryCallSettings<RemoveInstanceTargetPoolRequest, Operation> removeInstanceSettings() {
        return this.removeInstanceSettings;
    }

    public OperationCallSettings<RemoveInstanceTargetPoolRequest, Operation, Operation> removeInstanceOperationSettings() {
        return this.removeInstanceOperationSettings;
    }

    public UnaryCallSettings<SetBackupTargetPoolRequest, Operation> setBackupSettings() {
        return this.setBackupSettings;
    }

    public OperationCallSettings<SetBackupTargetPoolRequest, Operation, Operation> setBackupOperationSettings() {
        return this.setBackupOperationSettings;
    }

    public UnaryCallSettings<SetSecurityPolicyTargetPoolRequest, Operation> setSecurityPolicySettings() {
        return this.setSecurityPolicySettings;
    }

    public OperationCallSettings<SetSecurityPolicyTargetPoolRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
        return this.setSecurityPolicyOperationSettings;
    }

    public TargetPoolsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetPoolsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetPoolsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetPoolsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetPoolsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addHealthCheckSettings = settingsBuilder.addHealthCheckSettings().build();
        this.addHealthCheckOperationSettings = settingsBuilder.addHealthCheckOperationSettings().build();
        this.addInstanceSettings = settingsBuilder.addInstanceSettings().build();
        this.addInstanceOperationSettings = settingsBuilder.addInstanceOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getHealthSettings = settingsBuilder.getHealthSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.removeHealthCheckSettings = settingsBuilder.removeHealthCheckSettings().build();
        this.removeHealthCheckOperationSettings = settingsBuilder.removeHealthCheckOperationSettings().build();
        this.removeInstanceSettings = settingsBuilder.removeInstanceSettings().build();
        this.removeInstanceOperationSettings = settingsBuilder.removeInstanceOperationSettings().build();
        this.setBackupSettings = settingsBuilder.setBackupSettings().build();
        this.setBackupOperationSettings = settingsBuilder.setBackupOperationSettings().build();
        this.setSecurityPolicySettings = settingsBuilder.setSecurityPolicySettings().build();
        this.setSecurityPolicyOperationSettings = settingsBuilder.setSecurityPolicyOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetPoolsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddHealthCheckTargetPoolRequest, Operation> addHealthCheckSettings;
        private final OperationCallSettings.Builder<AddHealthCheckTargetPoolRequest, Operation, Operation> addHealthCheckOperationSettings;
        private final UnaryCallSettings.Builder<AddInstanceTargetPoolRequest, Operation> addInstanceSettings;
        private final OperationCallSettings.Builder<AddInstanceTargetPoolRequest, Operation, Operation> addInstanceOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteTargetPoolRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteTargetPoolRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetTargetPoolRequest, TargetPool> getSettings;
        private final UnaryCallSettings.Builder<GetHealthTargetPoolRequest, TargetPoolInstanceHealth> getHealthSettings;
        private final UnaryCallSettings.Builder<InsertTargetPoolRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertTargetPoolRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<RemoveHealthCheckTargetPoolRequest, Operation> removeHealthCheckSettings;
        private final OperationCallSettings.Builder<RemoveHealthCheckTargetPoolRequest, Operation, Operation> removeHealthCheckOperationSettings;
        private final UnaryCallSettings.Builder<RemoveInstanceTargetPoolRequest, Operation> removeInstanceSettings;
        private final OperationCallSettings.Builder<RemoveInstanceTargetPoolRequest, Operation, Operation> removeInstanceOperationSettings;
        private final UnaryCallSettings.Builder<SetBackupTargetPoolRequest, Operation> setBackupSettings;
        private final OperationCallSettings.Builder<SetBackupTargetPoolRequest, Operation, Operation> setBackupOperationSettings;
        private final UnaryCallSettings.Builder<SetSecurityPolicyTargetPoolRequest, Operation> setSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetSecurityPolicyTargetPoolRequest, Operation, Operation> setSecurityPolicyOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addHealthCheckOperationSettings = OperationCallSettings.newBuilder();
            this.addInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.removeHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeHealthCheckOperationSettings = OperationCallSettings.newBuilder();
            this.removeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.setBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setBackupOperationSettings = OperationCallSettings.newBuilder();
            this.setSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addHealthCheckSettings, this.addInstanceSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getHealthSettings, this.insertSettings, this.listSettings, this.removeHealthCheckSettings, this.removeInstanceSettings, this.setBackupSettings, this.setSecurityPolicySettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(TargetPoolsStubSettings settings) {
            super((StubSettings)settings);
            this.addHealthCheckSettings = settings.addHealthCheckSettings.toBuilder();
            this.addHealthCheckOperationSettings = settings.addHealthCheckOperationSettings.toBuilder();
            this.addInstanceSettings = settings.addInstanceSettings.toBuilder();
            this.addInstanceOperationSettings = settings.addInstanceOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getHealthSettings = settings.getHealthSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.removeHealthCheckSettings = settings.removeHealthCheckSettings.toBuilder();
            this.removeHealthCheckOperationSettings = settings.removeHealthCheckOperationSettings.toBuilder();
            this.removeInstanceSettings = settings.removeInstanceSettings.toBuilder();
            this.removeInstanceOperationSettings = settings.removeInstanceOperationSettings.toBuilder();
            this.setBackupSettings = settings.setBackupSettings.toBuilder();
            this.setBackupOperationSettings = settings.setBackupOperationSettings.toBuilder();
            this.setSecurityPolicySettings = settings.setSecurityPolicySettings.toBuilder();
            this.setSecurityPolicyOperationSettings = settings.setSecurityPolicyOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addHealthCheckSettings, this.addInstanceSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getHealthSettings, this.insertSettings, this.listSettings, this.removeHealthCheckSettings, this.removeInstanceSettings, this.setBackupSettings, this.setSecurityPolicySettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetPoolsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetPoolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetPoolsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetPoolsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TargetPoolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getHealthSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.removeHealthCheckSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addHealthCheckOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.addInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeHealthCheckOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddHealthCheckTargetPoolRequest, Operation> addHealthCheckSettings() {
            return this.addHealthCheckSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddHealthCheckTargetPoolRequest, Operation, Operation> addHealthCheckOperationSettings() {
            return this.addHealthCheckOperationSettings;
        }

        public UnaryCallSettings.Builder<AddInstanceTargetPoolRequest, Operation> addInstanceSettings() {
            return this.addInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddInstanceTargetPoolRequest, Operation, Operation> addInstanceOperationSettings() {
            return this.addInstanceOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListTargetPoolsRequest, TargetPoolAggregatedList, TargetPoolsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetPoolRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTargetPoolRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetTargetPoolRequest, TargetPool> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetHealthTargetPoolRequest, TargetPoolInstanceHealth> getHealthSettings() {
            return this.getHealthSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetPoolRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertTargetPoolRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetPoolsRequest, TargetPoolList, TargetPoolsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<RemoveHealthCheckTargetPoolRequest, Operation> removeHealthCheckSettings() {
            return this.removeHealthCheckSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemoveHealthCheckTargetPoolRequest, Operation, Operation> removeHealthCheckOperationSettings() {
            return this.removeHealthCheckOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveInstanceTargetPoolRequest, Operation> removeInstanceSettings() {
            return this.removeInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemoveInstanceTargetPoolRequest, Operation, Operation> removeInstanceOperationSettings() {
            return this.removeInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<SetBackupTargetPoolRequest, Operation> setBackupSettings() {
            return this.setBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetBackupTargetPoolRequest, Operation, Operation> setBackupOperationSettings() {
            return this.setBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSecurityPolicyTargetPoolRequest, Operation> setSecurityPolicySettings() {
            return this.setSecurityPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetSecurityPolicyTargetPoolRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
            return this.setSecurityPolicyOperationSettings;
        }

        public TargetPoolsStubSettings build() throws IOException {
            return new TargetPoolsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

