/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.AggregatedListBackendServicesRequest;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceAggregatedList;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServiceListUsable;
import com.google.cloud.compute.v1.BackendServicesScopedList;
import com.google.cloud.compute.v1.BackendServicesSettings;
import com.google.cloud.compute.v1.DeleteBackendServiceRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.GetBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthBackendServiceRequest;
import com.google.cloud.compute.v1.GetIamPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertBackendServiceRequest;
import com.google.cloud.compute.v1.ListBackendServicesRequest;
import com.google.cloud.compute.v1.ListUsableBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendServiceRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetEdgeSecurityPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SetIamPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SignedUrlKey;
import com.google.cloud.compute.v1.TestIamPermissionsBackendServiceRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateBackendServiceRequest;
import com.google.cloud.compute.v1.stub.BackendServicesStub;
import com.google.cloud.compute.v1.stub.BackendServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackendServicesClient
implements BackgroundResource {
    private final BackendServicesSettings settings;
    private final BackendServicesStub stub;

    public static final BackendServicesClient create() throws IOException {
        return BackendServicesClient.create(BackendServicesSettings.newBuilder().build());
    }

    public static final BackendServicesClient create(BackendServicesSettings settings) throws IOException {
        return new BackendServicesClient(settings);
    }

    public static final BackendServicesClient create(BackendServicesStub stub) {
        return new BackendServicesClient(stub);
    }

    protected BackendServicesClient(BackendServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackendServicesStubSettings)settings.getStubSettings()).createStub();
    }

    protected BackendServicesClient(BackendServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BackendServicesSettings getSettings() {
        return this.settings;
    }

    public BackendServicesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addSignedUrlKeyAsync(String project, String backendService, SignedUrlKey signedUrlKeyResource) {
        AddSignedUrlKeyBackendServiceRequest request = AddSignedUrlKeyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setSignedUrlKeyResource(signedUrlKeyResource).build();
        return this.addSignedUrlKeyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> addSignedUrlKeyAsync(AddSignedUrlKeyBackendServiceRequest request) {
        return this.addSignedUrlKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddSignedUrlKeyBackendServiceRequest, Operation, Operation> addSignedUrlKeyOperationCallable() {
        return this.stub.addSignedUrlKeyOperationCallable();
    }

    public final UnaryCallable<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeyCallable() {
        return this.stub.addSignedUrlKeyCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListBackendServicesRequest request = AggregatedListBackendServicesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListBackendServicesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListBackendServicesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListBackendServicesRequest, BackendServiceAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String backendService) {
        DeleteBackendServiceRequest request = DeleteBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteBackendServiceRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackendServiceRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteBackendServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final OperationFuture<Operation, Operation> deleteSignedUrlKeyAsync(String project, String backendService, String keyName) {
        DeleteSignedUrlKeyBackendServiceRequest request = DeleteSignedUrlKeyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setKeyName(keyName).build();
        return this.deleteSignedUrlKeyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteSignedUrlKeyAsync(DeleteSignedUrlKeyBackendServiceRequest request) {
        return this.deleteSignedUrlKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSignedUrlKeyBackendServiceRequest, Operation, Operation> deleteSignedUrlKeyOperationCallable() {
        return this.stub.deleteSignedUrlKeyOperationCallable();
    }

    public final UnaryCallable<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeyCallable() {
        return this.stub.deleteSignedUrlKeyCallable();
    }

    public final BackendService get(String project, String backendService) {
        GetBackendServiceRequest request = GetBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).build();
        return this.get(request);
    }

    public final BackendService get(GetBackendServiceRequest request) {
        return (BackendService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackendServiceRequest, BackendService> getCallable() {
        return this.stub.getCallable();
    }

    public final BackendServiceGroupHealth getHealth(String project, String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthBackendServiceRequest request = GetHealthBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealth(request);
    }

    public final BackendServiceGroupHealth getHealth(GetHealthBackendServiceRequest request) {
        return (BackendServiceGroupHealth)this.getHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthCallable() {
        return this.stub.getHealthCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyBackendServiceRequest request = GetIamPolicyBackendServiceRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyBackendServiceRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyBackendServiceRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, BackendService backendServiceResource) {
        InsertBackendServiceRequest request = InsertBackendServiceRequest.newBuilder().setProject(project).setBackendServiceResource(backendServiceResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertBackendServiceRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertBackendServiceRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertBackendServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListBackendServicesRequest request = ListBackendServicesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListBackendServicesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackendServicesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListBackendServicesRequest, BackendServiceList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListUsablePagedResponse listUsable(String project) {
        ListUsableBackendServicesRequest request = ListUsableBackendServicesRequest.newBuilder().setProject(project).build();
        return this.listUsable(request);
    }

    public final ListUsablePagedResponse listUsable(ListUsableBackendServicesRequest request) {
        return (ListUsablePagedResponse)((Object)this.listUsablePagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableBackendServicesRequest, ListUsablePagedResponse> listUsablePagedCallable() {
        return this.stub.listUsablePagedCallable();
    }

    public final UnaryCallable<ListUsableBackendServicesRequest, BackendServiceListUsable> listUsableCallable() {
        return this.stub.listUsableCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String backendService, BackendService backendServiceResource) {
        PatchBackendServiceRequest request = PatchBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchBackendServiceRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchBackendServiceRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchBackendServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> setEdgeSecurityPolicyAsync(String project, String backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetEdgeSecurityPolicyBackendServiceRequest request = SetEdgeSecurityPolicyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setEdgeSecurityPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setEdgeSecurityPolicyAsync(SetEdgeSecurityPolicyBackendServiceRequest request) {
        return this.setEdgeSecurityPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetEdgeSecurityPolicyBackendServiceRequest, Operation, Operation> setEdgeSecurityPolicyOperationCallable() {
        return this.stub.setEdgeSecurityPolicyOperationCallable();
    }

    public final UnaryCallable<SetEdgeSecurityPolicyBackendServiceRequest, Operation> setEdgeSecurityPolicyCallable() {
        return this.stub.setEdgeSecurityPolicyCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyBackendServiceRequest request = SetIamPolicyBackendServiceRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyBackendServiceRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyBackendServiceRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(String project, String backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyBackendServiceRequest request = SetSecurityPolicyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(SetSecurityPolicyBackendServiceRequest request) {
        return this.setSecurityPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetSecurityPolicyBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationCallable() {
        return this.stub.setSecurityPolicyOperationCallable();
    }

    public final UnaryCallable<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicyCallable() {
        return this.stub.setSecurityPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsBackendServiceRequest request = TestIamPermissionsBackendServiceRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsBackendServiceRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsBackendServiceRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String backendService, BackendService backendServiceResource) {
        UpdateBackendServiceRequest request = UpdateBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateBackendServiceRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackendServiceRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateBackendServiceRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage, ListUsableFixedSizeCollection> {
        private ListUsableFixedSizeCollection(List<ListUsablePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableFixedSizeCollection createEmptyCollection() {
            return new ListUsableFixedSizeCollection(null, 0);
        }

        protected ListUsableFixedSizeCollection createCollection(List<ListUsablePage> pages, int collectionSize) {
            return new ListUsableFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsablePage
    extends AbstractPage<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage> {
        private ListUsablePage(PageContext<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService> context, BackendServiceListUsable response) {
            super(context, (Object)response);
        }

        private static ListUsablePage createEmptyPage() {
            return new ListUsablePage(null, null);
        }

        protected ListUsablePage createPage(PageContext<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService> context, BackendServiceListUsable response) {
            return new ListUsablePage(context, response);
        }

        public ApiFuture<ListUsablePage> createPageAsync(PageContext<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService> context, ApiFuture<BackendServiceListUsable> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsablePagedResponse
    extends AbstractPagedListResponse<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage, ListUsableFixedSizeCollection> {
        public static ApiFuture<ListUsablePagedResponse> createAsync(PageContext<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService> context, ApiFuture<BackendServiceListUsable> futureResponse) {
            ApiFuture<ListUsablePage> futurePage = ListUsablePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsablePagedResponse((ListUsablePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsablePagedResponse(ListUsablePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage> {
        private ListPage(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, BackendServiceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, BackendServiceAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

