/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetSslProxyRequest;
import com.google.cloud.compute.v1.GetTargetSslProxyRequest;
import com.google.cloud.compute.v1.InsertTargetSslProxyRequest;
import com.google.cloud.compute.v1.ListTargetSslProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetCertificateMapTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetSslProxyRequest;
import com.google.cloud.compute.v1.SslPolicyReference;
import com.google.cloud.compute.v1.TargetSslProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetCertificateMapRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSettings;
import com.google.cloud.compute.v1.TargetSslProxy;
import com.google.cloud.compute.v1.TargetSslProxyList;
import com.google.cloud.compute.v1.stub.TargetSslProxiesStub;
import com.google.cloud.compute.v1.stub.TargetSslProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetSslProxiesClient
implements BackgroundResource {
    private final TargetSslProxiesSettings settings;
    private final TargetSslProxiesStub stub;

    public static final TargetSslProxiesClient create() throws IOException {
        return TargetSslProxiesClient.create(TargetSslProxiesSettings.newBuilder().build());
    }

    public static final TargetSslProxiesClient create(TargetSslProxiesSettings settings) throws IOException {
        return new TargetSslProxiesClient(settings);
    }

    public static final TargetSslProxiesClient create(TargetSslProxiesStub stub) {
        return new TargetSslProxiesClient(stub);
    }

    protected TargetSslProxiesClient(TargetSslProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetSslProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    protected TargetSslProxiesClient(TargetSslProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetSslProxiesSettings getSettings() {
        return this.settings;
    }

    public TargetSslProxiesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String targetSslProxy) {
        DeleteTargetSslProxyRequest request = DeleteTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteTargetSslProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetSslProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetSslProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetSslProxy get(String project, String targetSslProxy) {
        GetTargetSslProxyRequest request = GetTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).build();
        return this.get(request);
    }

    public final TargetSslProxy get(GetTargetSslProxyRequest request) {
        return (TargetSslProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetSslProxyRequest, TargetSslProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, TargetSslProxy targetSslProxyResource) {
        InsertTargetSslProxyRequest request = InsertTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxyResource(targetSslProxyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertTargetSslProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertTargetSslProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertTargetSslProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetSslProxiesRequest request = ListTargetSslProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetSslProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetSslProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetSslProxiesRequest, TargetSslProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> setBackendServiceAsync(String project, String targetSslProxy, TargetSslProxiesSetBackendServiceRequest targetSslProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetSslProxyRequest request = SetBackendServiceTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetBackendServiceRequestResource(targetSslProxiesSetBackendServiceRequestResource).build();
        return this.setBackendServiceAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setBackendServiceAsync(SetBackendServiceTargetSslProxyRequest request) {
        return this.setBackendServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetBackendServiceTargetSslProxyRequest, Operation, Operation> setBackendServiceOperationCallable() {
        return this.stub.setBackendServiceOperationCallable();
    }

    public final UnaryCallable<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceCallable() {
        return this.stub.setBackendServiceCallable();
    }

    public final OperationFuture<Operation, Operation> setCertificateMapAsync(String project, String targetSslProxy, TargetSslProxiesSetCertificateMapRequest targetSslProxiesSetCertificateMapRequestResource) {
        SetCertificateMapTargetSslProxyRequest request = SetCertificateMapTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetCertificateMapRequestResource(targetSslProxiesSetCertificateMapRequestResource).build();
        return this.setCertificateMapAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setCertificateMapAsync(SetCertificateMapTargetSslProxyRequest request) {
        return this.setCertificateMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetCertificateMapTargetSslProxyRequest, Operation, Operation> setCertificateMapOperationCallable() {
        return this.stub.setCertificateMapOperationCallable();
    }

    public final UnaryCallable<SetCertificateMapTargetSslProxyRequest, Operation> setCertificateMapCallable() {
        return this.stub.setCertificateMapCallable();
    }

    public final OperationFuture<Operation, Operation> setProxyHeaderAsync(String project, String targetSslProxy, TargetSslProxiesSetProxyHeaderRequest targetSslProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetSslProxyRequest request = SetProxyHeaderTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetProxyHeaderRequestResource(targetSslProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeaderAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setProxyHeaderAsync(SetProxyHeaderTargetSslProxyRequest request) {
        return this.setProxyHeaderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetProxyHeaderTargetSslProxyRequest, Operation, Operation> setProxyHeaderOperationCallable() {
        return this.stub.setProxyHeaderOperationCallable();
    }

    public final UnaryCallable<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderCallable() {
        return this.stub.setProxyHeaderCallable();
    }

    public final OperationFuture<Operation, Operation> setSslCertificatesAsync(String project, String targetSslProxy, TargetSslProxiesSetSslCertificatesRequest targetSslProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetSslProxyRequest request = SetSslCertificatesTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetSslCertificatesRequestResource(targetSslProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setSslCertificatesAsync(SetSslCertificatesTargetSslProxyRequest request) {
        return this.setSslCertificatesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetSslCertificatesTargetSslProxyRequest, Operation, Operation> setSslCertificatesOperationCallable() {
        return this.stub.setSslCertificatesOperationCallable();
    }

    public final UnaryCallable<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesCallable() {
        return this.stub.setSslCertificatesCallable();
    }

    public final OperationFuture<Operation, Operation> setSslPolicyAsync(String project, String targetSslProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetSslProxyRequest request = SetSslPolicyTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setSslPolicyAsync(SetSslPolicyTargetSslProxyRequest request) {
        return this.setSslPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetSslPolicyTargetSslProxyRequest, Operation, Operation> setSslPolicyOperationCallable() {
        return this.stub.setSslPolicyOperationCallable();
    }

    public final UnaryCallable<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicyCallable() {
        return this.stub.setSslPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage> {
        private ListPage(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

