/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetTcpProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetTcpProxyRequest;
import com.google.cloud.compute.v1.TargetTcpProxiesClient;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonTargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.TargetTcpProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TargetTcpProxiesStubSettings
extends StubSettings<TargetTcpProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteTargetTcpProxyRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetTargetTcpProxyRequest, TargetTcpProxy> getSettings;
    private final UnaryCallSettings<InsertTargetTcpProxyRequest, Operation> insertSettings;
    private final PagedCallSettings<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceSettings;
    private final UnaryCallSettings<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderSettings;
    private static final PagedListDescriptor<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetTcpProxiesRequest injectToken(ListTargetTcpProxiesRequest payload, String token) {
            return ListTargetTcpProxiesRequest.newBuilder((ListTargetTcpProxiesRequest)payload).setPageToken(token).build();
        }

        public ListTargetTcpProxiesRequest injectPageSize(ListTargetTcpProxiesRequest payload, int pageSize) {
            return ListTargetTcpProxiesRequest.newBuilder((ListTargetTcpProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListTargetTcpProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetTcpProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetTcpProxy> extractResources(TargetTcpProxyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse>(){

        public ApiFuture<TargetTcpProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetTcpProxiesRequest, TargetTcpProxyList> callable, ListTargetTcpProxiesRequest request, ApiCallContext context, ApiFuture<TargetTcpProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TargetTcpProxiesClient.ListPagedResponse.createAsync((PageContext<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteTargetTcpProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetTargetTcpProxyRequest, TargetTcpProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertTargetTcpProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceSettings() {
        return this.setBackendServiceSettings;
    }

    public UnaryCallSettings<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderSettings() {
        return this.setProxyHeaderSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetTcpProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTargetTcpProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TargetTcpProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TargetTcpProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TargetTcpProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.setBackendServiceSettings = settingsBuilder.setBackendServiceSettings().build();
        this.setProxyHeaderSettings = settingsBuilder.setProxyHeaderSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TargetTcpProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteTargetTcpProxyRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetTargetTcpProxyRequest, TargetTcpProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertTargetTcpProxyRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceSettings;
        private final UnaryCallSettings.Builder<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.setBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setProxyHeaderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setBackendServiceSettings, this.setProxyHeaderSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TargetTcpProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.setBackendServiceSettings = settings.setBackendServiceSettings.toBuilder();
            this.setProxyHeaderSettings = settings.setProxyHeaderSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.setBackendServiceSettings, this.setProxyHeaderSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TargetTcpProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TargetTcpProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TargetTcpProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TargetTcpProxiesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TargetTcpProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setProxyHeaderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteTargetTcpProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetTargetTcpProxyRequest, TargetTcpProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertTargetTcpProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<SetBackendServiceTargetTcpProxyRequest, Operation> setBackendServiceSettings() {
            return this.setBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<SetProxyHeaderTargetTcpProxyRequest, Operation> setProxyHeaderSettings() {
            return this.setProxyHeaderSettings;
        }

        public TargetTcpProxiesStubSettings build() throws IOException {
            return new TargetTcpProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

