/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListHealthChecksRequest;
import com.google.cloud.compute.v1.DeleteHealthCheckRequest;
import com.google.cloud.compute.v1.GetHealthCheckRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.HealthChecksAggregatedList;
import com.google.cloud.compute.v1.HealthChecksScopedList;
import com.google.cloud.compute.v1.HealthChecksSettings;
import com.google.cloud.compute.v1.InsertHealthCheckRequest;
import com.google.cloud.compute.v1.ListHealthChecksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHealthCheckRequest;
import com.google.cloud.compute.v1.UpdateHealthCheckRequest;
import com.google.cloud.compute.v1.stub.HealthChecksStub;
import com.google.cloud.compute.v1.stub.HealthChecksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HealthChecksClient
implements BackgroundResource {
    private final HealthChecksSettings settings;
    private final HealthChecksStub stub;

    public static final HealthChecksClient create() throws IOException {
        return HealthChecksClient.create(HealthChecksSettings.newBuilder().build());
    }

    public static final HealthChecksClient create(HealthChecksSettings settings) throws IOException {
        return new HealthChecksClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final HealthChecksClient create(HealthChecksStub stub) {
        return new HealthChecksClient(stub);
    }

    protected HealthChecksClient(HealthChecksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HealthChecksStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected HealthChecksClient(HealthChecksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HealthChecksSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HealthChecksStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListHealthChecksRequest request = AggregatedListHealthChecksRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListHealthChecksRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListHealthChecksRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListHealthChecksRequest, HealthChecksAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String healthCheck) {
        DeleteHealthCheckRequest request = DeleteHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteHealthCheckRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteHealthCheckRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final HealthCheck get(String project, String healthCheck) {
        GetHealthCheckRequest request = GetHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).build();
        return this.get(request);
    }

    public final HealthCheck get(GetHealthCheckRequest request) {
        return (HealthCheck)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthCheckRequest, HealthCheck> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, HealthCheck healthCheckResource) {
        InsertHealthCheckRequest request = InsertHealthCheckRequest.newBuilder().setProject(project).setHealthCheckResource(healthCheckResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertHealthCheckRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertHealthCheckRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListHealthChecksRequest request = ListHealthChecksRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListHealthChecksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHealthChecksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListHealthChecksRequest, HealthCheckList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String healthCheck, HealthCheck healthCheckResource) {
        PatchHealthCheckRequest request = PatchHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchHealthCheckRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchHealthCheckRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String healthCheck, HealthCheck healthCheckResource) {
        UpdateHealthCheckRequest request = UpdateHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateHealthCheckRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateHealthCheckRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage> {
        private ListPage(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, HealthChecksAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, HealthChecksAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, ApiFuture<HealthChecksAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, ApiFuture<HealthChecksAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

