/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListForwardingRulesRequest;
import com.google.cloud.compute.v1.DeleteForwardingRuleRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleAggregatedList;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.ForwardingRulesScopedList;
import com.google.cloud.compute.v1.ForwardingRulesSettings;
import com.google.cloud.compute.v1.GetForwardingRuleRequest;
import com.google.cloud.compute.v1.InsertForwardingRuleRequest;
import com.google.cloud.compute.v1.ListForwardingRulesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchForwardingRuleRequest;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.SetLabelsForwardingRuleRequest;
import com.google.cloud.compute.v1.SetTargetForwardingRuleRequest;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.ForwardingRulesStub;
import com.google.cloud.compute.v1.stub.ForwardingRulesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ForwardingRulesClient
implements BackgroundResource {
    private final ForwardingRulesSettings settings;
    private final ForwardingRulesStub stub;

    public static final ForwardingRulesClient create() throws IOException {
        return ForwardingRulesClient.create(ForwardingRulesSettings.newBuilder().build());
    }

    public static final ForwardingRulesClient create(ForwardingRulesSettings settings) throws IOException {
        return new ForwardingRulesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ForwardingRulesClient create(ForwardingRulesStub stub) {
        return new ForwardingRulesClient(stub);
    }

    protected ForwardingRulesClient(ForwardingRulesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ForwardingRulesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ForwardingRulesClient(ForwardingRulesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ForwardingRulesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ForwardingRulesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListForwardingRulesRequest request = AggregatedListForwardingRulesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListForwardingRulesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListForwardingRulesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String forwardingRule) {
        DeleteForwardingRuleRequest request = DeleteForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setForwardingRule(forwardingRule).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteForwardingRuleRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteForwardingRuleRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ForwardingRule get(String project, String region, String forwardingRule) {
        GetForwardingRuleRequest request = GetForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setForwardingRule(forwardingRule).build();
        return this.get(request);
    }

    public final ForwardingRule get(GetForwardingRuleRequest request) {
        return (ForwardingRule)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetForwardingRuleRequest, ForwardingRule> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, ForwardingRule forwardingRuleResource) {
        InsertForwardingRuleRequest request = InsertForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertForwardingRuleRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertForwardingRuleRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListForwardingRulesRequest request = ListForwardingRulesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListForwardingRulesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListForwardingRulesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListForwardingRulesRequest, ForwardingRuleList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String forwardingRule, ForwardingRule forwardingRuleResource) {
        PatchForwardingRuleRequest request = PatchForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setForwardingRule(forwardingRule).setForwardingRuleResource(forwardingRuleResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchForwardingRuleRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchForwardingRuleRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation setLabels(String project, String region, String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsForwardingRuleRequest request = SetLabelsForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsForwardingRuleRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsForwardingRuleRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final Operation setTarget(String project, String region, String forwardingRule, TargetReference targetReferenceResource) {
        SetTargetForwardingRuleRequest request = SetTargetForwardingRuleRequest.newBuilder().setProject(project).setRegion(region).setForwardingRule(forwardingRule).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTarget(request);
    }

    public final Operation setTarget(SetTargetForwardingRuleRequest request) {
        return (Operation)this.setTargetCallable().call((Object)request);
    }

    public final UnaryCallable<SetTargetForwardingRuleRequest, Operation> setTargetCallable() {
        return this.stub.setTargetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage> {
        private ListPage(PageContext<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>> context, ForwardingRuleAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>> context, ForwardingRuleAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>> context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListForwardingRulesRequest, ForwardingRuleAggregatedList, Map.Entry<String, ForwardingRulesScopedList>> context, ApiFuture<ForwardingRuleAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

