/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteFirewallRequest;
import com.google.cloud.compute.v1.Firewall;
import com.google.cloud.compute.v1.FirewallList;
import com.google.cloud.compute.v1.FirewallsSettings;
import com.google.cloud.compute.v1.GetFirewallRequest;
import com.google.cloud.compute.v1.InsertFirewallRequest;
import com.google.cloud.compute.v1.ListFirewallsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallRequest;
import com.google.cloud.compute.v1.UpdateFirewallRequest;
import com.google.cloud.compute.v1.stub.FirewallsStub;
import com.google.cloud.compute.v1.stub.FirewallsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirewallsClient
implements BackgroundResource {
    private final FirewallsSettings settings;
    private final FirewallsStub stub;

    public static final FirewallsClient create() throws IOException {
        return FirewallsClient.create(FirewallsSettings.newBuilder().build());
    }

    public static final FirewallsClient create(FirewallsSettings settings) throws IOException {
        return new FirewallsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FirewallsClient create(FirewallsStub stub) {
        return new FirewallsClient(stub);
    }

    protected FirewallsClient(FirewallsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirewallsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FirewallsClient(FirewallsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirewallsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirewallsStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String firewall) {
        DeleteFirewallRequest request = DeleteFirewallRequest.newBuilder().setProject(project).setFirewall(firewall).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteFirewallRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFirewallRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Firewall get(String project, String firewall) {
        GetFirewallRequest request = GetFirewallRequest.newBuilder().setProject(project).setFirewall(firewall).build();
        return this.get(request);
    }

    public final Firewall get(GetFirewallRequest request) {
        return (Firewall)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetFirewallRequest, Firewall> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, Firewall firewallResource) {
        InsertFirewallRequest request = InsertFirewallRequest.newBuilder().setProject(project).setFirewallResource(firewallResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertFirewallRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertFirewallRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListFirewallsRequest request = ListFirewallsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListFirewallsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFirewallsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListFirewallsRequest, FirewallList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String firewall, Firewall firewallResource) {
        PatchFirewallRequest request = PatchFirewallRequest.newBuilder().setProject(project).setFirewall(firewall).setFirewallResource(firewallResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchFirewallRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchFirewallRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String firewall, Firewall firewallResource) {
        UpdateFirewallRequest request = UpdateFirewallRequest.newBuilder().setProject(project).setFirewall(firewall).setFirewallResource(firewallResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateFirewallRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFirewallRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFirewallsRequest, FirewallList, Firewall, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListFirewallsRequest, FirewallList, Firewall, ListPage> {
        private ListPage(PageContext<ListFirewallsRequest, FirewallList, Firewall> context, FirewallList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListFirewallsRequest, FirewallList, Firewall> context, FirewallList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListFirewallsRequest, FirewallList, Firewall> context, ApiFuture<FirewallList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListFirewallsRequest, FirewallList, Firewall, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListFirewallsRequest, FirewallList, Firewall> context, ApiFuture<FirewallList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

