/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.DeleteRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetRegionBackendServiceRequest;
import com.google.cloud.compute.v1.InsertRegionBackendServiceRequest;
import com.google.cloud.compute.v1.ListRegionBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionBackendServiceRequest;
import com.google.cloud.compute.v1.RegionBackendServicesClient;
import com.google.cloud.compute.v1.UpdateRegionBackendServiceRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionBackendServicesStub;
import com.google.cloud.compute.v1.stub.RegionBackendServicesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionBackendServicesStubSettings
extends StubSettings<RegionBackendServicesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteRegionBackendServiceRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetRegionBackendServiceRequest, BackendService> getSettings;
    private final UnaryCallSettings<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings;
    private final UnaryCallSettings<InsertRegionBackendServiceRequest, Operation> insertSettings;
    private final PagedCallSettings<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchRegionBackendServiceRequest, Operation> patchSettings;
    private final UnaryCallSettings<UpdateRegionBackendServiceRequest, Operation> updateSettings;
    private static final PagedListDescriptor<ListRegionBackendServicesRequest, BackendServiceList, BackendService> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionBackendServicesRequest, BackendServiceList, BackendService>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionBackendServicesRequest injectToken(ListRegionBackendServicesRequest payload, String token) {
            return ListRegionBackendServicesRequest.newBuilder((ListRegionBackendServicesRequest)payload).setPageToken(token).build();
        }

        public ListRegionBackendServicesRequest injectPageSize(ListRegionBackendServicesRequest payload, int pageSize) {
            return ListRegionBackendServicesRequest.newBuilder((ListRegionBackendServicesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionBackendServicesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendService> extractResources(BackendServiceList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse>(){

        public ApiFuture<RegionBackendServicesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionBackendServicesRequest, BackendServiceList> callable, ListRegionBackendServicesRequest request, ApiCallContext context, ApiFuture<BackendServiceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionBackendServicesClient.ListPagedResponse.createAsync((PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionBackendServiceRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetRegionBackendServiceRequest, BackendService> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings() {
        return this.getHealthSettings;
    }

    public UnaryCallSettings<InsertRegionBackendServiceRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchRegionBackendServiceRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<UpdateRegionBackendServiceRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionBackendServicesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionBackendServicesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionBackendServicesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionBackendServicesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionBackendServicesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getHealthSettings = settingsBuilder.getHealthSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionBackendServicesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionBackendServiceRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetRegionBackendServiceRequest, BackendService> getSettings;
        private final UnaryCallSettings.Builder<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings;
        private final UnaryCallSettings.Builder<InsertRegionBackendServiceRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchRegionBackendServiceRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<UpdateRegionBackendServiceRequest, Operation> updateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.getHealthSettings, this.insertSettings, this.listSettings, this.patchSettings, this.updateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionBackendServicesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getHealthSettings = settings.getHealthSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.getHealthSettings, this.insertSettings, this.listSettings, this.patchSettings, this.updateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionBackendServicesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionBackendServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionBackendServicesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionBackendServicesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RegionBackendServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getHealthSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionBackendServiceRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetRegionBackendServiceRequest, BackendService> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings() {
            return this.getHealthSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionBackendServiceRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListRegionBackendServicesRequest, BackendServiceList, RegionBackendServicesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionBackendServiceRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionBackendServiceRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public RegionBackendServicesStubSettings build() throws IOException {
            return new RegionBackendServicesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

