/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.DiskMoveRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.GetProjectRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsRequest;
import com.google.cloud.compute.v1.InstanceMoveRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsRequest;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.MoveDiskProjectRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectsDisableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsEnableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.ProjectsListXpnHostsRequest;
import com.google.cloud.compute.v1.ProjectsSetDefaultNetworkTierRequest;
import com.google.cloud.compute.v1.ProjectsSettings;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectRequest;
import com.google.cloud.compute.v1.UsageExportLocation;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.XpnResourceId;
import com.google.cloud.compute.v1.stub.ProjectsStub;
import com.google.cloud.compute.v1.stub.ProjectsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ProjectsClient
implements BackgroundResource {
    private final ProjectsSettings settings;
    private final ProjectsStub stub;

    public static final ProjectsClient create() throws IOException {
        return ProjectsClient.create(ProjectsSettings.newBuilder().build());
    }

    public static final ProjectsClient create(ProjectsSettings settings) throws IOException {
        return new ProjectsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProjectsClient create(ProjectsStub stub) {
        return new ProjectsClient(stub);
    }

    protected ProjectsClient(ProjectsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProjectsClient(ProjectsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProjectsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectsStub getStub() {
        return this.stub;
    }

    public final Operation disableXpnHost(String project) {
        DisableXpnHostProjectRequest request = DisableXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.disableXpnHost(request);
    }

    public final Operation disableXpnHost(DisableXpnHostProjectRequest request) {
        return (Operation)this.disableXpnHostCallable().call((Object)request);
    }

    public final UnaryCallable<DisableXpnHostProjectRequest, Operation> disableXpnHostCallable() {
        return this.stub.disableXpnHostCallable();
    }

    public final Operation disableXpnResource(String project, ProjectsDisableXpnResourceRequest projectsDisableXpnResourceRequestResource) {
        DisableXpnResourceProjectRequest request = DisableXpnResourceProjectRequest.newBuilder().setProject(project).setProjectsDisableXpnResourceRequestResource(projectsDisableXpnResourceRequestResource).build();
        return this.disableXpnResource(request);
    }

    public final Operation disableXpnResource(DisableXpnResourceProjectRequest request) {
        return (Operation)this.disableXpnResourceCallable().call((Object)request);
    }

    public final UnaryCallable<DisableXpnResourceProjectRequest, Operation> disableXpnResourceCallable() {
        return this.stub.disableXpnResourceCallable();
    }

    public final Operation enableXpnHost(String project) {
        EnableXpnHostProjectRequest request = EnableXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.enableXpnHost(request);
    }

    public final Operation enableXpnHost(EnableXpnHostProjectRequest request) {
        return (Operation)this.enableXpnHostCallable().call((Object)request);
    }

    public final UnaryCallable<EnableXpnHostProjectRequest, Operation> enableXpnHostCallable() {
        return this.stub.enableXpnHostCallable();
    }

    public final Operation enableXpnResource(String project, ProjectsEnableXpnResourceRequest projectsEnableXpnResourceRequestResource) {
        EnableXpnResourceProjectRequest request = EnableXpnResourceProjectRequest.newBuilder().setProject(project).setProjectsEnableXpnResourceRequestResource(projectsEnableXpnResourceRequestResource).build();
        return this.enableXpnResource(request);
    }

    public final Operation enableXpnResource(EnableXpnResourceProjectRequest request) {
        return (Operation)this.enableXpnResourceCallable().call((Object)request);
    }

    public final UnaryCallable<EnableXpnResourceProjectRequest, Operation> enableXpnResourceCallable() {
        return this.stub.enableXpnResourceCallable();
    }

    public final Project get(String project) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setProject(project).build();
        return this.get(request);
    }

    public final Project get(GetProjectRequest request) {
        return (Project)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectRequest, Project> getCallable() {
        return this.stub.getCallable();
    }

    public final Project getXpnHost(String project) {
        GetXpnHostProjectRequest request = GetXpnHostProjectRequest.newBuilder().setProject(project).build();
        return this.getXpnHost(request);
    }

    public final Project getXpnHost(GetXpnHostProjectRequest request) {
        return (Project)this.getXpnHostCallable().call((Object)request);
    }

    public final UnaryCallable<GetXpnHostProjectRequest, Project> getXpnHostCallable() {
        return this.stub.getXpnHostCallable();
    }

    public final GetXpnResourcesPagedResponse getXpnResources(String project) {
        GetXpnResourcesProjectsRequest request = GetXpnResourcesProjectsRequest.newBuilder().setProject(project).build();
        return this.getXpnResources(request);
    }

    public final GetXpnResourcesPagedResponse getXpnResources(GetXpnResourcesProjectsRequest request) {
        return (GetXpnResourcesPagedResponse)((Object)this.getXpnResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GetXpnResourcesProjectsRequest, GetXpnResourcesPagedResponse> getXpnResourcesPagedCallable() {
        return this.stub.getXpnResourcesPagedCallable();
    }

    public final UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> getXpnResourcesCallable() {
        return this.stub.getXpnResourcesCallable();
    }

    public final ListXpnHostsPagedResponse listXpnHosts(String project, ProjectsListXpnHostsRequest projectsListXpnHostsRequestResource) {
        ListXpnHostsProjectsRequest request = ListXpnHostsProjectsRequest.newBuilder().setProject(project).setProjectsListXpnHostsRequestResource(projectsListXpnHostsRequestResource).build();
        return this.listXpnHosts(request);
    }

    public final ListXpnHostsPagedResponse listXpnHosts(ListXpnHostsProjectsRequest request) {
        return (ListXpnHostsPagedResponse)((Object)this.listXpnHostsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListXpnHostsProjectsRequest, ListXpnHostsPagedResponse> listXpnHostsPagedCallable() {
        return this.stub.listXpnHostsPagedCallable();
    }

    public final UnaryCallable<ListXpnHostsProjectsRequest, XpnHostList> listXpnHostsCallable() {
        return this.stub.listXpnHostsCallable();
    }

    public final Operation moveDisk(String project, DiskMoveRequest diskMoveRequestResource) {
        MoveDiskProjectRequest request = MoveDiskProjectRequest.newBuilder().setProject(project).setDiskMoveRequestResource(diskMoveRequestResource).build();
        return this.moveDisk(request);
    }

    public final Operation moveDisk(MoveDiskProjectRequest request) {
        return (Operation)this.moveDiskCallable().call((Object)request);
    }

    public final UnaryCallable<MoveDiskProjectRequest, Operation> moveDiskCallable() {
        return this.stub.moveDiskCallable();
    }

    public final Operation moveInstance(String project, InstanceMoveRequest instanceMoveRequestResource) {
        MoveInstanceProjectRequest request = MoveInstanceProjectRequest.newBuilder().setProject(project).setInstanceMoveRequestResource(instanceMoveRequestResource).build();
        return this.moveInstance(request);
    }

    public final Operation moveInstance(MoveInstanceProjectRequest request) {
        return (Operation)this.moveInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<MoveInstanceProjectRequest, Operation> moveInstanceCallable() {
        return this.stub.moveInstanceCallable();
    }

    public final Operation setCommonInstanceMetadata(String project, Metadata metadataResource) {
        SetCommonInstanceMetadataProjectRequest request = SetCommonInstanceMetadataProjectRequest.newBuilder().setProject(project).setMetadataResource(metadataResource).build();
        return this.setCommonInstanceMetadata(request);
    }

    public final Operation setCommonInstanceMetadata(SetCommonInstanceMetadataProjectRequest request) {
        return (Operation)this.setCommonInstanceMetadataCallable().call((Object)request);
    }

    public final UnaryCallable<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataCallable() {
        return this.stub.setCommonInstanceMetadataCallable();
    }

    public final Operation setDefaultNetworkTier(String project, ProjectsSetDefaultNetworkTierRequest projectsSetDefaultNetworkTierRequestResource) {
        SetDefaultNetworkTierProjectRequest request = SetDefaultNetworkTierProjectRequest.newBuilder().setProject(project).setProjectsSetDefaultNetworkTierRequestResource(projectsSetDefaultNetworkTierRequestResource).build();
        return this.setDefaultNetworkTier(request);
    }

    public final Operation setDefaultNetworkTier(SetDefaultNetworkTierProjectRequest request) {
        return (Operation)this.setDefaultNetworkTierCallable().call((Object)request);
    }

    public final UnaryCallable<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierCallable() {
        return this.stub.setDefaultNetworkTierCallable();
    }

    public final Operation setUsageExportBucket(String project, UsageExportLocation usageExportLocationResource) {
        SetUsageExportBucketProjectRequest request = SetUsageExportBucketProjectRequest.newBuilder().setProject(project).setUsageExportLocationResource(usageExportLocationResource).build();
        return this.setUsageExportBucket(request);
    }

    public final Operation setUsageExportBucket(SetUsageExportBucketProjectRequest request) {
        return (Operation)this.setUsageExportBucketCallable().call((Object)request);
    }

    public final UnaryCallable<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketCallable() {
        return this.stub.setUsageExportBucketCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListXpnHostsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage, ListXpnHostsFixedSizeCollection> {
        private ListXpnHostsFixedSizeCollection(List<ListXpnHostsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListXpnHostsFixedSizeCollection createEmptyCollection() {
            return new ListXpnHostsFixedSizeCollection(null, 0);
        }

        protected ListXpnHostsFixedSizeCollection createCollection(List<ListXpnHostsPage> pages, int collectionSize) {
            return new ListXpnHostsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListXpnHostsPage
    extends AbstractPage<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage> {
        private ListXpnHostsPage(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, XpnHostList response) {
            super(context, (Object)response);
        }

        private static ListXpnHostsPage createEmptyPage() {
            return new ListXpnHostsPage(null, null);
        }

        protected ListXpnHostsPage createPage(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, XpnHostList response) {
            return new ListXpnHostsPage(context, response);
        }

        public ApiFuture<ListXpnHostsPage> createPageAsync(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListXpnHostsPagedResponse
    extends AbstractPagedListResponse<ListXpnHostsProjectsRequest, XpnHostList, Project, ListXpnHostsPage, ListXpnHostsFixedSizeCollection> {
        public static ApiFuture<ListXpnHostsPagedResponse> createAsync(PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            ApiFuture<ListXpnHostsPage> futurePage = ListXpnHostsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListXpnHostsPage, ListXpnHostsPagedResponse>(){

                public ListXpnHostsPagedResponse apply(ListXpnHostsPage input) {
                    return new ListXpnHostsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListXpnHostsPagedResponse(ListXpnHostsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListXpnHostsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetXpnResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage, GetXpnResourcesFixedSizeCollection> {
        private GetXpnResourcesFixedSizeCollection(List<GetXpnResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetXpnResourcesFixedSizeCollection createEmptyCollection() {
            return new GetXpnResourcesFixedSizeCollection(null, 0);
        }

        protected GetXpnResourcesFixedSizeCollection createCollection(List<GetXpnResourcesPage> pages, int collectionSize) {
            return new GetXpnResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetXpnResourcesPage
    extends AbstractPage<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage> {
        private GetXpnResourcesPage(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            super(context, (Object)response);
        }

        private static GetXpnResourcesPage createEmptyPage() {
            return new GetXpnResourcesPage(null, null);
        }

        protected GetXpnResourcesPage createPage(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            return new GetXpnResourcesPage(context, response);
        }

        public ApiFuture<GetXpnResourcesPage> createPageAsync(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetXpnResourcesPagedResponse
    extends AbstractPagedListResponse<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesPage, GetXpnResourcesFixedSizeCollection> {
        public static ApiFuture<GetXpnResourcesPagedResponse> createAsync(PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            ApiFuture<GetXpnResourcesPage> futurePage = GetXpnResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<GetXpnResourcesPage, GetXpnResourcesPagedResponse>(){

                public GetXpnResourcesPagedResponse apply(GetXpnResourcesPage input) {
                    return new GetXpnResourcesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private GetXpnResourcesPagedResponse(GetXpnResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetXpnResourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

